<?php

namespace Task;

class Tool {
	
	public static function xml2Array($xml){ 
        $obj = simplexml_load_string($xml,"SimpleXMLElement", LIBXML_NOCDATA);
        return json_decode(json_encode($obj),true);
	}

	public static function array2Xml($data, $root=true) {
		$str = '';
		if ($root) $str .= '<xml>';

		foreach ($dat as $key=>$val) {
			if (is_array($val)) {
				$child = self::array2Xml($val, false);
				$str .= "<$key>$child</$key>";
			} else {
				$str .= "<$key><![CDATA[$val]]></$key>";
			}
		}

		if ($root) $str .= '</xml>';
		return $str;
    }
    
	public static function cleanSpace($param) {
		return str_replace([" ","　","\t","\n","\r"], '', $param);
    }

    private static function loop_get($config, $array) {
        foreach ($array as $k=>$v) {
            if (!isset($array[$k+1])) {
                return $config[$v] ?? '全局返回值不存在';
            } else {
                unset($array[$k]);
                if (!isset($config[$v])) return '全局返回值不存在';
                
                return self::loop_get($config[$v], $array);
            }
        }
        return '全局返回值不存在';
    }

    public static function evalRun($param, $api_info=[], $global_return=[], $curl_data=[], $header_data=[]) {
        if (empty($param)) return $param;

        $vif_param = self::cleanSpace($param);

        if ((stripos($vif_param, '{$')) === 0 && (substr_compare($vif_param, '}', -strlen('}')) === 0)) {
            $name = substr($vif_param, 2, -1); 
            $Db = new \x\Db();
            $val = $Db->name('test_variable')->where('name', $name)->value('val');
            $Db->return();
            if ($val) {
                return $val;
            }

            return '自定义变量不存在';
        }

        if ((stripos($vif_param, '[$')) === 0 && (substr_compare($vif_param, ']', -strlen(']')) === 0)) {
            $name = substr($vif_param, 2, -1); // 
            if (strpos($name, '.') !== false) {
                return self::loop_get($global_return, explode('.', $name));
            } else if (isset($global_return[$name])) {
                return $global_return[$name];
            }

            return '全局返回值不存在';
        }

        if (substr_compare($vif_param, '()', -strlen('()')) === 0) {
            if (function_exists('eval') == false) {
                // return 'eval()函数已被禁用';
            }
            $name = substr($vif_param, 0, -2);
            $Db = new \x\Db();
            $content = $Db->name('test_function')->where('name', $name)->value('content');
            if (!$content) {
                $Db->return();
                return '自定义函数不存在';
            }
            if (stripos($content, '{$') !== false) {
                $list = $Db->name('test_variable')->field('name, val')->select();
                foreach ($list as $v) {
                    $content = str_replace('{$'.$v['name'].'}', $v['val'], $content);
                }
            }
            $Db->return();
            if (stripos($content, '<?php') === 0) {
                $needle = "<?php";
                $content = substr_replace($content, "", 0, strlen($needle));
            }
            $fun = 'swoolex_test_'.$name;
            if (!function_exists($fun)) {
                $code = 'function '.$fun.'($api_info, $curl_data, $header_data) {'.$content.'}';
                eval($code);
            }
            return $fun($api_info, $curl_data, $header_data);
        }
        
        return $param;
    }

}  
