<?php
namespace Task;

class Usecase {

	public function run($usecase_id) {
        $Db = new \x\Db();
		$field = 'A.*, B.title as api_title, B.host_url, B.domain_id as domain_id, B.return_id as return_id, B.request_type, B.param_type, C.domain_id as domain_id2, C.return_id as return_id2';
		$usecase_info = $Db->name('test_usecase')->alias('A')
					 ->join('api B', 'A.api_id=B.id')
					 ->join('item C', 'A.item_id=C.id')
					 ->where('A.id', $usecase_id)
                     ->field($field)
                     ->find();
        if ($usecase_info['domain_id3']) {
            $domain_info = $Db->name('domain')->where('id', $usecase_info['domain_id3'])->find();
        } else if ($usecase_info['domain_id']) {
            $domain_info = $Db->name('domain')->where('id', $usecase_info['domain_id'])->find();
        } else {
            $domain_info = $Db->name('domain')->where('id', $usecase_info['domain_id2'])->find();
        }
        $domain = $domain_info['domain'];

        $usecase_info['host_url'] = $domain.$usecase_info['host_url'];
        if ($usecase_info['return_id']) {
            $return_type = $Db->name('return')->where('id', $usecase_info['return_id'])->value('return_type');
            $return_list = $Db->name('return_field')->where('pid', $usecase_info['return_id'])->field('field, is_code, is_data')->select();
        } else {
            $return_type = $Db->name('return')->where('id', $usecase_info['return_id2'])->value('return_type');
            $return_list = $Db->name('return_field')->where('pid', $usecase_info['return_id2'])->field('field, is_code, is_data')->select();
        }
        $usecase_info['return_type'] = $return_type;
        $usecase_info['return_code_field'] = '';
        $usecase_info['return_data_field'] = '';
        foreach ($return_list as $val) {
            if ($val['is_code'] == 1) {
                $usecase_info['return_code_field'] = $val['field'];
            } else if ($val['is_data'] == 1) {
                $usecase_info['return_data_field'] = $val['field'];
            }
        }
        $body = $Db->name('api_body')->where('api_id', $usecase_info['api_id'])->field('id, pid, field, param_type')->order('id ASC')->select();
        $usecase_info['body_param'] = $this->recursion($Db, $usecase_id, $body);
        $usecase_info['request_param'] = $Db->name('api_request')->where('api_id', $usecase_info['api_id'])->field('field')->select();
        $usecase_info['code_param'] = $Db->name('test_usecase_code')->where('usecase_id', $usecase_id)->where('yes', 1)->field('code')->select();
        unset($usecase_info['domain_id']);
        unset($usecase_info['domain_id2']);
        unset($usecase_info['domain_id3']);
        unset($usecase_info['return_id']);
        unset($usecase_info['return_id2']);
        $usecase_info['usecase_id'] = $usecase_info['id'];

        $request = $Db->name('test_usecase_request')->where('usecase_id', $usecase_info['id'])->select();
        $env_request = $Db->name('test_usecase_env_request')->where('item_id', $usecase_info['item_id'])->where('domain_id', $domain_info['id'])->select();
        foreach ($env_request as $v) {
            foreach ($request as $k=>$vv) {
                if ($vv['field'] == $v['field']) {
                    if ($vv['value'] === '' || $vv['value'] === null) {
                        $request[$k]['value'] = $v['value'];
                    }
                    if ($vv['at_value'] === '' || $vv['at_value'] === null) {
                        $request[$k]['at_value'] = $v['at_value'];
                    }
                    break;
                }
            }
        }
        if ($request) $usecase_info['request_param'] = $request;

        $Db->return();
        return $usecase_info;
    }
    
    public function recursion($Db, $usecase_id, $array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0, $cid=0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == 0) $cid = 0;
            $info = $Db->name('test_usecase_param')->where('usecase_id', $usecase_id)->where('pid', $cid)->where('field', $v['field'])->field('id, value, at_value')->find();
            if ($info) {
                $v['value'] = $info['value'];
                $v['at_value'] = $info['at_value'];
                if ($Db->name('test_usecase_param')->where('usecase_id', $usecase_id)->where('pid', $info['id'])->field('id')->find()) {
                    $cid = $info['id'];
                }
            } else {
                $cid = 0;
            }
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($Db, $usecase_id, $array, $field1, $field2, $menu, $v[$field1], $cid);
                $arr[] = $v;
            }
        }
        return $arr;
    }
}  
