var ace_editor;
var ace_language;
var $ = parent.$;
$(function(){
    //初始化对象
    ace_editor = ace.edit('file_area');

    //设置风格和语言（更多风格和语言，请到github上相应目录查看）
    theme = "monokai"; //黑色主题
    // theme = "clouds"; //白色主题
    language = "php";

    ace_editor.setTheme("ace/theme/" + theme);

    // 文件类型到ace文件标识
    var language_map = {
        js: 'javascript',
        htm: 'html',
        md: 'markdown'
    };

    if(language){
        if (typeof language_map[language] !== "undefined") {
            language = language_map[language];
        }
        ace_editor.session.setMode("ace/mode/" + language);
    }

    // //字体大小
    ace_editor.setFontSize(14);

    // 设置改编辑器的内容
    ace_editor.setValue(`<?php
`);

    // //自动换行,设置为off关闭
    ace_editor.setOption("wrap", "free");

    //启用提示菜单
    ace_language = ace.require("ace/ext/language_tools");
    ace_editor.setOptions({
        enableBasicAutocompletion: true,
        enableSnippets: true,
        enableLiveAutocompletion: true
    });

    ace_editor.commands.addCommand({
        name: 'close',
        bindKey: {win: 'Ctrl-W',  mac: 'Command-W'},
        exec: function(editor) {
            parent.global_closeOpenWindow();
        }
    });
    ace_editor.commands.addCommand({
        name: 'close2',
        bindKey: {win: 'Esc',  mac: 'Esc'},
        exec: function(editor) {
            parent.global_closeOpenWindow();
        }
    });
    ace_editor.commands.addCommand({
        name: 'toNextLine',
        bindKey: {win: 'Shift+Enter',  mac: ''},
        exec: function(_editor) {
            _ace_editor.selection.clearSelection();
            _ace_editor.navigateLineEnd();
            _ace_editor.insert("\n");
        }
    });

    ace_editor.commands.addCommand({
        name: "showKeyboardShortcuts",
        bindKey: {win: "Ctrl-Alt-h", mac: "Command-Alt-h"},
        exec: function(editor) {
            ace.config.loadModule("ace/ext/keybinding_menu", function(module) {
                module.init(editor);
                ace_editor.showKeyboardShortcuts()
            })
        }
    })

    ace_editor.commands.addCommand({
        name: "yao_addselect_next",
        bindKey: {win: "Alt+J", mac: ""},
        exec: function(editor) {
            ace_editor.selectMore(1);
        }
    })

    ace_editor.commands.addCommands([{
        name: "showSettingsMenu",
        bindKey: {win: "Ctrl-q", mac: "Ctrl-q"},
        exec: function(editor) {
            ace_editor.showSettingsMenu();
        },
        readOnly: true
    }]);

})