
$(function(){
    
    $('.ma-button-right').click(function(){
        var t = $('.ma-skin-selector');
        if(t.is(':hidden')){t.show()}else{t.hide()}
    })
    
    $('.ma-skin-selector li').click(function(){
        $('.ma-skin-selector').hide();
        var t = $(this).text();
        switch (t) {
            case 'bright':
                $('#ViewTab').html(`body{
                    --BorderColor:#cdcdcd;
                    --Background:#f2f2f2;
                    --BackgroundRight:#fff;
                    --Color99:#6e6e6e;
                    --ColorBB:#000;
                    --ColorCC:#45494a;
                    --SelectedBg:#bdbdbd;
                    --SelectedBgColor:#000;
                    --ApiInfo:#f2f2f2;
                    --ApiInfoColor:#333;
                    --HoverBg:#e0e0e0;
                    --HoverColorFF:#333;
                    --HeaderBg:#f2f2f2;
                    --HeaderColor:#45494a;
                    --HeaderBc:#bdbdbd;
                    --HeaderBc2:#bdbdbd;
                    --IconColor:#7f7f7f;
                    --JiaoClor:#7b7b7b;
                    --LayuiDisabled:#333;
                    --IconBgColorHover:#bdbdbd;
                }`);
            break;
            case 'dark':
                $('#ViewTab').html(`body{
                    --BorderColor:#323232;
                    --Background:#3c3f41;
                    --BackgroundRight:#474b4e;
                    --Color99:#999;
                    --ColorBB:#bbb;
                    --ColorCC:#ccc;
                    --SelectedBg:#323232;
                    --SelectedBgColor:#fff;
                    --ApiInfo:#45494a;
                    --ApiInfoColor:#fff;
                    --HoverBg:#0d293e;
                    --HoverColorFF:#fff;
                    --HeaderBg:#3c3f41;
                    --HeaderColor:#ccc;
                    --HeaderBc:#323232;
                    --HeaderBc2:#646464;
                    --IconColor:#aeb9c0;
                    --JiaoClor:#d6efff;
                    --LayuiDisabled:#d2d2d2;
                    --IconBgColorHover:#2d2f30;
                }`);
            break;
            default:
                alert('暂不支持');
            break;
        }
        ajax('/common/viewtab', 'post', {
            'type' : t
        }, true);
    })
    
    $('#login-out').click(function(){
        $.alert({
            title: '确认退出？',
            content: '确认后将无法取消',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                  lightyear.loading('show');
                  window.location.href="/login/out"
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    
    $('#pwd-edit').click(function(){
        $('#pwd-edit-div').show();
    });
    $('#post-pwd-edit').click(function(){
        var array = ajax('/common/pwd_edit', 'post', {
            'original_password' : $('#edit_pwd_1').val(),
            'password' : $('#edit_pwd_2').val(),
            'check_password' : $('#edit_pwd_3').val(),
        }, true);
        if (array !== false) {
            setTimeout(function () {
                window.location.href="/login/out"
            }, 700);
        }
    });
    
    $('#get-action').click(function(){
       $('#action-div').show();
    });
    
    $('.ma-icon-close').click(function(){
        $(this).parent().parent().parent().parent('.ma-dialog-wrapper').hide()
    })
    
    $('body>.ma-toolbar-container>li').click(function(){
        $('body>.ma-toolbar-container>li').removeClass('selected');
        $(this).addClass('selected');

        $('.main-body').hide();
        var t = $(this).attr('data-id');
        $('.'+t+'-main').show();
        $('.'+t+'-main li:eq(0)').click();
        
        $('.main-title').html($(this).text());

        eventlog('切换菜单界面');
    })
    
    $(document).bind("click",function(e){
        var target  = $(e.target);
        if(target.closest(".magic-contextmenu").length == 0){
            $(".magic-contextmenu").hide();
        }
    })
    
    $('.event-log').click(function(){
        $('#event-log').show();
        $('#event-log .ma-content').scrollTop( $('#event-log .ma-content')[0].scrollHeight );
    })
    
    $('#event-log .ma-icon-clear').click(function(){
        $('#event-log .ma-content').html('');
    })
    
    $('#event-log .ma-icon-minimize').click(function(){
        $('#event-log').hide();
    })
    
    $(document).bind("keydown", function(e) {
        
        if (e.ctrlKey && (e.which == 83)) {
            e.preventDefault();
            
            setTimeout(function() {
                $(".ma-icon-save").click();
            }, 100);
            return false;
        }
        
        if (e.ctrlKey && (e.which == 81)) {
            $('#api-preview').find('i').click();
            return false;
        }
    });
    
    $('.ma-bottom-container .ma-bottom-tab li').click(function(){
        if ($(this).hasClass('event-log')) return false;
        if ($(this).hasClass('help-btn')) return false;
        if ($(this).hasClass('import-json')) return false;
        if ($(this).hasClass('version-send')) return false;
        if ($(this).hasClass('header-add-btn')) return false;
        $('.ma-bottom-container .ma-bottom-tab li').removeClass('selected');
        $(this).addClass('selected');

        $('.ma-bottom-container .menu-list').hide();
        $('.'+$(this).attr('data-id')).show();
    })
})

function trash_select(type) {
    $('#trash-select').show();
    var info = ajax('/trash/select', 'post', {type:type}, false);
    console.log(info);

    var html = '';
    info.forEach(v => {
        html += `<tr>
                    <td>`+v.id+`</td>
                    <td>`+v.title+`</td>
                    <td>`+v.create_time+`</td>
                    <td>
                        <span onclick="trash_recovery(`+v.id+`)" title="恢复" style="cursor: pointer;"><svg t="1646032466929" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http:
                        <span onclick="trash_delete(`+v.id+`)" title="删除" style="cursor: pointer;"><svg t="1646032549115" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http:
                    </td>
                </tr>`
    });
    $('#trash_list').html(html);
}

function trash_recovery(id) {
    $.alert({
        title: '确认恢复该记录？',
        content: '恢复成功后，会同时删除该回收记录',
        buttons: {
          confirm: {
            text: '确认',
            btnClass: 'btn-primary',
            action: function(){
                var info = ajax('/trash/recovery', 'post', {id:id}, true);
                if (info !== false) {
                    trash_select(info.type);
                    
                    if (info['type'] == 1) {
                        $('.ma-icon-refresh').click();
                    }
                }
            }
          },
          cancel: {text: '取消'}
        }
    });
}

function trash_delete(id) {
    $.alert({
        title: '确认删除？',
        content: '删除后数据将不可恢复',
        buttons: {
          confirm: {
            text: '确认',
            btnClass: 'btn-primary',
            action: function(){
                var info = ajax('/trash/delete', 'post', {id:id}, true);
                if (info !== false) {
                    trash_select(info.type);
                }
            }
          },
          cancel: {text: '取消'}
        }
    });
}