

var rest_id = 0;
var param_id = 0;
var request_id = 0;
var return_request_id = 0;
var return_id = 0;
var code_id = 0;
var success_id = 0;
var error_id = 0;
var Restform = null;
var group_title = null;

$(function(){
    
    layui.use('form', function(){
        Restform = layui.form;
    });
    
    function app_start() {
        reloadDomainMenu();
        reloadReturnMenu();
        reloadStatusMenu();
        reloadDutyMenu();
        request_reload();
        return_request_reload();
        code_reload();
    }
    
    function reloadDutyMenu() {
        
        var array = ajax('/api/duty/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('初始化接口负责人选择器加载失败');
            return;
        }
        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<option value="`+array[i]['duty_name']+`">`+array[i]['duty_name']+`</option>`;
        }
        $('.duty_name').html(html);
    }
    
    function reloadStatusMenu() {
        var array = ajax('/api/status/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('初始化默认接口状态选择器加载失败');
            return;
        }
        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div style="float: left;margin-right: 15px;">
                        <input style="float: left;margin-top: 5px;" type="radio" name="status" value="`+array[i]['id']+`" `+(i==0 ? 'checked' : '')+`>
                        <label class="api-status-check" style="float: left;text-indent: 3px;width: auto;padding: 0;">`+array[i]['title']+`</label>
                        <span style="float: left;display: block;height: 10px;border-radius: 100%;width: 10px;margin-top:7px;background:`+array[i]['color']+`"></span>
                    </div>`;
        }
        $('#api-status-tab').html(html);
        $('.api-status-check').click(function(){
            $(this).prev('input').click();
        })
    }
    
    function reloadDomainMenu() {
        var array = ajax('/api/domain/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('初始化默认根域名列表加载失败');
            return;
        }
        let html = '';
        let html2 = '';
        for (let i = 0; i < array.length; i++) {
            html += `<option value="`+array[i]['id']+`">`+array[i]['title']+`</option>`;
            html2 += `<div style="color:var(--HeaderColor);width: 210px;padding: 5px 0;">
                        <input id="domain_id_`+array[i]['id']+`" type="checkbox" name="domain_list[]" value="`+array[i]['id']+`">
                        <span>`+array[i]['title']+`</span>
                    </div>`;
        }
        $('#domain_id').html(html);
        $('#domain_list').html(html2);
        html = '<option value="0">项目默认</option>'+html;
        $('.domain_id').html(html);
    }
    
    function reloadReturnMenu() {
        var array = ajax('/api/returns/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('初始化默认返回结构列表加载失败');
            return;
        }
        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<option value="`+array[i]['id']+`">`+array[i]['title']+`</option>`;
        }
        $('#return_id').html(html);
        html = '<option value="0">项目默认</option>'+html;
        $('.return_id').html(html);
    }
    
    function reloadItemTab() {
        var array = ajax('/api/item/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('TAB项目列表加载失败');
            return;
        }
        var uid = $('#api-tab-item').attr('data-id');
        let html = '';
        for (let i = 0; i < array.length; i++) {
            var cls = '';
            if (array[i]['id'] == uid) {
                cls = 'selected'
            }
            html += `<li data-id="`+array[i]['id']+`" data-token="`+array[i]['doc_id']+`" class="`+cls+`">`+array[i]['title']+`</li>`;
        }
        $('#api-tab-div ul').html(html);
        
        $('#api-tab-div li').click(function(){
            $('#api-tab-div').hide();
            $('#api-tab-div li').removeClass('selected');
            $(this).addClass('selected');
            $('#api-tab-item').attr('data-id', $(this).attr('data-id'));
            $('#api-tab-item').html($(this).html())
            $('#api-preview').attr('href', '/apidoc.html?token='+$(this).attr('data-token'));
            $('#api-dow-html').attr('href', '/api/api/export_html?token='+$(this).attr('data-token'));
            $('#api-dow-doc').attr('href', '/api/api/export_doc?token='+$(this).attr('data-token'));
            $('#api-dow-json').attr('href', '/api/api/export_json?token='+$(this).attr('data-token'));
            get_api_list({}, false);
            var info = ajax('/api/item/select', 'post', {id:$(this).attr('data-id'), 'type':'api'}, false);
            if (info !== false) {
                $('#api-version').html(info.code);
                $('#api-date').html(info.create_time);
            }
        })
        if (uid == false || uid == '' || uid == undefined) {
            $('#api-tab-div li:eq(0)').click();
        } else {
            $('#api-tab-div li').each(function(){
                if ($(this).attr('data-id') == uid) {
                    $(this).click();
                }
            })
        }
        eventlog('TAB项目列表加载完毕');
    }
    
    
    function get_api_list(data, status) {
        eventlog('正在请求接口列表');

        data.item_id = $('#api-tab-item').attr('data-id')
        var ID = '#api-list'
        var array = ajax('/api/api/showlist', 'post', data, status);
        if (array == false) {
            eventlog('接口列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let num = 0;
        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-item-header ma-tree-hover group-menu" data-id="`+array[i]['id']+`" title="`+array[i]['title']+`">
                    <i class="ma-icon click ma-icon-arrow-bottom"></i>
                    <i class="ma-icon ma-icon-list"></i>
                    <label>`+array[i]['title']+`</label>
                </div>`;
            num += array[i]['list'].length;
            if (array[i]['list'].length > 0) {
                html += `<div class="ma-tree-sub-items">`
                let arr = array[i]['list']
                for (let k = 0; k < arr.length; k++) {
                    if (arr[k]['type'] == 'GET') {
                        var clr = '#249C47';
                    } else if (arr[k]['type'] == 'POST') {
                        var clr = '#FFB400';
                    } else {
                        var clr = '#489DF6';
                    }
                    
                    html += `<div class="ma-tree-item api-menu" style="padding-left: 20px;" pid="`+arr[k]['group_id']+`" data-id="`+arr[k]['id']+`">
                                <div class="ma-tree-hover" data-id="`+arr[k]['id']+`" title="`+arr[k]['title']+`">
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="36" height="12" font-size="11" font-weight="bold">
                                        <text x="16" y="8" fill="`+clr+`" style="dominant-baseline: middle; text-anchor: middle;">`+arr[k]['type']+`</text>
                                    </svg>
                                    <label>`+arr[k]['title']+`</label>
                                    <span style="display:none">(`+arr[k]['host_url']+`)</span>
                                </div>
                            </div>`;
                }
                html += '</div>'
            }
        }
        $('#api-total font').html(num);
        $(ID).html(html);
        
        $(ID+' .click').unbind("mousedown").bind("mousedown", function (event) {
            if (event.which == 1) {
                let t = $(this).parent().attr('data-id');
                if ($(this).hasClass('ma-icon-arrow-bottom')) {
                    $(this).removeClass('ma-icon-arrow-bottom');
                    $(this).addClass('ma-icon-arrow-right');
                    $(ID+' .ma-tree-item').each(function(){
                        let str = $(this).attr('pid');
                        if (str == t) {
                            $(this).hide();
                        }
                    })
                } else {
                    $(this).removeClass('ma-icon-arrow-right');
                    $(this).addClass('ma-icon-arrow-bottom');
                    $(ID+' .ma-tree-item').each(function(){
                        let str = $(this).attr('pid');
                        if (str == t) {
                            $(this).find('.click').removeClass('ma-icon-arrow-right');
                            $(this).find('.click').addClass('ma-icon-arrow-bottom');
                            $(this).show();
                        }
                    })
                }
            }
            event.preventDefault();
            return false;
        })
        
        
        $(ID+" .group-menu").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .group-menu").unbind("mousedown").bind("mousedown", function (event) {
            group_title = $(this).text().replace(/\s+/g, '');
            
            if (event.which == 3) {
                $('body').attr('check-id', $(this).attr('data-id'))
                $('body').attr('data-pid', $(this).attr('data-id'));
                $('#group-which').show();
                $('#group-which').css('left',(event.pageX+15)+'px').css('top',getTop('#group-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $('.group').val(group_title);
            }
        });
        
        $(ID+" .api-menu").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .api-menu").unbind("mousedown").bind("mousedown", function (event) {
            
            if (event.which == 3) {
                $('body').attr('check-id', $(this).attr('data-id'))
                $('body').attr('data-pid', $(this).attr('data-id'));
                $('#api-which').show();
                $('#api-which').css('left',(event.pageX+15)+'px').css('top',getTop('#api-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $('.main-title').text('编辑接口 / '+$(this).find('label').text());
                
                $('.ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                get_api_info();
            }
        });
        eventlog('接口列表加载完毕');
        
        app_start();
        
        $(ID+" .api-menu").each(function(){
            if ($(this).attr('data-id') == data.id) {
                $(this).addClass('ma-tree-select');
                get_api_info();
            }
        })
    }
    
    function get_api_info() {
        $('body').attr('data-id', $('#api-list .ma-tree-select').attr('data-id'))
        
        var info = ajax('/api/api/info', 'post', {id:$('body').attr('data-id')}, false);
        console.log(info);

        
        $(":radio[name='status'][value='"+info.status+"']").prop("checked", "checked");
        $(":radio[name='param_type'][value='"+info.param_type+"']").prop("checked", "checked");
        $(".request_type option").prop("selected", "");
        $(".request_type option[value='"+info.request_type+"']").prop("selected", "selected");
        $('.title').val(info.title);
        $('.group').val(info.group);
        $('.host_url').val(info.host_url);
        $('.action').val(info.action);
        $('.des').val(info.des);
        $(".domain_id option").prop("selected", "");
        $(".domain_id option[value='"+info.domain_id+"']").prop("selected", "selected");
        $(".return_id option").prop("selected", "");
        $(".return_id option[value='"+info.return_id+"']").prop("selected", "selected");
        $(".display option").prop("selected", "");
        $(".display option[value='"+info.display+"']").prop("selected", "selected");
        $(".is_imitate_api option").prop("selected", "");
        $(".is_imitate_api option[value='"+info.is_imitate_api+"']").prop("selected", "selected");
        $('.imitate_route').val(info.imitate_route);
        $(".duty_name option").prop("selected", "");
        $(".duty_name option[value='"+info.duty_name+"']").prop("selected", "selected");
        
        if (info.content2 != null) {
            tinyMCE.editors[1].setContent(info.content2);
        } else {
            tinyMCE.editors[1].setContent('');
        }
        if (info.imitate_code == '' || info.imitate_code == null) {
            ace_editor.setValue(`<?php
`);
        } else {
            ace_editor.setValue(info.imitate_code);
        }


        
        
        var list = info.success_list;
        var i = 0;
        success_id = list.length;
        $('#success_list').html('');
        list.forEach(v => {
            var html = `<div style="width: 100%;" id="success_list_`+i+`"><div class="row">
            <div class="col2" style="padding: 0;padding-left: 15px;width: 150px;"><input class="form-control" name="success[`+i+`][scene]" value="`+(v.scene!= null ? v.scene: '')+`"></div>
            <div class="col2" style="padding: 0;width: 250px;"><input class="form-control" name="success[`+i+`][des]" value="`+(v.des!= null ? v.des: '')+`"></div>
            <div class="col2" style="padding: 0;width: 380px;"><textarea style="height: 150px;" class="form-control" name="success[`+i+`][json]">`+(v.json!= null ? v.json: '')+`</textarea></div>
            <div class="col2" style="padding: 0;display: flex;">
                <div style="padding: 2px 7px 0 7px;" class="btn btn-sm btn-error" onclick="$('#success_list_`+i+`').remove()" title="删除该节点">
                    <i class="ma-icon ma-icon-close"></i>
                </div>
                <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="success_adds(this)" title="添加相邻节点">
                    <i class="ma-icon ma-icon-plus"></i>
                </div>
            </div>
            </div></div>`
            $('#success_list').append(html);
            i++;
        });
        
        var list = info.error_list;
        var i = 0;
        error_id = list.length;
        $('#error_list').html('');
        list.forEach(v => {
            var html = `<div style="width: 100%;" id="error_list_`+i+`"><div class="row">
            <div class="col2" style="padding: 0;padding-left: 15px;width: 150px;"><input class="form-control" name="error[`+i+`][scene]" value="`+(v.scene!= null ? v.scene: '')+`"></div>
            <div class="col2" style="padding: 0;width: 250px;"><input class="form-control" name="error[`+i+`][des]" value="`+(v.des!= null ? v.des: '')+`"></div>
            <div class="col2" style="padding: 0;width: 380px;"><textarea style="height: 150px;" class="form-control" name="error[`+i+`][json]">`+(v.json!= null ? v.json: '')+`</textarea></div>
            <div class="col2" style="padding: 0;display: flex;">
                <div style="padding: 2px 7px 0 7px;" class="btn btn-sm btn-error" onclick="$('#error_list_`+i+`').remove()" title="删除该节点">
                    <i class="ma-icon ma-icon-close"></i>
                </div>
                <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="error_adds(this)" title="添加相邻节点">
                    <i class="ma-icon ma-icon-plus"></i>
                </div>
            </div>
            </div></div>`
            $('#error_list').append(html);
            i++;
        });
        
        var list = info.code_list;
        var i = 0;
        code_id = list.length;
        $('#code_list').html('');
        list.forEach(v => {
            var html = `<div style="width: 100%;" id="code_list_`+i+`"><div class="row">
                <div class="col2" style="padding: 0;padding-left: 15px;width: 200px;"><input class="form-control" name="code[`+i+`][code]" value="`+v.code+`"></div>
                <div class="col2" style="padding: 0;width: 300px;"><input class="form-control" name="code[`+i+`][msg]" value="`+(v.msg ? v.msg :'')+`"></div>
                <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="codee_type_`+i+`" name="code[`+i+`][type]">`+$('.type_list').html()+`</select></div>
                <div class="col2" style="padding: 0;position: relative;width:66px">
                    <input type="checkbox" lay-skin="primary" name="code[`+i+`][is_success]" value="1" `+(v.is_success==1?'checked':'')+`>
                    <div class="checkbos-tips" style="left: -13px;">是否成功条件<div class="corenr"></div></div>
                </div>
                <div class="col2" style="padding: 0;display: flex;">
                    <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#code_list_`+i+`').remove()" title="删除该节点">
                        <i class="ma-icon ma-icon-close"></i>
                    </div>
                    <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="code_adds(this)" title="添加相邻节点">
                        <i class="ma-icon ma-icon-plus"></i>
                    </div>
                </div>
                </div></div>`;
            $('#code_list').append(html);
            $('#codee_type_'+i+' option').prop("selected", "");
            $('#codee_type_'+i+' option[value="'+v.param_type+'"]').prop("selected", "selected");
            i++;
        });
        
        var list = info.request_list;
        var i = 0;
        request_id = list.length;
        $('#request_list').html('');
        list.forEach(v => {
            var html = `<div style="width: 100%;" id="request_list_`+i+`"><div class="row">
            <div class="col2" style="padding: 0;padding-left: 15px;width: 300px;"><input class="form-control" name="request[`+i+`][field]" value="`+v.field+`"></div>
            <div class="col2" style="padding: 0;"><input class="form-control" name="request[`+i+`][title]" value="`+((v.title!= null ? v.title: '') ? (v.title!= null ? v.title: '') :'')+`"></div>
            <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="request_type_`+i+`" name="request[`+i+`][type]">`+$('.type_list').html()+`</select></div>
            <div class="col2" style="padding: 0;position: relative;width:52px">
                <input type="checkbox" lay-skin="primary" name="request[`+i+`][no_null]" value="1" `+(v.no_null==1?'checked':'')+`>
                <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
            </div>
            <div class="col2" style="padding: 0;display: flex;">
                <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#request_list_`+i+`').remove()" title="删除该节点">
                    <i class="ma-icon ma-icon-close"></i>
                </div>
                <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="request_adds(this)" title="添加相邻节点">
                    <i class="ma-icon ma-icon-plus"></i>
                </div>
            </div>
            </div></div>`;
            $('#request_list').append(html);
            $('#request_type_'+i+' option').prop("selected", "");
            $('#request_type_'+i+' option[value="'+v.param_type+'"]').prop("selected", "selected");
            i++;
        });
        
        var list = info.return_request_list;
        var i = 0;
        return_request_id = list.length;
        $('#return_request_list').html('');
        list.forEach(v => {
            var html = `<div style="width: 100%;" id="return_request_list_`+i+`"><div class="row">
                <div class="col2" style="padding: 0;padding-left: 15px;width: 300px;"><input class="form-control" name="return_request[`+i+`][field]" value="`+v.field+`"></div>
                <div class="col2" style="padding: 0;"><input class="form-control" name="return_request[`+i+`][title]" value="`+((v.title!= null ? v.title: '') ? (v.title!= null ? v.title: '') :'')+`"></div>
                <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="return_request_type_`+i+`" name="return_request[`+i+`][type]">`+$('.type_list').html()+`</select></div>
                <div class="col2" style="padding: 0;position: relative;width:52px">
                    <input type="checkbox" lay-skin="primary" name="return_request[`+i+`][no_null]" value="1" `+(v.no_null==1?'checked':'')+`>
                    <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
                </div>
                <div class="col2" style="padding: 0;display: flex;">
                    <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#return_request_list_`+i+`').remove()" title="删除该节点">
                        <i class="ma-icon ma-icon-close"></i>
                    </div>
                    <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="return_request_adds(this)" title="添加相邻节点">
                        <i class="ma-icon ma-icon-plus"></i>
                    </div>
                </div>
            </div></div>`;

            $('#return_request_list').append(html);
            $('#return_request_type_'+i+' option').prop("selected", "");
            $('#return_request_type_'+i+' option[value="'+v.param_type+'"]').prop("selected", "selected");
            i++;
        });
        
        var list = info.param_list;
        param_id = 0;
        $('#param_list').html('');
        list.forEach(v => {
            var cid = '_'+param_id;
            var sid = '['+param_id+']';
            var html = `<div class="row" style="width: 100%;" id="param_list`+cid+`">
            <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - 570px);"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="param_fold(this)"></i><input style="width: calc(100% - 16px);" class="form-control" name="param`+sid+`[field]" value="`+v.field+`"></div>
            <div class="col2" style="padding: 0;"><input class="form-control" name="param`+sid+`[title]" value="`+(v.title!= null ? v.title: '')+`"></div>
            <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="param`+sid+`[default]" value="`+(v.default != null ? v.default : '')+`"></div>
            <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="param`+sid+`[type]" id="param_`+param_id+`">`+$('.type_list').html()+`</select></div>
            <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="param`+sid+`[size]" value="`+(v.size!= null ? v.size: '')+`"></div>
            <div class="col2" style="padding: 0;position: relative;width:52px">
                <input type="checkbox" lay-skin="primary" name="param`+sid+`[no_null]" value="1" `+(v.no_null==1?'checked':'')+`>
                <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
            </div>
            <div class="col2" style="padding: 0;display: flex;">
                <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#param_list`+cid+`').remove()" title="删除该节点">
                    <i class="ma-icon ma-icon-close"></i>
                </div>
                <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="param_adds(this)" title="添加相邻节点">
                    <i class="ma-icon ma-icon-plus"></i>
                </div>
                <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="param_adds2('`+sid+`', '`+cid+`', null, 1)" title="添加下级节点">
                    <i class="ma-icon ma-icon-arrow-bottom"></i>
                </div>
            </div>
            </div>`;

            $('#param_list').append(html);
            $('#param_'+param_id+' option').prop("selected", "");
            $('#param_'+param_id+' option[value="'+v.param_type+'"]').prop("selected", "selected");
            param_id++;

            body_insert(v.list, sid, cid, 1);
        });
        
        
        var list = info.return_list;
        return_id = 0;
        $('#return_list').html('');
        list.forEach(v => {
            var cid = '_'+return_id;
            var sid = '['+return_id+']';
            var html = `<div class="row" style="width: 100%;" id="return_list`+cid+`">
            <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - 570px);"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="return_fold(this)"></i><input style="width: calc(100% - 16px);" class="form-control" name="return`+sid+`[field]" value="`+v.field+`"></div>
            <div class="col2" style="padding: 0;"><input class="form-control" name="return`+sid+`[title]" value="`+(v.title!= null ? v.title: '')+`"></div>
            <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="return`+sid+`[default]" value="`+(v.default != null ? v.default : '')+`"></div>
            <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="return`+sid+`[type]" id="return_`+return_id+`">`+$('.type_list').html()+`</select></div>
            <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="return`+sid+`[size]" value="`+(v.size!= null ? v.size: '')+`"></div>
            <div class="col2" style="padding: 0;position: relative;width:52px">
                <input type="checkbox" lay-skin="primary" name="return`+sid+`[no_null]" value="1" `+(v.no_null==1?'checked':'')+`>
                <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
            </div>
            <div class="col2" style="padding: 0;display: flex;">
                <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#return_list`+cid+`').remove()" title="删除该节点">
                    <i class="ma-icon ma-icon-close"></i>
                </div>
                <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="return_adds(this)" title="添加相邻节点">
                    <i class="ma-icon ma-icon-plus"></i>
                </div>
                <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="return_adds2('`+sid+`', '`+cid+`', null, 1)" title="添加下级节点">
                    <i class="ma-icon ma-icon-arrow-bottom"></i>
                </div>
            </div>
            </div>`;

            $('#return_list').append(html);
            $('#return_'+return_id+' option').prop("selected", "");
            $('#return_'+return_id+' option[value="'+v.param_type+'"]').prop("selected", "selected");
            return_id++;

            return_insert(v.list, sid, cid, 1);
        });
        
        if (Restform) Restform.render();
    }
    
    function get_item_list(data,status) {
        eventlog('正在请求接口项目列表');

        var ID = '#item-list'
        var array = ajax('/api/item/showlist', 'post', data, status);
        if (array == false) {
            eventlog('接口项目列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-sub-items">
            <div class="ma-tree-item" title="点击编辑" data-id="`+array[i]['id']+`">
                <div class="ma-tree-hover">
                    <label>`+array[i]['title']+`</label>
                </div>
            </div>
        </div>`;
        }
        $(ID).html(html);

        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            
            if (event.which == 3) {
                $('body').attr('check-id', $(this).attr('data-id'))
                $('#item-which').show();
                $('#item-which').css('left',(event.pageX+15)+'px').css('top',getTop('#item-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $('.main-title').text('编辑项目 / '+$(this).find('label').text());

                $('body').attr('data-id', $(this).attr('data-id'))
                $('.ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                
                var info = ajax('/api/item/info', 'post', {id:$('body').attr('data-id')}, false);
                console.log(info);
                $('#item_name').val(info.title);
                $('#version').val(info.version);
                $('#pwd').val(info.pwd);
                $('#des').val(info.des);
                $("#domain_id option").prop("selected", "");
                $("#domain_id option[value='"+info.domain_id+"']").prop("selected", "selected");
                $("#return_id option").prop("selected", "");
                $("#return_id option[value='"+info.return_id+"']").prop("selected", "selected");
                $("#is_var option").prop("selected", "");
                $("#is_var option[value='"+info.is_var+"']").prop("selected", "selected");
                if (info.content) {
                    tinyMCE.editors[0].setContent(info.content);
                } else {
                    tinyMCE.editors[0].setContent('');
                }
                $("input[name='domain_list[]']").prop("checked", "");
                if (info.domain_list != null) {
                    info.domain_list += ',0'
                    var arr = info.domain_list.split(',');
                    arr.forEach(function(value, index){
                        $('#domain_id_'+value).prop("checked", "checked");
                    });
                }
                $('#cover_file').val('');
                $("#status option").prop("selected", "");
                $("#status option[value='"+info.status+"']").prop("selected", "selected");
            }
        });
        eventlog('接口项目列表加载完毕');
    }
    
    function get_domain_list(data,status) {
        eventlog('正在请求根域名列表');

        var ID = '#domain-list'
        var array = ajax('/api/domain/showlist', 'post', data, status);
        if (array == false) {
            eventlog('根域名列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-sub-items">
            <div class="ma-tree-item" title="点击编辑" data-id="`+array[i]['id']+`">
                <div class="ma-tree-hover">
                    <label>`+array[i]['title']+`</label>
                </div>
            </div>
        </div>`;
        }
        $(ID).html(html);

        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            
            if (event.which == 3) {
                $('body').attr('check-id', $(this).attr('data-id'))
                $('#domain-which').show();
                $('#domain-which').css('left',(event.pageX+15)+'px').css('top',getTop('#domain-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $('.main-title').text('编辑根域名 / '+$(this).find('label').text());

                $('body').attr('data-id', $(this).attr('data-id'))
                $('.ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                
                var info = ajax('/api/domain/info', 'post', {id:$('body').attr('data-id')}, false);
                console.log(info);
                $('#domain_name').val(info.title);
                $('#domain_url').val(info.domain);
            }
        });
        eventlog('根域名列表加载完毕');
    }
    
    function get_rest_list(data,status) {
        eventlog('正在请求接口返回结构列表');

        var ID = '#rest-list'
        var array = ajax('/api/returns/showlist', 'post', data, status);
        if (array == false) {
            eventlog('接口返回结构列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-sub-items">
            <div class="ma-tree-item" title="点击编辑" data-id="`+array[i]['id']+`">
                <div class="ma-tree-hover" style="display:flex">
                    <label style="text-indent: 3px;">`+array[i]['title']+`</label><span>(`+array[i]['type']+`)</span>
                </div>
            </div>
        </div>`;
        }
        $(ID).html(html);

        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            
            if (event.which == 3) {
                $('body').attr('check-id', $(this).attr('data-id'))
                $('#rest-which').show();
                $('#rest-which').css('left',(event.pageX+15)+'px').css('top',getTop('#rest-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                
                $('.main-title').text('编辑返回值结构 / '+$(this).find('label').text());

                $('body').attr('data-id', $(this).attr('data-id'))
                $('.ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                
                var info = ajax('/api/returns/info', 'post', {id:$('body').attr('data-id')}, false);
                console.log(info);
                $('#rest_name').val(info.title);
                $(":radio[class='rest-status'][value='"+info.status+"']").prop("checked", "checked");
                $(":radio[class='rest-type'][value='"+info.return_type+"']").prop("checked", "checked");
                var list = info.list;
                var i = 0;
                rest_id = list.length;
                $('#rest_from_list').html('');
                list.forEach(v => {
                    var is_code = '';
                    var is_data = '';
                    if (v.is_code==1) is_code = 'checked'
                    if (v.is_data==1) is_data = 'checked'
                    var html = `<div class="row" id="rest_list_`+i+`">
                        <div class="col2" style="padding: 0;padding-left: 15px;"><input class="form-control" name="list[`+i+`][field]" value="`+v.field+`"></div>
                        <div class="col2" style="padding: 0;"><input class="form-control" name="list[`+i+`][title]" value="`+((v.title!= null ? v.title: '')!=null?(v.title!= null ? v.title: ''):'')+`"></div>
                        <div class="col2" style="padding: 0;position: relative;width:24px">
                            <input type="checkbox" lay-skin="primary" name="list[`+i+`][is_code]" value="1" `+is_code+`>
                            <div class="checkbos-tips">是否Code字段<div class="corenr"></div></div>
                        </div>
                        <div class="col2" style="padding: 0;position: relative;">
                            <input type="checkbox" lay-skin="primary" name="list[`+i+`][is_data]" value="1" `+is_data+`>
                            <div class="checkbos-tips">是否Data字段<div class="corenr"></div></div>
                        </div>
                        <div class="col2" style="padding: 0;display: flex;">
                            <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#rest_list_`+i+`').remove()" title="删除该节点">
                                <i class="ma-icon ma-icon-close"></i>
                            </div>
                            <div style="padding: 0px;" class="btn btn-sm btn-primary" onclick="rest_adds(this)" title="添加相邻节点">
                                <i class="ma-icon ma-icon-plus"></i>
                            </div>
                        </div>
                    </div>`
                    $('#rest_from_list').append(html);
                    i++;
                });
                Restform.render('checkbox');
            }
        });
        eventlog('接口返回结构列表加载完毕');
    }
    
    function get_status_list(data,status) {
        eventlog('正在请求接口状态列表');

        var ID = '#status-list'
        var array = ajax('/api/status/showlist', 'post', data, status);
        if (array == false) {
            eventlog('接口状态列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-sub-items">
            <div class="ma-tree-item" title="点击编辑" data-id="`+array[i]['id']+`">
                <div class="ma-tree-hover" style="display:flex">
                    <span style="display: block;height: 10px;border-radius: 100%;width: 10px;margin-top:13px;background:`+array[i]['color']+`"></span><label style="text-indent: 3px;">`+array[i]['title']+`</label>
                </div>
            </div>
        </div>`;
        }
        $(ID).html(html);

        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            
            if (event.which == 3) {
                $('body').attr('check-id', $(this).attr('data-id'))
                $('#status-which').show();
                $('#status-which').css('left',(event.pageX+15)+'px').css('top',getTop('#status-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $('.main-title').text('编辑接口状态 / '+$(this).find('label').text());

                $('body').attr('data-id', $(this).attr('data-id'))
                $('.ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                
                var info = ajax('/api/status/info', 'post', {id:$('body').attr('data-id')}, false);
                console.log(info);
                $('#status_name').val(info.title);
                $('#status_color').val(info.color);
            }
        });
        eventlog('接口状态列表加载完毕');
    }

    
    $('#api-tab-item').click(function(){
        var t = $('#api-tab-div');
        if(t.is(':hidden')){t.show()}else{t.hide()}
    })
    
    reloadItemTab();
    get_api_list({}, false);

    
    $('#click-duty').click(function(){
        $('#post-duty').html('提交创建');
        var ID = '#add-duty'
        $(ID).show()
        
        var array = ajax('/api/duty/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('API负责人列表加载失败');
            $(ID+' ul').html('暂无数据');
            return;
        }

        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<li data-id="`+array[i]['id']+`"><span>`+array[i]['duty_name']+`</span> <i class="ma-icon ma-icon-delete"></i></li>`;
        }
        $(ID+' ul').html(html);

        
        
        $(ID+' li span').click(function(){
            $('#post-duty').html('提交修改');
            $(ID+' li').removeClass('selected');
            $(this).parent().addClass('selected');
            $('#post-duty').html('提交修改');
            $('#from_duty_name').val($(this).html());
        })
        
        $(ID+' li .ma-icon-delete').click(function(){
            eventlog('点击删除负责人员');
            var data = {id:$(this).parent().attr('data-id')}
            $.alert({
                title: '确认删除？',
                content: '删除后数据将不可恢复',
                buttons: {
                  confirm: {
                    text: '确认',
                    btnClass: 'btn-primary',
                    action: function(){
                        eventlog('确认删除负责人员');
                        var array = ajax('/api/duty/delete', 'post', data, true);
                        if (array !== false) {
                            $('#click-duty').click();
                        }
                    }
                  },
                  cancel: {text: '取消'}
                }
            });
        })
        
        eventlog('API负责人列表加载完毕');
    })
    
    $('#post-duty').click(function(){
        var data = {}
        data.duty_name = $('#from_duty_name').val()
        
        if ($('#add-duty li').hasClass('selected')) {
            eventlog('请求编辑负责人员信息');
            data.id = $('#add-duty .selected').attr('data-id');
            var array = ajax('/api/duty/update', 'post', data, true);
        } else {
            eventlog('请求创建负责人员');
            var array = ajax('/api/duty/insert', 'post', data, true);
            if (array !== false) {
                $('#from_duty_name').val('')
            }
        }
        if (array !== false) {
            $('#click-duty').click();
        }
    })
    
    $('.ma-toolbar-container li').click(function(){
        $('#api-preview').hide();
        $('#api-dow-html').hide();
        $('#api-dow-doc').hide();
        $('#api-dow-json').hide();
        $('#api-trash').hide();
        $('.import-json').hide();
        $('.version-send').hide();
        var t = $(this).attr('data-id');
        switch (t) {
            case 'api': 
                get_api_list({}, false); 
                $('#api-preview').show();
                $('#api-dow-html').show();
                $('#api-dow-doc').show();
                $('#api-dow-json').show();
                $('#api-trash').show();
                $('.import-json').show();
                $('.version-send').show();
            break;
            case 'item': 
                $('.'+t+'-main').find('.ma-icon-plus').click();
                get_item_list({}, false); 
                reloadDomainMenu();
                reloadReturnMenu();
            break;
            case 'domain': 
                $('.'+t+'-main').find('.ma-icon-plus').click();
                get_domain_list({}, false); 
            break;
            case 'rest': 
                $('.'+t+'-main>.ma-tree-wrapper>.ma-tree-toolbar>div>.ma-tree-toolbar-btn>.ma-icon-plus').click();
                get_rest_list({}, false); 
            break;
            case 'status': 
                $('.'+t+'-main').find('.ma-icon-plus').click();
                get_status_list({}, false); 
            break;
        }
    })
    
    $('.ma-icon-refresh').click(function(){
        var t = $('.ma-toolbar-container .selected').attr('data-id');
        switch (t) {
            case 'api': get_api_list({}, false); break;
            case 'item': get_item_list({}, false); break;
            case 'domain': get_domain_list({}, false); break;
            case 'rest': get_rest_list({}, false); break;
            case 'status': get_status_list({}, false); break;
        }
    })
    
    $('.main-body>.ma-tree-wrapper>.ma-tree-toolbar>div>.ma-tree-toolbar-btn>.ma-icon-plus').click(function(){
        lightyear.notify('初始化表单', 'success', 300);
        var t = $('.ma-toolbar-container .selected').attr('data-id');
        $('body').attr('data-id', '');
        switch (t) {
            case 'api':
                reloadStatusMenu();
                break;
            case 'item':
                $('.main-title').text('创建新项目');
                $('#item_name').val('');
                $('#version').val('');
                $('#pwd').val('');
                $('#des').val('');
                $("#domain_id option").prop("selected", "");
                $("#return_id option").prop("selected", "");
                $("#is_var option").prop("selected", "");
                tinyMCE.editors[0].setContent('');
            break;
            case 'domain':
                $('.main-title').text('创建根域名');
                $('#domain_name').val('');
                $('#domain_url').val('');
            break;
            case 'rest':
                $('.main-title').text('创建返回值结构');
                $('#rest_name').val('');
                $(":radio[class='rest-status'][value='1']").prop("checked", "checked");
                $(":radio[class='rest-type'][value='1']").prop("checked", "checked");
                rest_id = 0;
                $('#rest_from_list').html('');
                if (Restform) Restform.render();
            break;
            case 'status':
                $('.main-title').text('创建API状态');
                $('#status_name').val('');
                $('#status_color').val('');
            break;
        }
    })

    
    $('.ma-icon-save').click(function(){
        var data = {}
        var id = $('body').attr('data-id');
        
        if ($('#add-duty').is(':hidden')==false) {
            $('#post-duty').click();
            return false;
        }

        var t = $('.ma-toolbar-container .selected').attr('data-id');
        
        switch (t) {
            case 'api':
                var data = new FormData($("#api-ajax")[0]);
                data.append('content2', tinyMCE.editors[1].getContent())
                data.append('imitate_code', ace_editor.getValue())

                if (id == '') {
                    data.append('item_id', $('#api-tab-item').attr('data-id'));
                    eventlog('请求创建接口');
                    var array = ajax2('/api/api/insert', 'post', data, true);
                    if (array !== false) {
                        get_api_list({}, false);
                    }
                } else {
                    data.append('id', id);
                    eventlog('请求修改接口信息');
                    var array = ajax2('/api/api/update', 'post', data, true);
                    if (array !== false) {
                        $('#api-list .ma-tree-select .ma-tree-hover').attr('title', $('.title').val());
                        $('#api-list .ma-tree-select label').text($('.title').val());
                        $('#api-list .ma-tree-select svg text').text($('.request_type option:selected').text());
                    }
                }
            break;
            case 'item':
                var fd = new FormData()
                fd.append('title', $('#item_name').val())
                fd.append('pwd', $('#pwd').val())
                fd.append('domain_id', $('#domain_id').val())
                fd.append('return_id', $('#return_id').val())
                fd.append('is_var', $('#is_var').val())
                fd.append('des', $('#des').val())
                fd.append('version', $('#version').val())
                fd.append('content', tinyMCE.activeEditor.getContent())
                fd.append('status', $('#status').val())
                var files = $('#cover_file')[0].files
                fd.append('cover_file', files[0])
                $('#cover_file').val('');
                
                var arr = [];
                $("input[name='domain_list[]']:checkbox").each(function(index) {
                    if ($(this).prop("checked") === true) {
                        arr.push($(this).val());
                    }
                });
                fd.append('domain_list', arr.join())

                if (id == '') {
                    eventlog('请求创建项目');
                    var array = ajax2('/api/item/insert', 'post', fd, true);
                    if (array !== false) {
                        get_item_list({}, false);
                    }
                } else {
                    fd.append('id', id)
                    eventlog('请求修改项目信息');
                    var array = ajax2('/api/item/update', 'post', fd, true);
                    if (array !== false) {
                        get_item_list({}, false);
                    }
                }
            break;
            case 'domain':
                data.title = $('#domain_name').val();
                data.domain = $('#domain_url').val();
                if (id == '') {
                    eventlog('请求创建根域名');
                    var array = ajax('/api/domain/insert', 'post', data, true);
                    if (array !== false) {
                        get_domain_list({}, false);
                    }
                } else {
                    data.id = id;
                    eventlog('请求修改根域名信息');
                    var array = ajax('/api/domain/update', 'post', data, true);
                    if (array !== false) {
                        get_domain_list({}, false);
                    }
                }
            break;
            case 'rest':
                var data = new FormData($("#rest-ajax")[0]);
                if (id == '') {
                    eventlog('请求创建返回结构');
                    var array = ajax2('/api/returns/insert', 'post', data, true);
                    if (array !== false) {
                        get_rest_list({}, false);
                    }
                } else {
                    data.append('id', id);
                    eventlog('请求修改返回结构信息');
                    var array = ajax2('/api/returns/update', 'post', data, true);
                    if (array !== false) {
                        get_rest_list({}, false);
                    }
                }
            break;
            case 'status':
                data.title = $('#status_name').val();
                data.color = $('#status_color').val();
                if (id == '') {
                    eventlog('请求创建接口状态');
                    var array = ajax('/api/status/insert', 'post', data, true);
                    if (array !== false) {
                        get_status_list({}, false);
                    }
                } else {
                    data.id = id;
                    eventlog('请求修改接口状态信息');
                    var array = ajax('/api/status/update', 'post', data, true);
                    if (array !== false) {
                        get_status_list({}, false);
                    }
                }
            break;
        }
    })
    
    $('#api-sou').bind("input propertychange", function() {
        var data = {
            'key':$(this).val()
        };
        get_api_list(data, false);
    })
    $('#item-sou').bind("input propertychange", function() {
        var data = {
            'key':$(this).val()
        };
        get_item_list(data, false);
    })
    $('#domain-sou').bind("input propertychange", function() {
        var data = {
            'key':$(this).val()
        };
        get_domain_list(data, false);
    })
    $('#rest-sou').bind("input propertychange", function() {
        var data = {
            'key':$(this).val()
        };
        get_rest_list(data, false);
    })
    $('#status-sou').bind("input propertychange", function() {
        var data = {
            'key':$(this).val()
        };
        get_status_list(data, false);
    })
    
    
    $('#item-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '删除后数据将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除项目');
                    var array = ajax('/api/item/delete', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_item_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    $('#domain-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '删除后数据将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除根域名');
                    var array = ajax('/api/domain/delete', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_domain_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    $('#rest-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '删除后数据将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除接口返回结构');
                    var array = ajax('/api/returns/delete', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_rest_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    $('#status-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '删除后数据将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除接口状态');
                    var array = ajax('/api/status/delete', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_status_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    $('#group-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '注意：删除后数据将不可恢复，并且<strong>会删除该分组下的所有接口</strong>！',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除接口分组');
                    var array = ajax('/api/group/delete', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_api_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    $('#api-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '注意：删除后数据将不可恢复！',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除接口');
                    var array = ajax('/api/api/delete', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_api_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    
    $('#api-which .copy').click(function(){
        $.alert({
            title: '确认复制该接口？',
            content: '注意：接口复制仅会Copy到文档相关信息，并不会复制到测试相关的内容！',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认复制接口');
                    var array = ajax('/api/api/copy', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_api_list({id:array.id}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    
    $('#api-which .copy-group').click(function(){
        var array = ajax('/api/group/showlist', 'post', {item_id:$('#api-tab-item').attr('data-id'), api_id:$('body').attr('check-id')}, false);
        if (array == false) {
            eventlog('分组获取失败');
            return;
        }
        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-item">
            <div class="ma-tree-item-header ma-tree-hover">
                <input type="checkbox" class="copy-id" value="`+array[i]['id']+`">
                <i class="ma-icon ma-icon-list"></i>
                <label>`+array[i]['title']+`</label>
            </div>
        </div>`;
        }
        $('#copy-api-group-list').html(html);
        $('#copy-api').show();
    })
    
    $('#post-api-copy-group').click(function(){
        let group_id = '';
        $('input[class="copy-id"]:checked').each(function(){
            if (group_id != '') group_id += ',';
            group_id += $(this).val();
        });
        if (group_id == '') {
            lightyear.notify('请先选择您要复制到的分组目录', 'danger', 700);
            return false;
        }
        var res = ajax('/api/api/copy', 'post', {group_id:group_id, id:$('body').attr('check-id')}, false);
        if (res !== false) {
            $('#copy-api').hide();
            get_api_list({id:res.id}, false);
        }
    })
    
    
    $('#api-which .move-group').click(function(){
        var array = ajax('/api/group/showlist', 'post', {item_id:$('#api-tab-item').attr('data-id'), api_id:$('body').attr('check-id')}, false);
        if (array == false) {
            eventlog('分组获取失败');
            return;
        }
        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-item">
            <div class="ma-tree-item-header ma-tree-hover">
                <input type="radio" name="move-id" value="`+array[i]['id']+`">
                <i class="ma-icon ma-icon-list"></i>
                <label>`+array[i]['title']+`</label>
            </div>
        </div>`;
        }
        $('#move-api-group-list').html(html);
        $('#move-api').show();
    })
    
    $('#post-api-move-group').click(function(){
        let group_id = $('input[name="move-id"]:checked').val();
        if (group_id == '' || group_id == null) {
            lightyear.notify('请先选择您要复制到的分组目录', 'danger', 700);
            return false;
        }
        var res = ajax('/api/api/move', 'post', {group_id:group_id, id:$('body').attr('check-id')}, false);
        if (res !== false) {
            $('#move-api').hide();
            get_api_list({}, false);
        }
    })

    
    $('#api-which .whole-url').click(function(){
        copyTxt(ajax('/api/api/get_url', 'post', {id:$('body').attr('check-id'), 'type':1}, false));
    })
    $('#api-which .part-url').click(function(){
        copyTxt(ajax('/api/api/get_url', 'post', {id:$('body').attr('check-id'), 'type':2}, false));
    })
    $('#api-which .shang').click(function(){
        var res = ajax('/api/api/sort', 'post', {id:$('body').attr('check-id'), 'type':1}, true)
        if (res !== false) {        
            $('#api-which').hide();
            get_api_list({}, false);
        }
    })
    $('#api-which .xia').click(function(){
        var res = ajax('/api/api/sort', 'post', {id:$('body').attr('check-id'), 'type':2}, true)
        if (res !== false) {        
            $('#api-which').hide();
            get_api_list({}, false);
        }
    })
    
    $('.ma-icon-folding').click(function(){
        var ID = '#api-list';
        $(ID+' .click').each(function(){
            let t = $(this).parent().attr('data-id');
            if ($(this).hasClass('ma-icon-arrow-bottom')) {
                $(this).removeClass('ma-icon-arrow-bottom');
                $(this).addClass('ma-icon-arrow-right');
                $(ID+' .ma-tree-item').each(function(){
                    let str = $(this).attr('pid');
                    if (str == t) {
                        $(this).hide();
                    }
                })
            } else {
                $(this).removeClass('ma-icon-arrow-right');
                $(this).addClass('ma-icon-arrow-bottom');
                $(ID+' .ma-tree-item').each(function(){
                    let str = $(this).attr('pid');
                    if (str == t) {
                        $(this).find('.click').removeClass('ma-icon-arrow-right');
                        $(this).find('.click').addClass('ma-icon-arrow-bottom');
                        $(this).show();
                    }
                })
            }
        });
    })
    
    $('.ma-icon-group-add').click(function(){
        $('body').attr('check-id', '')
        $('#add_group_name').val('')
        $('#add_group_sort').val(0)
        $('#add_group_des').val('')
        $('#post-group').html('提交创建');
        $('#add-group').show();
    })
    
    $('#post-group').click(function(){
        var data = {}
        var id = $('body').attr('check-id');
        data.title = $('#add_group_name').val()
        data.sort = $('#add_group_sort').val()
        data.des = $('#add_group_des').val()
        
        if (id == '') {
            data.item_id = $('#api-tab-item').attr('data-id')
            eventlog('请求创建接口分组');
            var array = ajax('/api/group/insert', 'post', data, true);
            if (array !== false) {
                get_api_list({}, false);
                $('#add-group').hide();
            }
        } else {
            data.id = id;
            eventlog('请求修改接口分组信息');
            var array = ajax('/api/group/update', 'post', data, true);
            if (array !== false) {
                get_api_list({}, false);
                $('#add-group').hide();
            }
        }
    })
    
    $('#group-which .update').click(function(){
        
        var info = ajax('/api/group/info', 'post', {id:$('body').attr('check-id')}, false);
        console.log(info);
        $('#add_group_name').val(info.title);
        $('#add_group_sort').val(info.sort);
        $('#add_group_des').val(info.des);
        $('#post-group').html('提交修改');
        $('#add-group').show();
    })
    
    $('#group-which .create').click(function(){
        $('body').attr('data-id', '');
        $('#api-list .api-menu').removeClass('ma-tree-select');
        $('#group-which').hide();
        
        $('.main-title').text('创建新接口 / '+group_title);

        $(":radio[name='status']:eq(0)").prop("checked", "checked");
        $(":radio[name='param_type']:eq(0)").prop("checked", "checked");
        $(".request_type option").prop("selected", "");
        $('.title').val('');
        $('.group').val(group_title);
        $('.host_url').val('');
        $('.action').val('');
        $(".domain_id option").prop("selected", "");
        $(".return_id option").prop("selected", "");
        $(".display option").prop("selected", "");
        $(".is_imitate_api option").prop("selected", "");
        $('.imitate_route').val('');
        $(".duty_name option").prop("selected", "");
        $('.des').val('');
        ace_editor.setValue(`<?php
`);

        $('#param_list').html('');
        $('#request_list').html('');
        $('#return_request_list').html('');
        $('#return_list').html('');
        $('#code_list').html('');
        $('#success_list').html('');
        $('#error_list').html('');
        tinyMCE.editors[1].setContent('');

        param_id = 0;
        request_id = 0;
        return_request_id = 0;
        return_id = 0;
        code_id = 0;
        success_id = 0;
        error_id = 0;

        app_start();
    })
    
    $('.import-json').click(function(e){
        $('#import-div').show();
        return false;
    })
    $('#import-div .ma-icon-help').click(function(e){
        $('#import-help').show();
        return false;
    })
    
    $('.version-send').click(function(e){
        $.alert({
            title: '确认发布新版本？',
            content: '版本发布后，版本记录将无法回退！',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    var info = ajax('/api/api/version_send', 'post', {item_id:$('#api-tab-item').attr('data-id')}, true);
                    if (info !== false) {
                        window.location.reload();
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
        return false;
    })
    $('#post-import').click(function(e){
        let json = $('#import_content').val();
        if (json == '') {
            lightyear.notify('请先填充需要解析的文本内容', 'danger', 700);
            return false;
        }
        let id = $('.api-main .selected').attr('data-id');
        
        if (id == 'api-data') {
            var tabs = 2;
        } else {
            var tabs = 1;
        }
        var array = ajax('/api/api/import_json', 'post', {json:json}, true);
        if (array == false) {
            return false;
        }
        let type = array.type;
        let list = array.list;

        if (tabs == 1) {
            $('#param_list').html('');
            list.forEach(v => {
                if (type == 1) {
                    var field = v;
                    var title = '';
                    var def = '';
                } else {
                    var field = (v.key!= null ? v.key: '')
                    var title = (v.description!= null ? v.description: '')
                    var def =  (v.value!= null ? v.value: '')
                }
                var cid = '_'+param_id;
                var sid = '['+param_id+']';
                var html = `<div style="width: 100%;" id="param_list_`+param_id+`"><div class="row">
                    <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - 570px);"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="param_fold(this)"></i><input style="width: calc(100% - 16px);"  class="form-control" name="param`+sid+`[field]" value="`+field+`"></div>
                    <div class="col2" style="padding: 0;"><input class="form-control" name="param`+sid+`[title]" value="`+title+`"></div>
                    <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="param`+sid+`[default]" value="`+def+`"></div>
                    <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="param`+sid+`[type]">`+$('.type_list').html()+`</select></div>
                    <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="param`+sid+`[size]" value=""></div>
                    <div class="col2" style="padding: 0;position: relative;width:52px">
                        <input type="checkbox" lay-skin="primary" name="param`+sid+`[no_null]" value="1">
                        <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
                    </div>
                    <div class="col2" style="padding: 0;display: flex;">
                        <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#param_list`+cid+`').remove()" title="删除该节点">
                            <i class="ma-icon ma-icon-close"></i>
                        </div>
                        <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="param_adds(this)" title="添加相邻节点">
                            <i class="ma-icon ma-icon-plus"></i>
                        </div>
                        <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="param_adds2('`+sid+`', '`+cid+`', null, 1)" title="添加下级节点">
                            <i class="ma-icon ma-icon-arrow-bottom"></i>
                        </div>
                    </div>
                </div></div>`
                $('#param_list').append(html);
                param_id++;
            });
        } else {
            $('#return_list').html('');
            list.forEach(v => {
                if (type == 1) {
                    var field = v;
                    var title = '';
                    var def = '';
                } else {
                    var field = (v.key!= null ? v.key: '')
                    var title = (v.description!= null ? v.description: '')
                    var def =  (v.value!= null ? v.value: '')
                }
                var html = `<div style="width: 100%;" id="return_list_`+return_id+`"><div class="row">
                    <div class="col2" style="padding: 0;padding-left: 15px;width: 200px;"><input class="form-control" name="return[`+return_id+`][field]" value="`+field+`"></div>
                    <div class="col2" style="padding: 0;"><input class="form-control" name="return[`+return_id+`][title]" value="`+title+`"></div>
                    <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="return[`+return_id+`][default]" value="`+def+`"></div>
                    <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="return_`+return_id+`" name="return[`+return_id+`][type]">`+$('.type_list').html()+`</select></div>
                    <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="return[`+return_id+`][size]"></div>
                    <div class="col2" style="padding: 0;position: relative;width:52px">
                        <input type="checkbox" lay-skin="primary" name="return[`+return_id+`][no_null]" value="1">
                        <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
                    </div>
                    <div class="col2" style="padding: 0;display: flex;">
                        <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#return_list_`+return_id+`').remove()" title="删除该节点">
                            <i class="ma-icon ma-icon-close"></i>
                        </div>
                        <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="return_adds(this)" title="添加相邻节点">
                            <i class="ma-icon ma-icon-plus"></i>
                        </div>
                        <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="return_adds2(`+return_id+`, null)" title="添加下级节点">
                            <i class="ma-icon ma-icon-arrow-bottom"></i>
                        </div>
                    </div>
                </div></div>`;
                $('#return_list').append(html);
                return_id++;
            });
        }

        if (Restform) Restform.render();
        $('#import-div').hide();
        return false;
    })
    $('.api-footer').css('display', 'initial')


var mytextarea = tinymce.init({
    selector: '#mytextarea',
    language:'zh_CN',
    directionality: 'ltl',
    browser_spellcheck: true,
    contextmenu: false,
    height: 480,
    plugins: [
        "advlist autolink lists link image charmap print preview anchor",
        "searchreplace visualblocks code fullscreen",
        "insertdatetime media table contextmenu paste imagetools wordcount",
        "code"
    ],
    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | code",
    images_upload_url: '/common/api_img',
});
var mytextarea2 = tinymce.init({
    selector: '#mytextarea2',
    language:'zh_CN',
    directionality: 'ltl',
    browser_spellcheck: true,
    contextmenu: false,
    height: 580,
    plugins: [
        "advlist autolink lists link image charmap print preview anchor",
        "searchreplace visualblocks code fullscreen",
        "insertdatetime media table contextmenu paste imagetools wordcount",
        "code"
    ],
    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | code",
    images_upload_url: '/common/api_img',
});
});


function rest_adds(_this) {
  var html = `<div class="row" id="rest_list_`+rest_id+`">
                <div class="col2" style="padding: 0;padding-left: 15px;"><input class="form-control" name="list[`+rest_id+`][field]"></div>
                <div class="col2" style="padding: 0;"><input class="form-control" name="list[`+rest_id+`][title]"></div>
                <div class="col2" style="padding: 0;position: relative;width:24px">
                    <input type="checkbox" lay-skin="primary" name="list[`+rest_id+`][is_code]" value="1">
                    <div class="checkbos-tips">是否Code字段<div class="corenr"></div></div>
                </div>
                <div class="col2" style="padding: 0;position: relative;">
                    <input type="checkbox" lay-skin="primary" name="list[`+rest_id+`][is_data]" value="1">
                    <div class="checkbos-tips">是否Data字段<div class="corenr"></div></div>
                </div>
                <div class="col2" style="padding: 0;display: flex;">
                    <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#rest_list_`+rest_id+`').remove()" title="删除该节点">
                        <i class="ma-icon ma-icon-close"></i>
                    </div>
                    <div style="padding: 0px;" class="btn btn-sm btn-primary" onclick="rest_adds(this)" title="添加相邻节点">
                        <i class="ma-icon ma-icon-plus"></i>
                    </div>
                </div>
              </div>`;
  rest_id++;
  if (_this == null) {
    $('#rest_from_list').append(html);
  } else {
    $(_this).parent().parent().after(html);
  }
  Restform.render('checkbox');
}


function param_adds(_this) {
    var cid = '_'+param_id;
    var sid = '['+param_id+']';
    var html = `<div class="row" style="width: 100%;" id="param_list`+cid+`">
    <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - 570px);"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="param_fold(this)"></i><input style="width: calc(100% - 16px);" class="form-control" name="param`+sid+`[field]"></div>
    <div class="col2" style="padding: 0;"><input class="form-control" name="param`+sid+`[title]"></div>
    <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="param`+sid+`[default]"></div>
    <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="param`+sid+`[type]">`+$('.type_list').html()+`</select></div>
    <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="param`+sid+`[size]"></div>
    <div class="col2" style="padding: 0;position: relative;width:52px">
        <input type="checkbox" lay-skin="primary" name="param`+sid+`[no_null]" value="1">
        <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
    </div>
    <div class="col2" style="padding: 0;display: flex;">
        <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#param_list`+cid+`').remove()" title="删除该节点">
            <i class="ma-icon ma-icon-close"></i>
        </div>
        <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="param_adds(this)" title="添加相邻节点">
            <i class="ma-icon ma-icon-plus"></i>
        </div>
        <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="param_adds2('`+sid+`', '`+cid+`', null, 1)" title="添加下级节点">
            <i class="ma-icon ma-icon-arrow-bottom"></i>
        </div>
    </div>
  </div>`;
  
    param_id++;
    if (_this == null) {
      $('#param_list').append(html);
    } else {
      $(_this).parent().parent().after(html);
    }
    if (Restform) Restform.render();
}
function param_adds2(id, kid, _this, level){
    var cid = kid+'_'+param_id;
    var sid = '['+param_id+']';
    var lt = (level*50);
    var width = 570+lt;
    var key = 'param_list'+cid;
    var html = `<div class="row" id="`+key+`" style="width:100%">
    <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - `+width+`px);margin-left: `+lt+`px;"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="param_fold(this)"></i><input style="width: calc(100% - 16px);" class="form-control" name="param`+id+sid+`[field]"></div>
    <div class="col2" style="padding: 0;"><input class="form-control" name="param`+id+sid+`[title]"></div>
    <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="param`+id+sid+`[default]"></div>
    <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="param`+id+sid+`[type]">`+$('.type_list').html()+`</select></div>
    <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="param`+id+sid+`[size]"></div>
    <div class="col2" style="padding: 0;position: relative;width:52px">
        <input type="checkbox" lay-skin="primary" name="param`+id+sid+`[no_null]" value="1">
        <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
    </div>
    <div class="col2" style="padding: 0;display: flex;">
        <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#`+key+`').remove()" title="删除该节点">
            <i class="ma-icon ma-icon-close"></i>
        </div>
        <div style="padding: 0px;" class="btn btn-sm btn-primary" onclick="param_adds2('`+id+`', '`+kid+`', this, `+level+`)" title="添加相邻节点">
            <i class="ma-icon ma-icon-plus"></i>
        </div>
    </div>
    <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="param_adds2('`+(id+sid)+`', '`+cid+`', null, `+(level+1)+`)" title="添加下级节点">
        <i class="ma-icon ma-icon-arrow-bottom"></i>
    </div>
</div>`;
    
    param_id++;
    if (_this == null) {
        $('#param_list'+kid).append(html);
    } else {
        $(_this).parent().parent().after(html);
    }
    if (Restform) Restform.render();
}

function request_adds(_this) {
    var html = `<div style="width: 100%;" id="request_list_`+request_id+`"><div class="row">
  <div class="col2" style="padding: 0;padding-left: 15px;width: 300px;"><input class="form-control" name="request[`+request_id+`][field]"></div>
  <div class="col2" style="padding: 0;"><input class="form-control" name="request[`+request_id+`][title]"></div>
  <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="request[`+request_id+`][type]">`+$('.type_list').html()+`</select></div>
  <div class="col2" style="padding: 0;position: relative;width:52px">
      <input type="checkbox" lay-skin="primary" name="request[`+request_id+`][no_null]" value="1">
      <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
  </div>
  <div class="col2" style="padding: 0;display: flex;">
      <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#request_list_`+request_id+`').remove()" title="删除该节点">
          <i class="ma-icon ma-icon-close"></i>
      </div>
      <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="request_adds(this)" title="添加相邻节点">
          <i class="ma-icon ma-icon-plus"></i>
      </div>
  </div>
</div></div>`;

    request_id++;
    if (_this == null) {
        $('#request_list').append(html);
    } else {
        $(_this).parent().parent().after(html);
    }
    if (Restform) Restform.render();
}

function request_reload() {
    $('#request_list').html('');
    
    var array = ajax('/api/api/get_request', 'post', {item_id:$('#api-tab-item').attr('data-id')}, false);
    if (array == false) {
        return;
    }
    request_id = array.length;
    var i = 0;
    array.forEach(v => {
        var html = `<div style="width: 100%;" id="request_list_`+i+`"><div class="row">
  <div class="col2" style="padding: 0;padding-left: 15px;width: 300px;"><input class="form-control" name="request[`+i+`][field]" value="`+v.field+`"></div>
  <div class="col2" style="padding: 0;"><input class="form-control" name="request[`+i+`][title]" value="`+((v.title!= null ? v.title: '') ? (v.title!= null ? v.title: '') :'')+`"></div>
  <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="request_type_`+i+`" name="request[`+i+`][type]">`+$('.type_list').html()+`</select></div>
  <div class="col2" style="padding: 0;position: relative;width:52px">
      <input type="checkbox" lay-skin="primary" name="request[`+i+`][no_null]" value="1" `+(v.no_null==1?'checked':'')+`>
      <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
  </div>
  <div class="col2" style="padding: 0;display: flex;">
      <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#request_list_`+i+`').remove()" title="删除该节点">
          <i class="ma-icon ma-icon-close"></i>
      </div>
      <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="request_adds(this)" title="添加相邻节点">
          <i class="ma-icon ma-icon-plus"></i>
      </div>
  </div>
</div></div>`;
        $('#request_list').append(html);
        $('#request_type_'+i+' option').prop("selected", "");
        $('#request_type_'+i+' option[value="'+v.param_type+'"]').prop("selected", "selected");
        if (Restform) Restform.render();
        i++;
    });
}


function return_request_adds(_this) {
    var html = `<div style="width: 100%;" id="return_request_list_`+return_request_id+`"><div class="row">
    <div class="col2" style="padding: 0;padding-left: 15px;width: 300px;"><input class="form-control" name="return_request[`+return_request_id+`][field]"></div>
    <div class="col2" style="padding: 0;"><input class="form-control" name="return_request[`+return_request_id+`][title]"></div>
    <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="return_request[`+return_request_id+`][type]">`+$('.type_list').html()+`</select></div>
    <div class="col2" style="padding: 0;position: relative;width:52px">
        <input type="checkbox" lay-skin="primary" name="return_request[`+return_request_id+`][no_null]" value="1">
        <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
    </div>
    <div class="col2" style="padding: 0;display: flex;">
        <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#return_request_list_`+return_request_id+`').remove()" title="删除该节点">
            <i class="ma-icon ma-icon-close"></i>
        </div>
        <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="return_request_adds(this)" title="添加相邻节点">
            <i class="ma-icon ma-icon-plus"></i>
        </div>
    </div>
  </div></div>`;
  
  return_request_id++;
    if (_this == null) {
        $('#return_request_list').append(html);
    } else {
        $(_this).parent().parent().after(html);
    }
    if (Restform) Restform.render();
}

function return_request_reload() {
    $('#return_request_list').html('');
    
    let array = ajax('/api/api/get_return_request', 'post', {item_id:$('#api-tab-item').attr('data-id')}, false);
    if (array == false) {
        return;
    }
    request_id = array.length;
    var i = 0;
    array.forEach(v => {
        var html = `<div style="width: 100%;" id="return_request_list_`+i+`"><div class="row">
  <div class="col2" style="padding: 0;padding-left: 15px;width: 300px;"><input class="form-control" name="return_request[`+i+`][field]" value="`+v.field+`"></div>
  <div class="col2" style="padding: 0;"><input class="form-control" name="return_request[`+i+`][title]" value="`+((v.title!= null ? v.title: '') ? (v.title!= null ? v.title: '') :'')+`"></div>
  <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="return_request_type_`+i+`" name="return_request[`+i+`][type]">`+$('.type_list').html()+`</select></div>
  <div class="col2" style="padding: 0;position: relative;width:52px">
      <input type="checkbox" lay-skin="primary" name="return_request[`+i+`][no_null]" value="1" `+(v.no_null==1?'checked':'')+`>
      <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
  </div>
  <div class="col2" style="padding: 0;display: flex;">
      <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#return_request_list_`+i+`').remove()" title="删除该节点">
          <i class="ma-icon ma-icon-close"></i>
      </div>
      <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="return_request_adds(this)" title="添加相邻节点">
          <i class="ma-icon ma-icon-plus"></i>
      </div>
  </div>
</div></div>`;
        $('#return_request_list').append(html);
        $('#return_request_type_'+i+' option').prop("selected", "");
        $('#return_request_type_'+i+' option[value="'+v.param_type+'"]').prop("selected", "selected");
        if (Restform) Restform.render();
        i++;
    });
}


function return_adds(_this) {
    var cid = '_'+return_id;
    var sid = '['+return_id+']';
    var html = `<div class="row" style="width: 100%;" id="return_list`+cid+`">
    <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - 570px);"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="param_fold(this)"></i><input style="width: calc(100% - 16px);" class="form-control" name="return`+sid+`[field]"></div>
    <div class="col2" style="padding: 0;"><input class="form-control" name="return`+sid+`[title]"></div>
    <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="return`+sid+`[default]"></div>
    <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="return`+sid+`[type]">`+$('.type_list').html()+`</select></div>
    <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="return`+sid+`[size]"></div>
    <div class="col2" style="padding: 0;position: relative;width:52px">
        <input type="checkbox" lay-skin="primary" name="return`+sid+`[no_null]" value="1">
        <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
    </div>
    <div class="col2" style="padding: 0;display: flex;">
        <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#return_list`+cid+`').remove()" title="删除该节点">
            <i class="ma-icon ma-icon-close"></i>
        </div>
        <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="return_adds(this)" title="添加相邻节点">
            <i class="ma-icon ma-icon-plus"></i>
        </div>
        <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="return_adds2('`+sid+`', '`+cid+`', null, 1)" title="添加下级节点">
            <i class="ma-icon ma-icon-arrow-bottom"></i>
        </div>
    </div>
  </div>`;
  
    return_id++;
    if (_this == null) {
      $('#return_list').append(html);
    } else {
      $(_this).parent().parent().after(html);
    }
    if (Restform) Restform.render();
}
function return_adds2(id, kid, _this, level){
    var cid = kid+'_'+return_id;
    var sid = '['+return_id+']';
    var lt = (level*50);
    var width = 570+lt;
    var key = 'return_list'+cid;
    var html = `<div class="row" id="`+key+`" style="width:100%">
    <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - `+width+`px);margin-left: `+lt+`px;"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="param_fold(this)"></i><input style="width: calc(100% - 16px);" class="form-control" name="return`+id+sid+`[field]"></div>
    <div class="col2" style="padding: 0;"><input class="form-control" name="return`+id+sid+`[title]"></div>
    <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="return`+id+sid+`[default]"></div>
    <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="return`+id+sid+`[type]">`+$('.type_list').html()+`</select></div>
    <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="return`+id+sid+`[size]"></div>
    <div class="col2" style="padding: 0;position: relative;width:52px">
        <input type="checkbox" lay-skin="primary" name="return`+id+sid+`[no_null]" value="1">
        <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
    </div>
    <div class="col2" style="padding: 0;display: flex;">
        <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#`+key+`').remove()" title="删除该节点">
            <i class="ma-icon ma-icon-close"></i>
        </div>
        <div style="padding: 0px;" class="btn btn-sm btn-primary" onclick="return_adds2('`+id+`', '`+kid+`', this, `+level+`)" title="添加相邻节点">
            <i class="ma-icon ma-icon-plus"></i>
        </div>
    </div>
    <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="return_adds2('`+(id+sid)+`', '`+cid+`', null, `+(level+1)+`)" title="添加下级节点">
        <i class="ma-icon ma-icon-arrow-bottom"></i>
    </div>
</div>`;
    return_id++;
    if (_this == null) {
        $('#return_list'+kid).append(html);
    } else {
        $(_this).parent().parent().after(html);
    }
    if (Restform) Restform.render();
}


function code_adds(_this) {
    var html = `<div style="width: 100%;" id="code_list_`+code_id+`"><div class="row">
    <div class="col2" style="padding: 0;padding-left: 15px;width: 200px;"><input class="form-control" name="code[`+code_id+`][code]"></div>
    <div class="col2" style="padding: 0;width: 300px;"><input class="form-control" name="code[`+code_id+`][msg]"></div>
    <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" name="code[`+code_id+`][type]">`+$('.type_list').html()+`</select></div>
    <div class="col2" style="padding: 0;position: relative;width:66px">
        <input type="checkbox" lay-skin="primary" name="code[`+code_id+`][is_success]" value="1">
        <div class="checkbos-tips" style="left: -13px;">是否成功条件<div class="corenr"></div></div>
    </div>
    <div class="col2" style="padding: 0;display: flex;">
        <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#code_list_`+code_id+`').remove()" title="删除该节点">
            <i class="ma-icon ma-icon-close"></i>
        </div>
        <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="code_adds(this)" title="添加相邻节点">
            <i class="ma-icon ma-icon-plus"></i>
        </div>
    </div>
  </div></div>`;
  
  code_id++;
    if (_this == null) {
        $('#code_list').append(html);
    } else {
        $(_this).parent().parent().after(html);
    }
    if (Restform) Restform.render();
}

function code_reload() {
    $('#code_list').html('');
    
    var array = ajax('/api/api/get_code', 'post', {item_id:$('#api-tab-item').attr('data-id')}, false);
    if (array == false) {
        return;
    }
    request_id = array.length;
    var i = 0;
    array.forEach(v => {
        var html = `<div style="width: 100%;" id="code_list_`+i+`"><div class="row">
  <div class="col2" style="padding: 0;padding-left: 15px;width: 200px;"><input class="form-control" name="code[`+i+`][code]" value="`+v.code+`"></div>
  <div class="col2" style="padding: 0;width: 300px;"><input class="form-control" name="code[`+i+`][msg]" value="`+(v.msg ? v.msg :'')+`"></div>
  <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="codee_type_`+i+`" name="code[`+i+`][type]">`+$('.type_list').html()+`</select></div>
  <div class="col2" style="padding: 0;position: relative;width:66px">
      <input type="checkbox" lay-skin="primary" name="code[`+i+`][is_success]" value="1" `+(v.is_success==1?'checked':'')+`>
      <div class="checkbos-tips" style="left: -13px;">是否成功条件<div class="corenr"></div></div>
  </div>
  <div class="col2" style="padding: 0;display: flex;">
      <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#code_list_`+i+`').remove()" title="删除该节点">
          <i class="ma-icon ma-icon-close"></i>
      </div>
      <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="code_adds(this)" title="添加相邻节点">
          <i class="ma-icon ma-icon-plus"></i>
      </div>
  </div>
</div></div>`;
        $('#code_list').append(html);
        $('#codee_type_'+i+' option').prop("selected", "");
        $('#codee_type_'+i+' option[value="'+v.param_type+'"]').prop("selected", "selected");
        if (Restform) Restform.render();
        i++;
    });
}

function success_adds(_this) {
    var html = `<div style="width: 100%;" id="success_list_`+success_id+`"><div class="row">
    <div class="col2" style="padding: 0;padding-left: 15px;width: 150px;"><input class="form-control" name="success[`+success_id+`][scene]" value="场景`+(success_id+1)+`"></div>
    <div class="col2" style="padding: 0;width: 250px;"><input class="form-control" name="success[`+success_id+`][des]"></div>
    <div class="col2" style="padding: 0;width: 380px;"><textarea style="height: 150px;" class="form-control" name="success[`+success_id+`][json]"></textarea></div>
    <div class="col2" style="padding: 0;display: flex;">
        <div style="padding: 2px 7px 0 7px;" class="btn btn-sm btn-error" onclick="$('#success_list_`+success_id+`').remove()" title="删除该节点">
            <i class="ma-icon ma-icon-close"></i>
        </div>
        <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="success_adds(this)" title="添加相邻节点">
            <i class="ma-icon ma-icon-plus"></i>
        </div>
    </div>
  </div></div>`;
  
    success_id++;
    if (_this == null) {
        $('#success_list').append(html);
    } else {
        $(_this).parent().parent().after(html);
    }
}


function error_adds(_this) {
    var html = `<div style="width: 100%;" id="error_list_`+error_id+`"><div class="row">
    <div class="col2" style="padding: 0;padding-left: 15px;width: 150px;"><input class="form-control" name="error[`+error_id+`][scene]" value="场景`+(error_id+1)+`"></div>
    <div class="col2" style="padding: 0;width: 250px;"><input class="form-control" name="error[`+error_id+`][des]"></div>
    <div class="col2" style="padding: 0;width: 380px;"><textarea style="height: 150px;" class="form-control" name="error[`+error_id+`][json]"></textarea></div>
    <div class="col2" style="padding: 0;display: flex;">
        <div style="padding: 2px 7px 0 7px;" class="btn btn-sm btn-error" onclick="$('#error_list_`+error_id+`').remove()" title="删除该节点">
            <i class="ma-icon ma-icon-close"></i>
        </div>
        <div style="padding: 0px 7px 0 0;" class="btn btn-sm btn-primary" onclick="error_adds(this)" title="添加相邻节点">
            <i class="ma-icon ma-icon-plus"></i>
        </div>
    </div>
  </div></div>`;
  
    error_id++;
    if (_this == null) {
        $('#error_list').append(html);
    } else {
        $(_this).parent().parent().after(html);
    }
}


function body_insert(list, id, kid, level) {
    list.forEach(val => {
        var cid = kid+'_'+param_id;
        var sid = '['+param_id+']';
        var lt = (level*50);
        var width = 570+lt;
        var key = 'param_list'+cid;
        var html = `<div class="row" id="`+key+`" style="width:100%">
            <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - `+width+`px);margin-left: `+lt+`px;"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="param_fold(this)"></i><input style="width: calc(100% - 16px);" class="form-control" name="param`+id+sid+`[field]" value="`+val.field+`"></div>
            <div class="col2" style="padding: 0;"><input class="form-control" name="param`+id+sid+`[title]" value="`+(val.title!= null ? val.title: '')+`"></div>
            <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="param`+id+sid+`[default]" value="`+(val.default != null ? val.default : '')+`"></div>
            <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="param_`+param_id+`" name="param`+id+sid+`[type]">`+$('.type_list').html()+`</select></div>
            <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="param`+id+sid+`[size]" value="`+(val.size!= null ? val.size: '')+`"></div>
            <div class="col2" style="padding: 0;position: relative;width:52px">
                <input type="checkbox" lay-skin="primary" name="param`+id+sid+`[no_null]" value="1" `+(val.no_null==1?'checked':'')+`>
                <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
            </div>
            <div class="col2" style="padding: 0;display: flex;">
                <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#`+key+`').remove()" title="删除该节点">
                    <i class="ma-icon ma-icon-close"></i>
                </div>
                <div style="padding: 0px;" class="btn btn-sm btn-primary" onclick="param_adds2('`+id+`', '`+kid+`', this, `+level+`)" title="添加相邻节点">
                    <i class="ma-icon ma-icon-plus"></i>
                </div>
            </div>
            <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="param_adds2('`+(id+sid)+`', '`+cid+`', null, `+(level+1)+`)" title="添加下级节点">
                <i class="ma-icon ma-icon-arrow-bottom"></i>
            </div>
        </div>`;
        $('#param_list'+kid).append(html);
        $('#param_'+param_id+' option').prop("selected", "");
        $('#param_'+param_id+' option[value="'+val.param_type+'"]').prop("selected", "selected");
        param_id++;
        body_insert(val.list, (id+sid), cid, (level+1));
    });
}


function return_insert(list, id, kid, level) {
    list.forEach(val => {
        var cid = kid+'_'+return_id;
        var sid = '['+return_id+']';
        var lt = (level*50);
        var width = 570+lt;
        var key = 'return_list'+cid;
        var html = `<div class="row" id="`+key+`" style="width:100%">
            <div class="col2" style="padding: 0;padding-left: 15px;width: calc(100% - `+width+`px);margin-left: `+lt+`px;"><i class="ma-icon click ma-icon-arrow-bottom" style="float: left;padding-top: 4px;" onclick="return_fold(this)"></i><input style="width: calc(100% - 16px);" class="form-control" name="return`+id+sid+`[field]" value="`+val.field+`"></div>
            <div class="col2" style="padding: 0;"><input class="form-control" name="return`+id+sid+`[title]" value="`+(val.title!= null ? val.title: '')+`"></div>
            <div class="col2" style="padding: 0;width: 100px;"><input class="form-control" name="return`+id+sid+`[default]" value="`+(val.default != null ? val.default : '')+`"></div>
            <div class="col2" style="padding: 0;width: 110px;"><select class="form-control" id="return_`+return_id+`" name="return`+id+sid+`[type]">`+$('.type_list').html()+`</select></div>
            <div class="col2" style="padding: 0;width: 45px;"><input class="form-control" name="return`+id+sid+`[size]" value="`+(val.size!= null ? val.size: '')+`"></div>
            <div class="col2" style="padding: 0;position: relative;width:52px">
                <input type="checkbox" lay-skin="primary" name="return`+id+sid+`[no_null]" value="1" `+(val.no_null==1?'checked':'')+`>
                <div class="checkbos-tips" style="left: -21px;">是否必填<div class="corenr"></div></div>
            </div>
            <div class="col2" style="padding: 0;display: flex;">
                <div style="padding: 2px 7px 0 0;" class="btn btn-sm btn-error" onclick="$('#`+key+`').remove()" title="删除该节点">
                    <i class="ma-icon ma-icon-close"></i>
                </div>
                <div style="padding: 0px;" class="btn btn-sm btn-primary" onclick="return_adds2('`+id+`', '`+kid+`', this, `+level+`)" title="添加相邻节点">
                    <i class="ma-icon ma-icon-plus"></i>
                </div>
            </div>
            <div style="padding: 0;" class="btn btn-sm btn-bottom" onclick="return_adds2('`+(id+sid)+`', '`+cid+`', null, `+(level+1)+`)" title="添加下级节点">
                <i class="ma-icon ma-icon-arrow-bottom"></i>
            </div>
        </div>`;
        $('#return_list'+kid).append(html);
        $('#return_'+return_id+' option').prop("selected", "");
        $('#return_'+return_id+' option[value="'+val.param_type+'"]').prop("selected", "selected");
        return_id++;
        return_insert(val.list, (id+sid), cid, (level+1));
    });
}


function param_fold(_this) {
    if ($(_this).hasClass('ma-icon-arrow-bottom')) {
        $(_this).removeClass('ma-icon-arrow-bottom')
        $(_this).addClass('ma-icon-arrow-right')
        $(_this).parent().siblings('.row').hide();
    } else {
        $(_this).removeClass('ma-icon-arrow-right')
        $(_this).addClass('ma-icon-arrow-bottom')
        $(_this).parent().siblings('.row').show();
    }
}