

var markdown = null;
var type_id = null;
var lable_id = null;
var code_id = null;

$(function(){
    
    $('.word_right').css('height', ($(document).height()-137)+'px');
    markdown = editormd("my-editormd", {
        width   : "100%",
        height  : "100%",
        syncScrolling : "single",
        path    : "/editor/lib/",
        saveHTMLToTextarea : true,
        /**上传图片相关配置如下*/
        imageUpload : true,
        imageFormats : ["jpg", "jpeg", "gif", "png", "bmp", "webp"],
        imageUploadURL : "/common/posts_img",
        emoji: true,
        flowChart: true,
        sequenceDiagram: true,
        /**设置主题颜色*/
        editorTheme: "pastel-on-dark",
        theme: "gray",
        previewTheme: "dark"
    });

    
    
    $('.add-type').click(function(){
        type_id = null;
        $('#add_type_title').val('')
        $('#add_type_sort').val(0)
        $('#post-type').html('提交创建');
        $('#add-type').show();
    })
    $('#post-type').click(function(){
        var data = {}
        data.title = $('#add_type_title').val()
        data.sort = $('#add_type_sort').val()

        if (type_id == null) {
            eventlog('请求创建分类');
            var array = ajax('/robot/type/insert', 'post', data, true);
            if (array !== false) {
                get_type_list({}, false);
                $('#add-type').hide();
            }
        } else {
            data.id = type_id;
            eventlog('请求修改分类信息');
            var array = ajax('/robot/type/update', 'post', data, true);
            if (array !== false) {
                get_type_list({}, false);
                $('#add-type').hide();
            }
        }
    })
    $('#type-which .update').click(function(){
        
        var info = ajax('/robot/type/info', 'post', {id:type_id}, false);
        $('#add_type_title').val(info.title);
        $('#add_type_sort').val(info.sort);
        $('#post-type').html('确认修改');
        $('#add-type').show();
        $('#type-which').hide();
    })
    $('#type-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '注意：数据删除后将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除分类');
                    var array = ajax('/robot/type/delete', 'post', {id:type_id}, true);
                    if (array !== false) {
                        get_type_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
        $('#type-which').hide();
    })
    get_type_list()
    function get_type_list() {
        eventlog('正在请求分类列表');
        var ID = '#type-list'
        var array = ajax('/robot/type/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('分类列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-item" data-id="`+array[i]['id']+`" title="`+array[i]['title']+`">
                <div class="ma-tree-hover">
                    <label>`+array[i]['title']+`</label>
                </div>
            </div>`;
        }
        $(ID).html(html);

        
        $(ID+' .click').unbind("mousedown").bind("mousedown", function (event) {
            event.preventDefault();
            return false;
        })
        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            type_id = $(this).attr('data-id');
            
            if (event.which == 3) {
                $('#type-which').show();
                $('#type-which').css('left',(event.pageX+15)+'px').css('top',getTop('#menu-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $(ID+' .ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                get_code_list();
            }
        });
        eventlog('分类列表加载完毕');
    }
    
    
    
    $('.add-lable').click(function(){
        lable_id = null;
        $('#add_lable_title').val('')
        $('#add_lable_sort').val(0)
        $('#post-lable').html('提交创建');
        $('#add-lable').show();
    })
    $('#post-lable').click(function(){
        var data = {}
        data.title = $('#add_lable_title').val()
        data.sort = $('#add_lable_sort').val()

        if (lable_id == null) {
            eventlog('请求创建标签');
            var array = ajax('/robot/lable/insert', 'post', data, true);
            if (array !== false) {
                get_lable_list({}, false);
                $('#add-lable').hide();
            }
        } else {
            data.id = lable_id;
            eventlog('请求修改标签信息');
            var array = ajax('/robot/lable/update', 'post', data, true);
            if (array !== false) {
                get_lable_list({}, false);
                $('#add-lable').hide();
            }
        }
    })
    $('#lable-which .update').click(function(){
        
        var info = ajax('/robot/lable/info', 'post', {id:lable_id}, false);
        $('#add_lable_title').val(info.title);
        $('#add_lable_sort').val(info.sort);
        $('#post-lable').html('确认修改');
        $('#add-lable').show();
        $('#lable-which').hide();
    })
    $('#lable-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '注意：数据删除后将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除标签');
                    var array = ajax('/robot/lable/delete', 'post', {id:lable_id}, true);
                    if (array !== false) {
                        get_lable_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
        $('#lable-which').hide();
    })
    get_lable_list()
    function get_lable_list() {
        eventlog('正在请求标签列表');
        var ID = '#lable-list'
        var array = ajax('/robot/lable/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('标签列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-item" data-id="`+array[i]['id']+`" title="`+array[i]['title']+`">
                <div class="ma-tree-hover">
                    <label>`+array[i]['title']+`</label>
                </div>
            </div>`;
        }
        $(ID).html(html);

        
        $(ID+' .click').unbind("mousedown").bind("mousedown", function (event) {
            event.preventDefault();
            return false;
        })
        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            lable_id = $(this).attr('data-id');
            
            if (event.which == 3) {
                $('#lable-which').show();
                $('#lable-which').css('left',(event.pageX+15)+'px').css('top',getTop('#menu-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $(ID+' .ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                get_code_list();
            }
        });
        eventlog('标签列表加载完毕');
    }


    
    
    $('.add-code').click(function(){
        markdown.setValue('');
        code_id = null;
        $('#title').val('')
        $('#code').val('')
        $('#code-list .ma-tree-item').removeClass('ma-tree-select');
    })
    $('#code-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '注意：数据删除后将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除词库');
                    var array = ajax('/robot/index/delete', 'post', {id:code_id}, true);
                    if (array !== false) {
                        get_code_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
        $('#code-which').hide();
    })
    get_code_list()
    function get_code_list() {
        eventlog('正在请求词库列表');

        var data = {
            type_id : $('#type-list .ma-tree-select').attr("data-id"),
            lable_id : $('#lable-list .ma-tree-select').attr("data-id"),
        }
        var ID = '#code-list'
        var array = ajax('/robot/index/showlist', 'post', data, false);
        if (array == false) {
            eventlog('词库列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-item" data-id="`+array[i]['id']+`" title="`+array[i]['title']+`">
                <div class="ma-tree-hover">
                    <label>`+array[i]['title']+`</label>
                </div>
            </div>`;
        }
        $(ID).html(html);

        
        $(ID+' .click').unbind("mousedown").bind("mousedown", function (event) {
            event.preventDefault();
            return false;
        })
        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            code_id = $(this).attr('data-id');
            
            if (event.which == 3) {
                $('#code-which').show();
                $('#code-which').css('left',(event.pageX+15)+'px').css('top',getTop('#menu-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $(ID+' .ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                
                var info = ajax('/robot/index/info', 'post', {id:code_id}, false);
                if (info.content == null) info.content = "";
                $('#title').val(info.title);
                markdown.setValue(info.content);
            }
        });
        eventlog('词库列表加载完毕');
    }

    
    $('.ma-icon-save').click(function(){
        var data = {
            title: $('#title').val(),
            type_id : $('#type-list .ma-tree-select').attr("data-id"),
            lable_id : $('#lable-list .ma-tree-select').attr("data-id"),
        }
        data.content = markdown.getValue()

        if (code_id == null) {
            eventlog('请求创建词库');
            var array = ajax('/robot/index/insert', 'post', data, true);
            if (array !== false) {
                get_code_list();
                $('#title').val('');
                markdown.setValue('');
            }
        } else {
            data.id = code_id
            eventlog('请求修改词库');
            var array = ajax('/robot/index/update', 'post', data, true);
            if (array !== false) {
                get_code_list();
            }
        }
    })


});