

var Restform = null;
var mixedMode = {
    name: "htmlmixed",
    scriptTypes: [{matches: /\/x-handlebars-template|\/x-mustache/i,
               mode: null},
              {matches: /(text|application)\/(x-)?vb(a|script)/i,
               mode: "vbscript"}]
};
var editor = null;
var markdown = null;
var tree_title = null;

$(function(){
    
    layui.use('form', function(){
        Restform = layui.form;
    });
    
    
    function app_start() {
        $('.main-title').text('创建一级章节');
        $('.title').val('');
        $('.route').val('');
        $('input[name="status"][value="1"]').val();
        $('input[name="type"][value="1"]').val();
        $('input[name="top"][value="1"]').val();
        $('input[name="editor_type"][value="1"]').val();
        if (editor) editor.setValue('');
        if (markdown) markdown.setValue('');
    }
    
    function reloadItemTab(status) {
        var array = ajax('/word/index/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('TAB文档列表加载失败');
            return;
        }
        var uid = $('#api-tab-item').attr('data-id');
        let html = '';
        for (let i = 0; i < array.length; i++) {
            var cls = '';
            if (array[i]['id'] == uid) {
                cls = 'selected'
            }
            html += `<li data-id="`+array[i]['id']+`" data-token="`+array[i]['route']+`" class="`+cls+`">`+array[i]['title']+`</li>`;
        }
        $('#api-tab-div ul').html(html);
        
        $('#api-tab-div li').click(function(){
            $('#api-tab-div').hide();
            $('#api-tab-div li').removeClass('selected');
            $(this).addClass('selected');
            $('#api-tab-item').attr('data-id', $(this).attr('data-id'));
            $('#api-tab-item').html($(this).html())
            $('#api-preview').attr('href', '/apiword/'+$(this).attr('data-token')+'.html');
            get_api_list({}, false);
        })
        if (status == true) {
            $('#api-tab-div li:eq(0)').click();
        }
        eventlog('TAB文档列表加载完毕');
    }
    
    
    function get_api_list(data, status) {
        eventlog('正在请求章节列表');

        data.word_id = $('#api-tab-item').attr('data-id')
        var ID = '#api-list'
        var array = ajax('/word/tree/showlist', 'post', data, status);
        if (array == false) {
            eventlog('章节列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        var status = false;
        for (let i = 0; i < array.length; i++) {
            var left = (array[i]['level']-1)*20;
            if (array[i]['next'] == true) {
                if (status == true) {
                    html += `</div>`;
                }
                status = false;
                html += `<div class="ma-tree-item ma-tree-item-header ma-tree-hover" style="padding-left: `+left+`px;" pid="/`+array[i]['path']+`/" data-id="`+array[i]['id']+`" title="`+array[i]['menu_name']+`">
                    <i class="ma-icon click ma-icon-arrow-bottom"></i>
                    <i class="ma-icon ma-icon-list"></i>
                    <label>`+array[i]['title']+`</label>
                </div>`;
            } else {
                if (status == false) {
                    status = true;
                    html += `<div class="ma-tree-sub-items">`;
                }
                html += `<div class="ma-tree-item" pid="/`+array[i]['path']+`/" data-id="`+array[i]['id']+`" title="`+array[i]['title']+`">
                    <div class="ma-tree-hover" style="padding-left: `+left+`px;" >
                        <label>`+array[i]['title']+`</label>
                    </div>
                </div>`;
            }
        }
        if (status == true) {
            html += `</div>`;
        }
        $(ID).html(html);
        
        $(ID+' .click').unbind("mousedown").bind("mousedown", function (event) {
            if (event.which == 1) {
                let t = $(this).parent().attr('pid');
                if ($(this).hasClass('ma-icon-arrow-bottom')) {
                    $(this).removeClass('ma-icon-arrow-bottom');
                    $(this).addClass('ma-icon-arrow-right');
                    $(ID+' .ma-tree-item').each(function(){
                        let str = $(this).attr('pid');
                        if (str.indexOf(t) != -1 && str !== t) {
                            $(this).hide();
                        }
                    })
                } else {
                    $(this).removeClass('ma-icon-arrow-right');
                    $(this).addClass('ma-icon-arrow-bottom');
                    $(ID+' .ma-tree-item').each(function(){
                        let str = $(this).attr('pid');
                        if (str.indexOf(t) != -1 && str !== t) {
                            $(this).find('.click').removeClass('ma-icon-arrow-right');
                            $(this).find('.click').addClass('ma-icon-arrow-bottom');
                            $(this).show();
                        }
                    })
                }
            }
            event.preventDefault();
            return false;
        })
        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            tree_title = $(this).find('label').text();
            
            
            if (event.which == 3) {
                $('body').attr('check-id', $(this).attr('data-id'))
                $('body').attr('data-pid', $(this).attr('data-id'));
                $('body').attr('data-title', $(this).attr('title'));
                $('#menu-which').show();
                $('#menu-which').css('left',(event.pageX+15)+'px').css('top',getTop('#menu-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $('.main-title').text($('.ma-toolbar-container .selected').text()+' / 编辑 / '+tree_title);

                $('body').attr('data-id', $(this).attr('data-id'))
                $('body').attr('data-pid', '0')
                $('.ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                
                var info = ajax('/word/tree/info', 'post', {id:$('body').attr('data-id')}, false);
                $('.title').val(info.title);
                $('.route').val(info.route);
                $('input[name="status"][value="'+info.status+'"]').prop("checked", "checked");;
                $('input[name="type"][value="'+info.type+'"]').prop("checked", "checked");
                $('input[name="top"][value="'+info.top+'"]').prop("checked", "checked");
                $('input[name="editor_type"][value="'+info.editor_type+'"]').click();
                if (info.content == null) info.content = "";
                if (info.editor_type == 1) {
                    editor.setValue(info.content);
                } else {
                    setTimeout(function () {
                        markdown.setValue(info.content);
                    }, 300);
                }
            }
        });
        eventlog('接口列表加载完毕');
        
        app_start();
    }
    
    function get_item_list(data,status) {
        eventlog('正在请求文档列表');

        var ID = '#item-list'
        var array = ajax('/word/index/showlist', 'post', data, status);
        if (array == false) {
            eventlog('文档列表加载失败');
            $(ID).html('');
            $(ID).next('.no-data').show()
            return;
        }else{
            $(ID).next('.no-data').hide()
        }

        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<div class="ma-tree-sub-items">
            <div class="ma-tree-item" title="点击编辑" data-id="`+array[i]['id']+`">
                <div class="ma-tree-hover">
                    <label>`+array[i]['title']+`</label>
                </div>
            </div>
        </div>`;
        }
        $(ID).html(html);

        
        $('#item_user_list').html('');
        var array = ajax('/word/user/showlist', 'post', {}, false);
        if (array != false) {
            let html = '';
            for (let i = 0; i < array.length; i++) {
                html += `<input name="item_user[]" type="checkbox" value="`+array[i]['id']+`"> `+array[i]['username']+' ';
            }
            $('#item_user_list').html(html);
        }

        
        $(ID+" .ma-tree-item").unbind("mousedown").bind("contextmenu", function (e) {
            e.preventDefault();
            return false;
        });
        $(ID+" .ma-tree-item").unbind("mousedown").bind("mousedown", function (event) {
            
            if (event.which == 3) {
                $('body').attr('check-id', $(this).attr('data-id'))
                $('body').attr('data-pid', $(this).attr('data-id'))
                $('#item-which').show();
                $('#item-which').css('left',(event.pageX+15)+'px').css('top',getTop('#item-which', event.pageY+10)+'px'); 
            
            } else if (event.which == 1) {
                $('.main-title').text('编辑文档 / '+$(this).find('label').text());

                $('body').attr('data-id', $(this).attr('data-id'))
                $('.ma-tree-item').removeClass('ma-tree-select');
                $(this).addClass('ma-tree-select');
                
                var info = ajax('/word/index/info', 'post', {id:$('body').attr('data-id')}, false);
                console.log(info);
                $('#item_title').val(info.title);
                $('#item_route').val(info.route);
                $('#item_des').val(info.des);
                $(":radio[name='item_status'][value='"+info.status+"']").prop("checked", "checked");
                $(":radio[name='is_login'][value='"+info.is_login+"']").prop("checked", "checked");
                $(":checkbox[name='item_user[]']").prop("checked", false);
                
                if ((info.user_id).length > 0) {
                    info.user_id.forEach(v => {
                        $(":checkbox[name='item_user[]'][value='"+v+"']").prop("checked", "checked");
                    })
                }
            }
        });
        eventlog('文档列表加载完毕');
    }
    
    $('#api-tab-item').click(function(){
        var t = $('#api-tab-div');
        if(t.is(':hidden')){t.show()}else{t.hide()}
        reloadItemTab(false);
    })
    
    reloadItemTab(true);
    get_api_list({}, false);

    
    $('#click-duty').click(function(){
        $('#post-duty').html('提交创建');
        var ID = '#add-duty'
        $(ID).show()
        
        var array = ajax('/word/user/showlist', 'post', {}, false);
        if (array == false) {
            eventlog('文档可预览人员列表加载失败');
            $(ID+' ul').html('暂无数据');
            return;
        }

        let html = '';
        for (let i = 0; i < array.length; i++) {
            html += `<li data-id="`+array[i]['id']+`"><span>`+array[i]['username']+`</span> <i class="ma-icon ma-icon-delete"></i></li>`;
        }
        $(ID+' ul').html(html);

        
        
        $(ID+' li span').click(function(){
            $('#post-duty').html('提交修改');
            $(ID+' li').removeClass('selected');
            $(this).parent().addClass('selected');
            $('#post-duty').html('提交修改');
            
            var info = ajax('/word/user/info', 'post', {id:$(this).parent().attr('data-id')}, false);
            console.log(info);
            $('#from_username').val(info.username)
            $('#from_password').val('')
            $('#from_fullname').val(info.fullname)
            $('#from_phone').val(info.phone)
            $('#from_remark').val(info.remark)
            $("input[name='from_status'][value='"+info.status+"']").prop("checked", "checked");
        })
        
        $(ID+' li .ma-icon-delete').click(function(){
            eventlog('点击删除负责人员');
            var data = {id:$(this).parent().attr('data-id')}
            $.alert({
                title: '确认删除？',
                content: '删除后数据将不可恢复',
                buttons: {
                  confirm: {
                    text: '确认',
                    btnClass: 'btn-primary',
                    action: function(){
                        eventlog('确认删除文档可预览人员');
                        var array = ajax('/word/user/delete', 'post', data, true);
                        if (array !== false) {
                            $('#click-duty').click();
                        }
                    }
                  },
                  cancel: {text: '取消'}
                }
            });
        })
        
        eventlog('文档可预览人员列表加载完毕');
    })
    
    $('#post-duty').click(function(){
        var data = {}
        data.username = $('#from_username').val()
        data.password = $('#from_password').val()
        data.fullname = $('#from_fullname').val()
        data.phone = $('#from_phone').val()
        data.remark = $('#from_remark').val()
        data.status = $('input[name="from_status"]:checked').val();
        
        if ($('#add-duty li').hasClass('selected')) {
            eventlog('请求编辑可预览人员信息');
            data.id = $('#add-duty .selected').attr('data-id');
            var array = ajax('/word/user/update', 'post', data, true);
        } else {
            eventlog('请求创建可预览人员');
            var array = ajax('/word/user/insert', 'post', data, true);
        }

        if (array !== false) {
            $('#from_username').val('')
            $('#from_password').val('')
            $('#from_fullname').val('')
            $('#from_phone').val('')
            $('#from_remark').val('')
            $("input[name='from_status'][value='1']").prop("checked", "checked");
            $('#click-duty').click();
        }
    })
    
    $('.ma-toolbar-container li').click(function(){
        $('#api-preview').hide();
        var t = $(this).attr('data-id');
        switch (t) {
            case 'api': 
                get_api_list({}, false); 
                $('#api-preview').show();
            break;
            case 'item': 
                $('.'+t+'-main').find('.ma-icon-plus').click();
                
		        $('#item_user_list').html('');
		        var array = ajax('/word/user/showlist', 'post', {}, false);
		        if (array != false) {
		            let html = '';
		            for (let i = 0; i < array.length; i++) {
		                html += `<input name="item_user[]" type="checkbox" value="`+array[i]['id']+`"> `+array[i]['username']+' ';
		            }
		            $('#item_user_list').html(html);
		        }
                get_item_list({}, false); 
            break;
        }
    })
    
    $('.ma-icon-refresh').click(function(){
        var t = $('.ma-toolbar-container .selected').attr('data-id');
        switch (t) {
            case 'api': get_api_list({}, false); break;
            case 'item': get_item_list({}, false); break;
        }
    })
    
    $('.main-body>.ma-tree-wrapper>.ma-tree-toolbar>div>.ma-tree-toolbar-btn>.ma-icon-plus').click(function(){
        lightyear.notify('初始化表单', 'success', 300);
        var t = $('.ma-toolbar-container .selected').attr('data-id');
        $('body').attr('data-id', '');
        switch (t) {
            case 'api':
                
                app_start();
            break;
            case 'item':
                $('.main-title').text('创建文档');
                $('#item_title').val('');
                $('#item_route').val('');
                $('#item_des').val('');
                $(":radio[name='item_status'][value='1']").prop("checked", "checked");
                $(":radio[name='is_login'][value='0']").prop("checked", "checked");
                $(":checkbox[name='item_user[]']").prop("checked", false);
            break;
        }
    })

    
    $('.ma-icon-save').click(function(){
        var data = {}
        var id = $('body').attr('data-id');
        
        if ($('#add-duty').is(':hidden')==false) {
            $('#post-duty').click();
            return false;
        }

        var t = $('.ma-toolbar-container .selected').attr('data-id');
        
        switch (t) {
            case 'api':
                data.title = $('.title').val();
                data.route = $('.route').val();
                data.status =  $('input[name="status"]:checked').val();
                data.type =  $('input[name="type"]:checked').val();
                data.top = $('input[name="top"]:checked').val();
                data.editor_type = $('input[name="editor_type"]:checked').val();
                if (data.editor_type == 1) {
                    data.content = editor.getValue();
                } else {
                    data.content = markdown.getValue();
                }
                if (id == '') {
                    
                    data.word_id = $('#api-tab-item').attr('data-id');
                    
                    data.pid = $('body').attr('data-pid');

                    eventlog('请求创建章节');
                    var array = ajax('/word/tree/insert', 'post', data, true);
                    if (array !== false) {
                        get_api_list({}, false);
                    }
                } else {
                    data.id = id;
                    eventlog('请求修改章节信息');
                    var array = ajax('/word/tree/update', 'post', data, true);
                    if (array !== false) {
                        get_api_list({}, false);
                    }
                }
            break;
            case 'item':
                data.title = $('#item_title').val();
                data.des = $('#item_des').val();
                data.route = $('#item_route').val();
                data.status = $(":radio[name='item_status']:checked").val();
                data.is_login = $(":radio[name='is_login']:checked").val();
                var array = [];
                $(":checkbox[name='item_user[]']:checked").each(function(){
                    array.push($(this).val());
                })
                data.user_id = array;
                if (id == '') {
                    eventlog('请求创建文档');
                    var array = ajax('/word/index/insert', 'post', data, true);
                    if (array !== false) {
                        get_item_list({}, false);
                    }
                } else {
                    data.id = id;
                    eventlog('请求修改文档信息');
                    var array = ajax('/word/index/update', 'post', data, true);
                    if (array !== false) {
                        get_item_list({}, false);
                    }
                }
            break;
        }
    })
    
    $('#item-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '删除后数据将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除文档');
                    var array = ajax('/word/index/delete', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_item_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    $('#menu-which .delete').click(function(){
        $.alert({
            title: '确认删除？',
            content: '注意：系统最多往下递归删除一层，不会无限向下删除，数据删除后将不可恢复',
            buttons: {
              confirm: {
                text: '确认',
                btnClass: 'btn-primary',
                action: function(){
                    eventlog('确认删除章节');
                    var array = ajax('/word/tree/delete', 'post', {id:$('body').attr('check-id')}, true);
                    if (array !== false) {
                        get_api_list({}, false);
                    }
                }
              },
              cancel: {text: '取消'}
            }
        });
    })
    
    $('#api-sou').bind("input propertychange", function() {
        var data = {
            'key':$(this).val()
        };
        get_api_list(data, false);
    })
    $('#item-sou').bind("input propertychange", function() {
        var data = {
            'key':$(this).val()
        };
        get_item_list(data, false);
    })

    
    $('.ma-icon-folding').click(function(){
        var ID = '#api-list';
        $(ID+' .click').each(function(){
            
        });
    })
    
    $(':radio[name="editor_type"]').click(function(){
        if ($(this).val() == 1) {
            $('#action_button').show();
            $('#html').show();
            $('#markdown').hide();
        } else {
            $('#action_button').hide();
            $('#html').hide();
            
            if (markdown == null) {
                markdown = editormd("my-editormd", {
                    width   : "100%",
                    height  : "100%",
                    syncScrolling : "single",
                    path    : "/editor/lib/",
                    saveHTMLToTextarea : true,
                    /**上传图片相关配置如下*/
                    imageUpload : true,
                    imageFormats : ["jpg", "jpeg", "gif", "png", "bmp", "webp"],
                    imageUploadURL : "/common/posts_img",
                    emoji: true,
                    flowChart: true,
                    sequenceDiagram: true,
                    /**设置主题颜色*/
                    editorTheme: "pastel-on-dark",
                    theme: "gray",
                    previewTheme: "dark"
                });
            }
            $('#markdown').show();
        }
    })
    
    $('#menu-which .create').click(function(){
        app_start();
        lightyear.notify('已初始化表单', 'success', 700);
        $('.main-title').text($('.ma-toolbar-container .selected').text()+' / 创建下级 / '+tree_title);
        $('body').attr('data-id', '')
        $('#menu-which').hide();
    })
    
    editor = CodeMirror.fromTextArea(document.getElementById("code"), {
        mode: mixedMode,
        lineNumbers: true, 
        smartIndent: true, 
        indentUnit: 4, 
        theme: 'ayu-mirage', 
        styleActiveLine: true, 
        keyMap: 'sublime', 
        extraKeys: {'Ctrl-Q': 'autocomplete'}, 
        selectionPointer: true
    });
    
});



function addHtml(type) {
	switch (type) {
		case 1:
			var html = `<div class="card">
    <h3 id="a">XXXX</h3>
    <p>

    </p>
</div>

`;
		break;
		case 2:
			var html = `<div class="custom-block"><div class="custom-block tip"><p>
    建议：
</p></div></div>

`;
		break;
		case 3:
			var html = `<div class="custom-block"><div class="custom-block warning"><p>
    提示：
</p></div></div>

`;
		break;
		case 4:
			var html = `<div class="custom-block"><div class="custom-block danger"><p>
    警告：
</p></div></div>

`;
		break;
		case 5:
			var html = `<code>`+editor.getSelection()+`</code>`;
		break;
		case 6:
			var html = `<strong>`+editor.getSelection()+`</strong>`;
		break;
		case 7:
			var html = `<pre><code>`+editor.getSelection()+`</code></pre>`;
		break;
		case 8:
			var html = `<table>
    <thead>
        <tr>
            <th>
                xxx
            </th>
            <th>
                xxx
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>xxx</td>
            <td>xxx</td>
        </tr>
    </tbody>
</table>
`;
		break;
		case 9:
			var html = `<ul>
    <li>xxx</li>
    <li>xxx</li>
    <li>xxx</li>
    <li>xxx</li>
</ul>
`;
		break;
		case 10:
			var html = `<p>`+editor.getSelection()+`</p>`;
		break;
		case 11:
			var html = `<div class="card">
    <h3 id="a">set()</h3>
    <p>
        用途：设置session值。<br>
        依赖类：<code>Session</code><br>
        方法名：<code>set()</code>
    </p>
    <p>
        参数：<br>
        </p><ul>
            <li class="par-li">
                <p><strong><code class="par">string $key</code></strong></p>
                <ul>
                    <li><strong>功能</strong>：键名</li>
                    <li><strong>值单位</strong>：字符串</li>
                    <li><strong>默认值</strong>：无</li>
                    <li><strong>其它值</strong>：无</li>
                </ul>
            </li>
        </ul>
    <p></p>
    <p>
        返回值：<code>true</code>
    </p>
    <p>
        使用示例：
    </p>
    <pre><code>xxxxxx</code></pre>
</div>
`;
		break;
	}
	
	editor.replaceSelection(html);
}