$(function(){
    var jsonOptions = {
        collapsed: false,
        withQuotes: false,
    };

    
    $('#sou-button').click(function(){
        $('#sou-div').show()
        $('#sou-logo').hide();
    })
    
    $('#sou-close').click(function(){
        $('#sou-div').hide()
        $('#sou-logo').show();
        $('.ant-input').val('');
        $('.ant-tree-treenode').each(function(){
            $(this).show();
        })
        $('.group').each(function(){
            $(this).find('.ant-tree-switcher').removeClass('ant-tree-switcher_close');
            $(this).find('.ant-tree-switcher').addClass('ant-tree-switcher_open');
        })
    })
    
    $('.ant-input').bind("input propertychange", function() {
        var k = $(this).val()
        $('.ant-tree-treenode').each(function(){
            var t = $(this).text().replace(/\s*/g,'');
            if(t.indexOf(k) >= 0 ) {
                $(this).show();
            } else {
                $(this).hide();
            }
        })
    })
    
    $('.group').click(function(){
        var id = $(this).attr('data-id');
        var t = $('.group-pid-'+id);
        if(t.is(':hidden')){
            t.show()
            $(this).find('.ant-tree-switcher').removeClass('ant-tree-switcher_close');
            $(this).find('.ant-tree-switcher').addClass('ant-tree-switcher_open');
        }else{
            t.hide()
            $(this).find('.ant-tree-switcher').removeClass('ant-tree-switcher_open');
            $(this).find('.ant-tree-switcher').addClass('ant-tree-switcher_close');
        }
    })
    
    $('.version').click(function(){
        var t = $('.version-1');
        if(t.is(':hidden')){
            t.show()
            $(this).find('.ant-tree-switcher').removeClass('ant-tree-switcher_close');
            $(this).find('.ant-tree-switcher').addClass('ant-tree-switcher_open');
        }else{
            t.hide()
            $(this).find('.ant-tree-switcher').removeClass('ant-tree-switcher_open');
            $(this).find('.ant-tree-switcher').addClass('ant-tree-switcher_close');
        }
    })
    
    $('.ant-tabs-nav-list').on('click', '.ant-tabs-tab', function(){
        $(this).parent().find('.ant-tabs-tab').removeClass('ant-tabs-tab-active');
        $(this).addClass('ant-tabs-tab-active');

        var id = $(this).attr('data-id');
        $('#'+id).siblings('.ant-tabs-tabpane').removeClass('ant-tabs-tabpane-active');
        $('#'+id).addClass('ant-tabs-tabpane-active');
    })
    
    $('.drift img').mouseover(function(){
        var src = $(this).attr('src').replace('close', 'click');
        $(this).attr('src', src)
    });
    $('.drift img').mouseout(function(){
        var src = $(this).attr('src').replace('click', 'close');
        $(this).attr('src', src)
    });
    
    var slideOperate = {  
        fadeInTime : 200,
        nextLeft:function(event, ID){ 
            var lastLi = $(ID);  
            $(lastLi).animate({width:"show"},{duration:slideOperate.fadeInTime});  
            event.stopPropagation();
        },
        nextRight:function(event, ID){
            var lastLi = $(ID);
            $(lastLi).animate({width : "hide"},{duration:slideOperate.fadeInTime});  
            event.stopPropagation();
        }  
    };
    
    $(document).bind("click",function(e){
        var target  = $(e.target);
        if(target.closest(".right-div").length == 0){
            slideOperate.nextRight(e, ".right-div");
        }
    })
    
    $('.top-btn').click(function(){
        $('.container___3Wwqw').animate({scrollTop:0}, 200);
    })
    
    $('.usecase-btn').click(function(e){
        slideOperate.nextLeft(e, '.usecase-div');
    })
    
    $('.var-btn').click(function(e){
        slideOperate.nextLeft(e, '.var-div');
    })
    
    $('.fun-btn').click(function(e){
        slideOperate.nextLeft(e, '.fun-div');
    })
    
    $('.fun-div tr').click(function(){
        var html = $(this).find('div').html();
        ace_editor.setValue(html.replace('&lt;', '<'));
        $('.fun-div tr').removeClass('selected-tr');
        $(this).addClass('selected-tr');
    })
    
    $('#usecase-ut-div .ma-bottom-tab li').click(function(){
        $('#usecase-ut-div .ma-bottom-tab li').removeClass('selected');
        $(this).addClass('selected');
        $('#usecase-ut-div .menu-list').hide();
        $('.'+$(this).attr('data-id')).show();
    })
    $('.api_url').click(function(){
        copyTxt($(this).html());
    })
    
    $('.version-btn').click(function(){
        var id = $(this).attr('data-id');
        var info = ajax('/apidoc/version_info', 'post', {
            'id':id,
            'token':$('body').attr('data-token')
        }, false);
        console.log(info);
        if (info == false) {
            return;
        }
        $('#version-div').show();
        $('#body-div').hide();
        $('#word-div').hide();
        $('#code-div').hide();

        $('.version-btn').removeClass('selected');
        $(this).addClass('selected');

        $('#version-main').html(info);
    })
    
    $('.api-btn').click(function(){
        var id = $(this).attr('data-id');
        
        var info = ajax('/apidoc/info', 'post', {
            'id':id,
            'token':$('body').attr('data-token')
        }, false);
        console.log(info);
        if (info == false) {
            return;
        }
        $('.api-btn').removeClass('selected');
        $(this).addClass('selected');
        if (id == 'word') {
            $('#word-div').show();
            $('#code-div').hide();
            $('#body-div').hide();
            $('#version-div').hide();
            if (info.content == null) {
                $('#word-div .group-content').html('<div class="empty-response-examples flex justify-center items-center rounded block-bordered h-32">暂无</div>');
            } else {
                $('#word-div .group-content').html('<div class="empty-response-examples rounded block-bordered p-8">'+info.content+'</div>');
            }
        } else if (id == 'code') {
            $('#code-div').show();
            $('#word-div').hide();
            $('#body-div').hide();
            $('#version-div').hide();
            var html = '';
            info.forEach(v => {
                html += `<tr class="ant-table-row">
                            <td class="ant-table-cell">`+v.code+`</td>
                            <td class="ant-table-cell" style="text-align: center;">`+(v.is_success==1? '<code>是</code>' : '否')+`</td>
                            <td class="ant-table-cell">`+v.param_type+`</td>
                            <td class="ant-table-cell">
                                <div style="min-width: 80px;">`+v.msg+`</div>
                            </td>
                        </tr>`;
            });
            $('#code-list').html(html);
        } else {
            if (info.is_imitate_api == 1) {
                $('#is_imitate_api').show();
            } else {
                $('#is_imitate_api').hide();
            }
            $('#body-div').show();
            $('#word-div').hide();
            $('#code-div').hide();
            $('#version-div').hide();
            $('#api_title').html(info.title);
            $('#api_url').html(info.host_url);
            $('#api_url2').html(info.host_url2);
            $('#param_type').html(info.param);
            $('#is_https').html(info.http);
            $('#request_type').html(info.type);
            $('#request_type2').html(info.type);
            $('#request_type').removeClass('bg-blue-6');
            $('#request_type').removeClass('bg-green-6');
            $('#request_type').removeClass('bg-orange-6');
            $('#request_type2').removeClass('bg-blue-6');
            $('#request_type2').removeClass('bg-green-6');
            $('#request_type2').removeClass('bg-orange-6');
            if (info.type == 'GET'){
                $('#request_type').addClass('bg-green-6');
                $('#request_type2').addClass('bg-green-6');
            } else if (info.type == 'POST'){
                $('#request_type').addClass('bg-blue-6');
                $('#request_type2').addClass('bg-blue-6');
            } else {
                $('#request_type').addClass('bg-orange-6');
                $('#request_type2').addClass('bg-orange-6');
            }
            if (info.status) {
                $('#status_color').show();
                $('#status_text').show();
                $('#status_color').css('background', info.status.color);
                $('#status_text').html(info.status.title);
            } else {
                $('#status_color').hide();
                $('#status_text').hide();
            }
            $('#group_text').html(info.group);
            $('#duty_name').html(info.duty_name);
            $('#update_time').html(info.update_time);
            if (info.action == null) {
                $('#rpc_span').hide();
            } else {
                $('#rpc_span').show();
                $('#rpc').html(info.action);
            }
            $('#api_des').html(info.des);
            $('#return_type').html(info.return_type);
            if (info.content2 == null) {
                $('#add_word_title').hide();
                $('#add_word_div').hide();
            } else {
                $('#add_word_title').show();
                $('#add_word_div').show();
                $('#add_word_div').html('<div class="empty-response-examples rounded block-bordered p-8">'+info.content2+'</div>');
            }
            if ((info.error_list).length == 0) {
                $('#error_title').hide();
                $('#error_div').hide();
            } else {
                $('#error_title').show();
                $('#error_div').show();
                $('#error_tab_list2').html('');
                var html = '';
                var i = 1;
                info.error_list.forEach(v => {
                    html += `<div class="ant-tabs-tab `+(i==1 ? 'ant-tabs-tab-active':'')+`" data-id="error-body-`+i+`">
                                <div class="ant-tabs-tab-btn">`+(v.scene != null ? v.scene : i)+`</div>
                            </div>`;

                    var html2 = `<div class="ant-tabs-tabpane p-4 `+(i==1 ? 'ant-tabs-tabpane-active':'')+`" id="error-body-`+i+`">
                                    <p>`+(v.des ? v.des : '暂无说明')+`</p>
                                    <pre id="error-json-`+i+`" style="width: 100%;max-height:300px;height: 100%;overflow: auto;background: #eaeaea;padding: 20px;"></pre>
                                </div>`;   
                    $('#error_tab_list2').append(html2); 

                    if (if_json(v.json)) {
                        $('#error-json-'+i).jsonViewer(eval('('+v.json+')'), jsonOptions);
                    } else {
                        $('#error-json-'+i).html(v.json);
                    }
                    i++;
                });
                $('#error_tab_list').html(html);
            }
            if ((info.success_list).length == 0) {
                $('#success_title').hide();
                $('#success_div').hide();
            } else {
                $('#success_title').show();
                $('#success_div').show();
                $('#success_tab_list2').html('');
                var html = '';
                var i = 1;
                info.success_list.forEach(v => {
                    html += `<div class="ant-tabs-tab `+(i==1 ? 'ant-tabs-tab-active':'')+`" data-id="success-body-`+i+`">
                                <div class="ant-tabs-tab-btn">`+(v.scene != null ? v.scene : i)+`</div>
                            </div>`;

                    var html2 = `<div class="ant-tabs-tabpane p-4 `+(i==1 ? 'ant-tabs-tabpane-active':'')+`" id="success-body-`+i+`">
                                    <p>`+(v.des ? v.des : '暂无说明')+`</p>
                                    <pre id="success-json-`+i+`" style="width: 100%;max-height:300px;height: 100%;overflow: auto;background: #eaeaea;padding: 20px;"></pre>
                                </div>`;   
                    $('#success_tab_list2').append(html2); 

                    if (if_json(v.json)) {
                        $('#success-json-'+i).jsonViewer(eval('('+v.json+')'), jsonOptions);
                    } else {
                        $('#success-json-'+i).html(v.json);
                    }
                    i++;
                });
                $('#success_tab_list').html(html);
            }
            if ((info.body).length == 0) {
                $('#body_list').html('');
            } else {
                $('#body_list').html('');

                info.body.forEach(v => {
                    var cls = '';
                    if (v.list.length > 0) var cls = 'have-expand expand';
                    $('#body_list').append(`
                    <div class="body-tr level-1 noAfter noBefore">
                      <div class="body-td __cate"><div class="node"><span class="icon `+cls+`" data-class="body`+v.id+`"></span><span>`+v.field+`</span></div></div>
                      <div class="body-td hidden-phone">`+v.param_type+(v.size != null ? '('+v.size+')' : '')+`</div>
                      <div class="body-td hidden-phone">`+(v.no_null==1?'<font color=red>是</font>':'否')+`</div>
                      <div class="body-td hidden-phone">`+(v.default != null ? v.default : '')+`</div>
                      <div class="body-td">`+(v.title != null ? v.title : '')+`</div>
                    </div>`);
                    body_insert(v.list, 2);
                });
            }
            
            if ((info.request).length == 0) {
                $('#request_list').html('');
            } else {
                var html = '';
                info.request.forEach(v => {
                    html += `<tr class="ant-table-row">
                                <td class="ant-table-cell">`+v.field+`
                                </td>
                                <td class="ant-table-cell">`+v.param_type+`</td>
                                <td class="ant-table-cell" style="text-align: center;">`+(v.no_null==1?'<font color=red>是</font>':'否')+`</td>
                                <td class="ant-table-cell">
                                    <div style="min-width: 80px;">`+(v.title != null ? v.title : '')+`</div>
                                </td>
                            </tr>`;
                });
                $('#request_list').html(html);
            }


            if ((info.return).length == 0) {
                $('#data_list').html('');
            } else {
                $('#data_list').html('');
                info.return.forEach(v => {
                    var cls = '';
                    if (v.list.length > 0) var cls = 'have-expand expand';
                    $('#data_list').append(`
                    <div class="body-tr level-1 noAfter noBefore">
                      <div class="body-td __cate"><div class="node"><span class="icon `+cls+`" data-class="return`+v.id+`"></span><span>`+v.field+`</span></div></div>
                      <div class="body-td hidden-phone">`+v.param_type+(v.size != null ? '('+v.size+')' : '')+`</div>
                      <div class="body-td hidden-phone">`+(v.no_null==1?'<font color=red>是</font>':'否')+`</div>
                      <div class="body-td hidden-phone">`+(v.default != null ? v.default : '')+`</div>
                      <div class="body-td">`+(v.title != null ? v.title : '')+`</div>
                    </div>`);
                    return_insert(v.list, 2);
                });
            }

            if ((info.return_field).length == 0) {
                $('#field_list').html('');
            } else {
                var html = '';
                info.return_field.forEach(v => {
                    html += `<tr class="ant-table-row">
                                <td class="ant-table-cell">`+v.field+`
                                </td>
                                <td class="ant-table-cell" style="text-align: center;">`+(v.is_code==1?'<font color=red>是</font>':'否')+`</td>
                                <td class="ant-table-cell" style="text-align: center;">`+(v.is_data==1?'<font color=red>是</font>':'否')+`</td>
                                <td class="ant-table-cell">
                                    <div style="min-width: 80px;">`+(v.title != null ? v.title : '')+`</div>
                                </td>
                            </tr>`;
                });
                $('#field_list').html(html);
            }

            if ((info.return_request).length == 0) {
                $('#return_request_list').html('');
            } else {
                var html = '';
                info.return_request.forEach(v => {
                    html += `<tr class="ant-table-row">
                                <td class="ant-table-cell">`+v.field+`
                                </td>
                                <td class="ant-table-cell">`+v.param_type+(v.size != null ? '('+v.size+')' : '')+`</td>
                                <td class="ant-table-cell" style="text-align: center;">`+(v.no_null==1?'<font color=red>是</font>':'否')+`</td>
                                <td class="ant-table-cell">
                                    <div style="min-width: 80px;">`+(v.title != null ? v.title : '')+`</div>
                                </td>
                            </tr>`;
                });
                $('#return_request_list').html(html);
            }

            if ((info.return_code).length == 0) {
                $('#return_code_list').html('');
            } else {
                var html = '';
                info.return_code.forEach(v => {
                    html += `<tr class="ant-table-row">
                                <td class="ant-table-cell">`+v.code+`</td>
                                <td class="ant-table-cell">
                                    `+(v.msg != null ? v.msg : '')+`
                                </td>
                                <td class="ant-table-cell">`+v.param_type+`</td>
                                <td class="ant-table-cell" style="text-align: center;">`+(v.is_success==1?'<font color=red>是</font>':'否')+`</td>
                            </tr>`;
                });
                $('#return_code_list').html(html);
            }

            if ((info.usecase_list).length == 0) {
                $('.usecase-div').html('<div class="no"> (●ˇ∀ˇ●) 该接口暂未录入用例</div>');
            } else {
                var html = `<div class="title"> 测试用例 </div>
                                <div class="usecase-list">`;
                info.usecase_list.forEach(v => {
                    html += `<div style="padding: 10px 0 0 10px;color: #3d8bf1;font-size: 15px;font-weight: 600;">`+v.title+`</div><ul style="padding-top: 0">`
                    console.log(v.list);
                    v.list.forEach(vv => {
                        html += `<li data-id="`+vv.id+`">`+vv.title+`</li>`;
                    });
                    html += `</ul>`
                });
                html += `</div>`;
                $('.usecase-div').html(html);

                
                $('.usecase-list li').click(function(){
                    var id = $(this).attr('data-id');
                    $.alert({
                        title: '确认运行该用例？',
                        content:'请注意，是否会对生产环境进行数据污染！',
                        buttons: {
                        confirm: {
                            text: '确认',
                            btnClass: 'btn-primary',
                            action: function(){
                                var array = ajax('/apidoc/ordinary_ut', 'post', {'id':id, 'token':$('body').attr('data-token')}, true);
                                console.log(array);
                                if (array !== false) {
                                    $('#usecase_ut_title').val(array.api_title)
                                    $('#usecase_ut_url').val(array.api_url)
                                    $('#usecase_ut_method').val(array.request_type)
                                    $('#usecase_ut_type').val(array.param_type)
                                    $('#usecase_ut_code').val(array.status_code)
                                    $('#usecase_ut_run_time').val(array.run_time+' ms')
                                    
                                    if (array.yes == 1) {
                                        $('#usecase_ut_yes').val('正确')
                                        $('#usecase_ut_yes').css('color', '#59a85c');
                                        $('#usecase_ut_yes_div').hide(); 
                                    } else {
                                        $('#usecase_ut_yes').val('错误')
                                        $('#usecase_ut_yes').css('color', '#ff0057');
                                        $('#usecase_ut_yes_div').show(); 
                                        $('#usecase_ut_yes_des').val(array.yes_des)
                                    }
                                    
                                    if (if_json(array.return_json)) {
                                        $('#usecase-ut-return-json').jsonViewer(eval('('+array.return_json+')'), jsonOptions);
                                    } else {
                                        $('#usecase-ut-return-json').html(array.return_json);
                                    }
                                    if (if_json(array.return_head)) {
                                        $('#usecase-ut-return-header-json').jsonViewer(eval('('+array.return_head+')'), jsonOptions);
                                    } else {
                                        $('#usecase-ut-return-header-json').html(array.return_head);
                                    }
                                    if (if_json(array.body_json)) {
                                        $('#usecase-ut-body-json').jsonViewer(eval('('+array.body_json+')'), jsonOptions);
                                    } else {
                                        $('#usecase-ut-body-json').html(array.body_json);
                                    }
                                    if (if_json(array.request_json)) {
                                        $('#usecase-ut-header-json').jsonViewer(eval('('+array.request_json+')'), jsonOptions);
                                    } else {
                                        $('#usecase-ut-header-json').html(array.request_json);
                                    }

                                    $('#usecase-which').hide();  
                                    $('#usecase-ut-div').show();    
                                }
                            }
                        },
                        cancel: {text: '取消'}
                        }
                    });
                })
            }

            $('.have-expand').click(function(){
                var Class = $(this).attr('data-class');
                if ($(this).hasClass('expand')){
                    /*关闭二级*/
                    $('.'+Class).hide();
                    $(this).removeClass('expand');
                    /*关闭三级*/
                    $('.'+Class+' .node .icon').each(function(){
                        var Class = $(this).attr('data-class');
                        $('.'+Class).hide();
                        $(this).removeClass('expand');
                        /*关闭四级*/
                        $('.'+Class+' .node .icon').each(function(){
                        var Class = $(this).attr('data-class');
                            $('.'+Class).hide();
                            $(this).removeClass('expand');
                            /*关闭五级*/
                            $('.'+Class+' .node .icon').each(function(){
                            var Class = $(this).attr('data-class');
                                $('.'+Class).hide();
                                $(this).removeClass('expand');
                                /*关闭六级*/
                                $('.'+Class+' .node .icon').each(function(){
                                var Class = $(this).attr('data-class');
                                    $('.'+Class).hide();
                                    $(this).removeClass('expand');
                                    /*关闭七级*/
                                    $('.'+Class+' .node .icon').each(function(){
                                    var Class = $(this).attr('data-class');
                                        $('.'+Class).hide();
                                        $(this).removeClass('expand');
                                        /*关闭八级*/
                                        $('.'+Class+' .node .icon').each(function(){
                                        var Class = $(this).attr('data-class');
                                            $('.'+Class).hide();
                                            $(this).removeClass('expand');
                                            /*关闭九级*/
                                            $('.'+Class+' .node .icon').each(function(){
                                            var Class = $(this).attr('data-class');
                                                $('.'+Class).hide();
                                                $(this).removeClass('expand');
                                            });
                                        });
                                    });
                                });
                            });
                        });
                    });
                }else{
                    $('.'+Class).show();
                    $(this).addClass('expand');
                }
            });
        }
    })
})

function body_insert(list, level) {
    list.forEach(v => {
        var cls = '';
        if (v.list.length > 0) var cls = 'have-expand expand';
        $('#body_list').append(`
        <div class="body-tr level-`+level+` leaf body`+v.pid+`">
          <div class="body-td __cate"><div class="node"><span class="icon `+cls+`" data-class="body`+v.id+`"></span><span>`+v.field+`</span></div></div>
          <div class="body-td hidden-phone">`+v.param_type+(v.size != null ? '('+v.size+')' : '')+`</div>
          <div class="body-td hidden-phone">`+(v.no_null==1?'<font color=red>是</font>':'否')+`</div>
          <div class="body-td hidden-phone">`+(v.default != null ? v.default : '')+`</div>
          <div class="body-td">`+(v.title != null ? v.title : '')+`</div>
        </div>`);
        body_insert(v.list, (level+1));
    });
}
function return_insert(list, level) {
    list.forEach(v => {
        var cls = '';
        if (v.list.length > 0) var cls = 'have-expand expand';
        $('#data_list').append(`
        <div class="body-tr level-`+level+` leaf body`+v.pid+`">
          <div class="body-td __cate"><div class="node"><span class="icon `+cls+`" data-class="body`+v.id+`"></span><span>`+v.field+`</span></div></div>
          <div class="body-td hidden-phone">`+v.param_type+(v.size != null ? '('+v.size+')' : '')+`</div>
          <div class="body-td hidden-phone">`+(v.no_null==1?'<font color=red>是</font>':'否')+`</div>
          <div class="body-td hidden-phone">`+(v.default != null ? v.default : '')+`</div>
          <div class="body-td">`+(v.title != null ? v.title : '')+`</div>
        </div>`);
        return_insert(v.list, (level+1));
    });
}