/*
Navicat MySQL Data Transfer

Source Server         : 接口文档
Source Server Version : 50562
Source Host           : 61.216.115.233:3306
Source Database       : api_doc

Target Server Type    : MYSQL
Target Server Version : 50562
File Encoding         : 65001

Date: 2025-01-22 14:49:33
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for swx_api
-- ----------------------------
DROP TABLE IF EXISTS `swx_api`;
CREATE TABLE `swx_api` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `title` varchar(128) DEFAULT NULL,
  `des` text,
  `host_url` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `domain_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `status` tinyint(3) DEFAULT NULL,
  `display` tinyint(1) DEFAULT '1',
  `request_type` tinyint(1) DEFAULT NULL,
  `param_type` tinyint(1) DEFAULT NULL,
  `duty_name` varchar(64) DEFAULT NULL,
  `content2` text,
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  `is_imitate_api` tinyint(1) DEFAULT '2',
  `imitate_route` varchar(255) DEFAULT NULL,
  `imitate_code` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=731 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api
-- ----------------------------

-- ----------------------------
-- Table structure for swx_api_body
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_body`;
CREATE TABLE `swx_api_body` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `pid` bigint(13) DEFAULT '0',
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `size` varchar(32) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `default` varchar(64) DEFAULT NULL,
  `level` tinyint(3) DEFAULT '0' COMMENT '递归层次',
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14216 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api_body
-- ----------------------------

-- ----------------------------
-- Table structure for swx_api_error
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_error`;
CREATE TABLE `swx_api_error` (
  `api_id` bigint(13) NOT NULL,
  `scene` varchar(255) DEFAULT NULL,
  `des` varchar(1024) DEFAULT NULL,
  `json` mediumtext,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api_error
-- ----------------------------

-- ----------------------------
-- Table structure for swx_api_group
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_group`;
CREATE TABLE `swx_api_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL,
  `sort` int(1) DEFAULT '0',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api_group
-- ----------------------------

-- ----------------------------
-- Table structure for swx_api_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_request`;
CREATE TABLE `swx_api_request` (
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api_request
-- ----------------------------

-- ----------------------------
-- Table structure for swx_api_return
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_return`;
CREATE TABLE `swx_api_return` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `pid` bigint(13) DEFAULT '0',
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `size` varchar(32) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `default` varchar(64) DEFAULT NULL COMMENT '默认值',
  `level` tinyint(3) DEFAULT '0' COMMENT '递归层次',
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17960 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api_return
-- ----------------------------

-- ----------------------------
-- Table structure for swx_api_return_code
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_return_code`;
CREATE TABLE `swx_api_return_code` (
  `api_id` bigint(13) DEFAULT NULL,
  `code` varchar(64) DEFAULT NULL,
  `msg` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `is_success` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api_return_code
-- ----------------------------

-- ----------------------------
-- Table structure for swx_api_return_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_return_request`;
CREATE TABLE `swx_api_return_request` (
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api_return_request
-- ----------------------------

-- ----------------------------
-- Table structure for swx_api_success
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_success`;
CREATE TABLE `swx_api_success` (
  `api_id` bigint(13) NOT NULL,
  `scene` varchar(255) DEFAULT NULL,
  `des` varchar(1024) DEFAULT NULL,
  `json` mediumtext,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_api_success
-- ----------------------------

-- ----------------------------
-- Table structure for swx_auth_admin
-- ----------------------------
DROP TABLE IF EXISTS `swx_auth_admin`;
CREATE TABLE `swx_auth_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) DEFAULT NULL,
  `password` varchar(32) DEFAULT '0',
  `role_id` int(11) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `phone` varchar(32) DEFAULT NULL,
  `email` varchar(64) DEFAULT NULL,
  `fullname` varchar(32) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_auth_admin
-- ----------------------------
INSERT INTO `swx_auth_admin` VALUES ('1', 'swoolex', 'a34c97cb7c6ad519981659f3600d593e', '0', '1', '', '', '小黄牛', '1641539720', '1641628742');
INSERT INTO `swx_auth_admin` VALUES ('11', 'test', 'df0f0e053928acee9001f9de2cb763fd', '1', '1', '', '', '测试', '1643006354', '1643006366');

-- ----------------------------
-- Table structure for swx_auth_menu
-- ----------------------------
DROP TABLE IF EXISTS `swx_auth_menu`;
CREATE TABLE `swx_auth_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT '0',
  `menu_name` varchar(64) DEFAULT NULL,
  `route` varchar(128) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `path` varchar(255) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_auth_menu
-- ----------------------------
INSERT INTO `swx_auth_menu` VALUES ('1', '0', '接口管理', '/', '1', '1', '1643003299');
INSERT INTO `swx_auth_menu` VALUES ('3', '1', '接口列表', '/api/api/showlist', '1', '1/3', '1643002464');
INSERT INTO `swx_auth_menu` VALUES ('4', '3', '复制接口', '/api/api/copy', '1', '1/3/4', '1643002481');
INSERT INTO `swx_auth_menu` VALUES ('5', '3', '删除接口', '/api/api/delete', '1', '1/3/5', '1643002488');
INSERT INTO `swx_auth_menu` VALUES ('6', '3', '导出接口文档为HTML格式', '/api/api/export_html', '1', '1/3/6', '1643002498');
INSERT INTO `swx_auth_menu` VALUES ('7', '3', '获取公共状态码', '/api/api/get_code', '1', '1/3/7', '1643002515');
INSERT INTO `swx_auth_menu` VALUES ('8', '3', '获取公共请求头查询', '/api/api/get_request', '1', '1/3/8', '1643002523');
INSERT INTO `swx_auth_menu` VALUES ('9', '3', '获取公共响应头查询', '/api/api/get_return_request', '1', '1/3/9', '1643002546');
INSERT INTO `swx_auth_menu` VALUES ('10', '3', '获取接口地址', '/api/api/get_url', '1', '1/3/10', '1643002556');
INSERT INTO `swx_auth_menu` VALUES ('11', '3', '获取接口详情', '/api/api/info', '1', '1/3/11', '1643002569');
INSERT INTO `swx_auth_menu` VALUES ('12', '3', '创建接口', '/api/api/insert', '1', '1/3/12', '1643002578');
INSERT INTO `swx_auth_menu` VALUES ('13', '3', '移动接口到分组', '/api/api/move', '1', '1/3/13', '1643002599');
INSERT INTO `swx_auth_menu` VALUES ('14', '3', '编辑接口', '/api/api/update', '1', '1/3/14', '1643002616');
INSERT INTO `swx_auth_menu` VALUES ('15', '1', '根域名列表', '/api/domain/showlist', '1', '1/15', '1643002647');
INSERT INTO `swx_auth_menu` VALUES ('16', '15', '读取根域名详情', '/api/domain/info', '1', '1/15/16', '1643002656');
INSERT INTO `swx_auth_menu` VALUES ('17', '15', '新增根域名', '/api/domain/insert', '1', '1/15/17', '1643002665');
INSERT INTO `swx_auth_menu` VALUES ('18', '15', '编辑根域名', '/api/domain/update', '1', '1/15/18', '1643002675');
INSERT INTO `swx_auth_menu` VALUES ('19', '15', '删除根域名', '/api/domain/delete', '1', '1/15/19', '1643002688');
INSERT INTO `swx_auth_menu` VALUES ('20', '1', '负责人员列表', '/api/duty/showlist', '1', '1/20', '1643002792');
INSERT INTO `swx_auth_menu` VALUES ('21', '20', '新增负责人员', '/api/duty/insert', '1', '1/20/21', '1643002817');
INSERT INTO `swx_auth_menu` VALUES ('22', '20', '编辑负责人员', '/api/duty/update', '1', '1/20/22', '1643002825');
INSERT INTO `swx_auth_menu` VALUES ('23', '20', '删除负责人员', '/api/duty/delete', '1', '1/20/23', '1643002833');
INSERT INTO `swx_auth_menu` VALUES ('24', '1', '分组列表', '/api/group/showlist', '1', '1/24', '1643002896');
INSERT INTO `swx_auth_menu` VALUES ('25', '24', '新增分组', '/api/group/insert', '1', '1/24/25', '1643002910');
INSERT INTO `swx_auth_menu` VALUES ('26', '24', '编辑分组', '/api/group/update', '1', '1/24/26', '1643002925');
INSERT INTO `swx_auth_menu` VALUES ('27', '24', '删除分组', '/api/group/delete', '1', '1/24/27', '1643002940');
INSERT INTO `swx_auth_menu` VALUES ('28', '24', '读取分组详情', '/api/group/info', '1', '1/24/28', '1643002946');
INSERT INTO `swx_auth_menu` VALUES ('29', '1', '项目列表', '/api/item/showlist', '1', '1/29', '1643002985');
INSERT INTO `swx_auth_menu` VALUES ('30', '29', '新增项目', '/api/item/insert', '1', '1/29/30', '1643002999');
INSERT INTO `swx_auth_menu` VALUES ('31', '29', '编辑项目', '/api/item/update', '1', '1/29/31', '1643003006');
INSERT INTO `swx_auth_menu` VALUES ('32', '29', '删除项目', '/api/item/delete', '1', '1/29/32', '1643003011');
INSERT INTO `swx_auth_menu` VALUES ('33', '29', '读取项目详情', '/api/item/info', '1', '1/29/33', '1643003018');
INSERT INTO `swx_auth_menu` VALUES ('34', '1', '返回值结构列表', '/api/returns/showlist', '1', '1/34', '1643003061');
INSERT INTO `swx_auth_menu` VALUES ('35', '34', '新增返回值结构', '/api/returns/insert', '1', '1/34/35', '1643003079');
INSERT INTO `swx_auth_menu` VALUES ('36', '34', '编辑返回值结构', '/api/returns/update', '1', '1/34/36', '1643003086');
INSERT INTO `swx_auth_menu` VALUES ('37', '34', '删除返回值结构', '/api/returns/delete', '1', '1/34/37', '1643003091');
INSERT INTO `swx_auth_menu` VALUES ('38', '34', '读取返回结构详情', '/api/returns/info', '1', '1/34/38', '1643003101');
INSERT INTO `swx_auth_menu` VALUES ('39', '1', '状态列表', '/api/status/showlist', '1', '1/39', '1643003128');
INSERT INTO `swx_auth_menu` VALUES ('40', '39', '新增状态', '/api/status/insert', '1', '1/39/40', '1643003143');
INSERT INTO `swx_auth_menu` VALUES ('41', '39', '编辑状态', '/api/status/update', '1', '1/39/41', '1643003149');
INSERT INTO `swx_auth_menu` VALUES ('42', '39', '删除状态', '/api/status/delete', '1', '1/39/42', '1643003158');
INSERT INTO `swx_auth_menu` VALUES ('43', '39', '读取状态详情', '/api/status/info', '1', '1/39/43', '1643003165');
INSERT INTO `swx_auth_menu` VALUES ('44', '0', '文档管理', '/word', '1', '44', '1643003289');
INSERT INTO `swx_auth_menu` VALUES ('45', '44', '文档列表', '/word/index/showlist', '1', '44/45', '1643003360');
INSERT INTO `swx_auth_menu` VALUES ('46', '45', '新增文档', '/word/index/insert', '1', '44/45/46', '1643003377');
INSERT INTO `swx_auth_menu` VALUES ('47', '45', '编辑文档', '/word/index/update', '1', '44/45/47', '1643003386');
INSERT INTO `swx_auth_menu` VALUES ('48', '45', '删除文档', '/word/index/delete', '1', '44/45/48', '1643003392');
INSERT INTO `swx_auth_menu` VALUES ('49', '45', '读取文档详情', '/word/index/info', '1', '44/45/49', '1643003399');
INSERT INTO `swx_auth_menu` VALUES ('50', '44', '章节列表', '/word/tree/showlist', '1', '44/50', '1643003419');
INSERT INTO `swx_auth_menu` VALUES ('51', '50', '新增章节', '/word/tree/insert', '1', '44/50/51', '1643003431');
INSERT INTO `swx_auth_menu` VALUES ('52', '50', '编辑章节', '/word/tree/update', '1', '44/50/52', '1643003441');
INSERT INTO `swx_auth_menu` VALUES ('53', '50', '删除章节', '/word/tree/delete', '1', '44/50/53', '1643003447');
INSERT INTO `swx_auth_menu` VALUES ('54', '50', '读取章节详情', '/word/tree/info', '1', '44/50/54', '1643003453');
INSERT INTO `swx_auth_menu` VALUES ('55', '44', '可预览人员列表', '/word/user/showlist', '1', '44/55', '1643003518');
INSERT INTO `swx_auth_menu` VALUES ('56', '55', '新增可预览人员', '/word/user/insert', '1', '44/55/56', '1643003531');
INSERT INTO `swx_auth_menu` VALUES ('57', '55', '编辑可预览人员', '/word/user/update', '1', '44/55/57', '1643003538');
INSERT INTO `swx_auth_menu` VALUES ('58', '55', '删除可预览人员', '/word/user/delete', '1', '44/55/58', '1643003545');
INSERT INTO `swx_auth_menu` VALUES ('59', '55', '读取可预览人员详情', '/word/user/info', '1', '44/55/59', '1643003550');
INSERT INTO `swx_auth_menu` VALUES ('60', '0', '测试管理', '/test', '1', '60', '1643003574');
INSERT INTO `swx_auth_menu` VALUES ('61', '60', '变量列表', '/test/vars/showlist', '1', '60/61', '1643003857');
INSERT INTO `swx_auth_menu` VALUES ('62', '61', '编辑变量', '/test/vars/update', '1', '60/61/62', '1643003880');
INSERT INTO `swx_auth_menu` VALUES ('63', '60', '函数列表', '/test/fun/showlist', '1', '60/63', '1643003902');
INSERT INTO `swx_auth_menu` VALUES ('64', '63', '创建函数', '/test/fun/insert', '1', '60/63/64', '1643003920');
INSERT INTO `swx_auth_menu` VALUES ('65', '63', '编辑函数', '/test/fun/update', '1', '60/63/65', '1643003930');
INSERT INTO `swx_auth_menu` VALUES ('66', '63', '删除函数', '/test/fun/delete', '1', '60/63/66', '1643003936');
INSERT INTO `swx_auth_menu` VALUES ('67', '63', '获取函数详情', '/test/fun/info', '1', '60/63/67', '1643003943');
INSERT INTO `swx_auth_menu` VALUES ('68', '60', '用例列表', '/test/usecase/showlist', '1', '60/68', '1643004106');
INSERT INTO `swx_auth_menu` VALUES ('69', '68', '设置用例', '/test/usecase/update', '1', '60/68/69', '1643004259');
INSERT INTO `swx_auth_menu` VALUES ('70', '68', '删除用例', '/test/usecase/delete', '1', '60/68/70', '1643004265');
INSERT INTO `swx_auth_menu` VALUES ('71', '68', '读取用例详情', '/test/usecase/info', '1', '60/68/71', '1643004279');
INSERT INTO `swx_auth_menu` VALUES ('72', '68', '运行用例', '/test/usecase/ordinary_ut', '1', '60/68/72', '1643004405');
INSERT INTO `swx_auth_menu` VALUES ('73', '68', '创建单元测试任务', '/test/usecase/whole_ut', '1', '60/68/73', '1643004420');
INSERT INTO `swx_auth_menu` VALUES ('74', '68', '创建压力测试任务', '/test/usecase/ab_create', '1', '60/68/74', '1643004442');
INSERT INTO `swx_auth_menu` VALUES ('75', '60', '单元测试任务列表', '/test/usecase/ut_list', '1', '60/75', '1643004487');
INSERT INTO `swx_auth_menu` VALUES ('76', '75', '任务记录详情', '/test/usecase/ut_log_info', '1', '60/75/76', '1643004516');
INSERT INTO `swx_auth_menu` VALUES ('77', '75', '任务记录列表', '/test/usecase/ut_log', '1', '60/75/77', '1643004529');
INSERT INTO `swx_auth_menu` VALUES ('78', '60', '获取接口列表，带分组信息', '/test/usecase/group_api_list', '1', '60/78', '1643004575');
INSERT INTO `swx_auth_menu` VALUES ('79', '60', '压力测试任务列表', '/test/usecase/ab_list', '1', '60/79', '1643004639');
INSERT INTO `swx_auth_menu` VALUES ('80', '79', '任务记录详情', '/test/usecase/ab_chat', '1', '60/79/80', '1643004662');
INSERT INTO `swx_auth_menu` VALUES ('81', '60', '集成测试任务列表', '/test/usecase/at_list', '1', '60/81', '1643004715');
INSERT INTO `swx_auth_menu` VALUES ('82', '81', '创建集成测试模板', '/test/usecase/at_create', '1', '60/81/82', '1643004731');
INSERT INTO `swx_auth_menu` VALUES ('83', '81', '编辑集成测试模板', '/test/usecase/at_update', '1', '60/81/83', '1643004742');
INSERT INTO `swx_auth_menu` VALUES ('84', '81', '删除集成测试模板', '/test/usecase/at_delete', '1', '60/81/84', '1643004748');
INSERT INTO `swx_auth_menu` VALUES ('85', '81', '读取集成测试模板详情', '/test/usecase/at_info', '1', '60/81/85', '1643004756');
INSERT INTO `swx_auth_menu` VALUES ('86', '81', '集成测试报告列表', '/test/usecase/task_index', '1', '60/81/86', '1643004786');
INSERT INTO `swx_auth_menu` VALUES ('87', '81', '集成测试-报告详情', '/test/usecase/task_log', '1', '60/81/87', '1643004796');
INSERT INTO `swx_auth_menu` VALUES ('88', '81', '立即启动集成测试任务', '/test/usecase/task_create', '1', '60/81/88', '1643004807');
INSERT INTO `swx_auth_menu` VALUES ('89', '81', '创建集成测试定时任务', '/test/usecase/timing_index_ajax', '1', '60/81/89', '1643004846');
INSERT INTO `swx_auth_menu` VALUES ('90', '81', '编辑集成测试-集成树', '/test/usecase/template_tree', '1', '60/81/90', '1643004857');
INSERT INTO `swx_auth_menu` VALUES ('91', '90', '编辑集成树节点-对应的请求参数', '/test/usecase/template_tree_param', '1', '60/81/90/91', '1643004878');
INSERT INTO `swx_auth_menu` VALUES ('92', '90', '编辑集成树节点-对应的请求参数-提交处理', '/test/usecase/template_tree_param_ajax', '1', '60/81/90/92', '1643004919');
INSERT INTO `swx_auth_menu` VALUES ('93', '90', '编辑集成树节点-等候时间', '/test/usecase/template_tree_update_ajax', '1', '60/81/90/93', '1643004956');
INSERT INTO `swx_auth_menu` VALUES ('94', '90', '删除集成树节点', '/test/usecase/template_tree_delete', '1', '60/81/90/94', '1643005047');
INSERT INTO `swx_auth_menu` VALUES ('95', '0', '账号管理', '/auth', '1', '95', '1643005270');
INSERT INTO `swx_auth_menu` VALUES ('96', '95', '账号列表', '/auth/admin/showlist', '1', '95/96', '1643005283');
INSERT INTO `swx_auth_menu` VALUES ('97', '96', '新增账号', '/auth/admin/insert', '1', '95/96/97', '1643005292');
INSERT INTO `swx_auth_menu` VALUES ('98', '96', '编辑账号', '/auth/admin/update', '1', '95/96/98', '1643005298');
INSERT INTO `swx_auth_menu` VALUES ('99', '96', '删除账号', '/auth/admin/delete', '1', '95/96/99', '1643005303');
INSERT INTO `swx_auth_menu` VALUES ('100', '96', '读取账号详情', '/auth/admin/info', '1', '95/96/100', '1643005310');
INSERT INTO `swx_auth_menu` VALUES ('101', '95', '角色列表', '/auth/role/showlist', '1', '95/101', '1643005375');
INSERT INTO `swx_auth_menu` VALUES ('102', '101', '新增角色', '/auth/role/insert', '1', '95/101/102', '1643005389');
INSERT INTO `swx_auth_menu` VALUES ('103', '101', '编辑角色', '/auth/role/update', '1', '95/101/103', '1643005399');
INSERT INTO `swx_auth_menu` VALUES ('104', '101', '删除角色', '/auth/role/delete', '1', '95/101/104', '1643005404');
INSERT INTO `swx_auth_menu` VALUES ('105', '101', '读取角色详情', '/auth/role/info', '1', '95/101/105', '1643005411');
INSERT INTO `swx_auth_menu` VALUES ('106', '101', '获取菜单配置', '/auth/role/get_menu', '1', '95/101/106', '1643005420');
INSERT INTO `swx_auth_menu` VALUES ('107', '95', '权限列表', '/auth/menu/showlist', '1', '95/107', '1643005445');
INSERT INTO `swx_auth_menu` VALUES ('108', '107', '新增菜单', '/auth/menu/insert', '1', '95/107/108', '1643005455');
INSERT INTO `swx_auth_menu` VALUES ('109', '107', '编辑菜单', '/auth/menu/update', '1', '95/107/109', '1643005469');
INSERT INTO `swx_auth_menu` VALUES ('110', '107', '删除菜单', '/auth/menu/delete', '1', '95/107/110', '1643005474');
INSERT INTO `swx_auth_menu` VALUES ('111', '107', '读取菜单详情', '/auth/menu/info', '1', '95/107/111', '1643005480');
INSERT INTO `swx_auth_menu` VALUES ('112', '0', '公共权限', '/common', '1', '112', '1643005492');
INSERT INTO `swx_auth_menu` VALUES ('113', '112', '读取接口列表', '/common/get_api', '1', '112/113', '1643005531');
INSERT INTO `swx_auth_menu` VALUES ('114', '112', '读取用例列表', '/common/get_usecase', '1', '112/114', '1643005542');
INSERT INTO `swx_auth_menu` VALUES ('115', '112', '修改当前账号密码', '/common/pwd_edit', '1', '112/115', '1643005553');
INSERT INTO `swx_auth_menu` VALUES ('116', '112', 'md编辑器图片上传', '/common/posts_img', '1', '112/116', '1643005561');
INSERT INTO `swx_auth_menu` VALUES ('117', '112', '接口附加文档图片上传', '/common/api_img', '1', '112/117', '1643005570');
INSERT INTO `swx_auth_menu` VALUES ('118', '3', '修改排序', '/api/api/sort', '1', '1/3/118', '1643089894');
INSERT INTO `swx_auth_menu` VALUES ('119', '90', '新增集成树节点', '/test/usecase/template_tree_insert_ajax', '1', '60/81/90/119', '1643090812');
INSERT INTO `swx_auth_menu` VALUES ('120', '68', '复制用例', '/test/usecase/copy', '1', '60/68/120', '1643100555');
INSERT INTO `swx_auth_menu` VALUES ('121', '3', '导出接口文档为Doc格式', '/api/api/export_doc', '1', '1/3/121', '1644491751');
INSERT INTO `swx_auth_menu` VALUES ('122', '29', '选择项目', '/api/item/select', '1', '1/29/122', '1646027243');
INSERT INTO `swx_auth_menu` VALUES ('123', '3', '导出接口文档为Json格式', '/api/api/export_json', '1', '1/3/123', '1646029158');
INSERT INTO `swx_auth_menu` VALUES ('124', '0', '回收站', '/trash/select', '1', '124', '1646030747');
INSERT INTO `swx_auth_menu` VALUES ('126', '124', '删除垃圾', '/trash/delete', '1', '124/126', '1646030800');
INSERT INTO `swx_auth_menu` VALUES ('128', '124', '恢复垃圾', '/trash/recovery', '1', '124/128', '1646030859');
INSERT INTO `swx_auth_menu` VALUES ('129', '3', '解析json文本', '/api/api/import_json', '1', '1/3/129', '1646373289');
INSERT INTO `swx_auth_menu` VALUES ('130', '3', '发布接口版本记录', '/api/api/version_send', '1', '1/3/130', '1650446101');
INSERT INTO `swx_auth_menu` VALUES ('131', '60', '用例分组列表', '/test/group/showlist', '1', '60/131', '1653458359');
INSERT INTO `swx_auth_menu` VALUES ('132', '131', '新增分组', '/test/group/insert', '1', '60/131/132', '1653458399');
INSERT INTO `swx_auth_menu` VALUES ('133', '131', '编辑分组', '/test/group/update', '1', '60/131/133', '1653458413');
INSERT INTO `swx_auth_menu` VALUES ('134', '131', '删除分组', '/test/group/delete', '1', '60/131/134', '1653458424');
INSERT INTO `swx_auth_menu` VALUES ('135', '131', '读取分组详情', '/test/group/info', '1', '60/131/135', '1653458432');
INSERT INTO `swx_auth_menu` VALUES ('136', '131', '复制分组', '/test/group/copy', '1', '60/131/136', '1653461675');
INSERT INTO `swx_auth_menu` VALUES ('137', '131', '全组变更环境', '/test/group/env_save', '1', '60/131/137', '1653466426');
INSERT INTO `swx_auth_menu` VALUES ('138', '75', '删除测试记录', '/test/usecase/ut_delete', '1', '60/75/138', '1655881632');
INSERT INTO `swx_auth_menu` VALUES ('139', '79', '删除测试记录', '/test/usecase/ab_delete', '1', '60/79/139', '1655881654');
INSERT INTO `swx_auth_menu` VALUES ('140', '0', '代码片段', '/code', '1', '140', '1655882989');
INSERT INTO `swx_auth_menu` VALUES ('141', '0', '自助词库', '/robot', '1', '141', '1655883009');
INSERT INTO `swx_auth_menu` VALUES ('142', '140', '分类列表', '/code/type/showlist', '1', '140/142', '1655889027');
INSERT INTO `swx_auth_menu` VALUES ('143', '142', '新增', '/code/type/insert', '1', '140/142/143', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('144', '142', '删除', '/code/type/delete', '1', '140/142/144', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('145', '142', '编辑', '/code/type/update', '1', '140/142/145', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('146', '142', '详情', '/code/type/info', '1', '140/142/146', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('147', '140', '结构列表', '/code/ste/showlist', '1', '140/147', '1655889027');
INSERT INTO `swx_auth_menu` VALUES ('148', '147', '新增', '/code/ste/insert', '1', '140/147/148', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('149', '147', '删除', '/code/ste/delete', '1', '140/147/149', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('150', '147', '编辑', '/code/ste/update', '1', '140/147/150', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('151', '147', '详情', '/code/ste/info', '1', '140/147/151', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('152', '140', '标签列表', '/code/lable/showlist', '1', '140/152', '1655889027');
INSERT INTO `swx_auth_menu` VALUES ('153', '152', '新增', '/code/lable/insert', '1', '140/152/153', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('154', '152', '删除', '/code/lable/delete', '1', '140/152/154', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('155', '152', '编辑', '/code/lable/update', '1', '140/152/155', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('156', '152', '详情', '/code/lable/info', '1', '140/152/156', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('157', '140', '代码片段列表', '/code/index/showlist', '1', '140/157', '1655889027');
INSERT INTO `swx_auth_menu` VALUES ('158', '157', '新增', '/code/index/insert', '1', '140/157/158', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('159', '157', '删除', '/code/index/delete', '1', '140/157/159', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('160', '157', '编辑', '/code/index/update', '1', '140/157/160', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('161', '157', '详情', '/code/index/info', '1', '140/157/161', '1655889043');
INSERT INTO `swx_auth_menu` VALUES ('162', '141', '分类列表', '/robot/type/showlist', '1', '141/162', '1656053787');
INSERT INTO `swx_auth_menu` VALUES ('163', '162', '新增', '/robot/type/insert', '1', '141/162/163', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('164', '162', '删除', '/robot/type/delete', '1', '141/162/164', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('165', '162', '编辑', '/robot/type/update', '1', '141/162/165', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('166', '162', '详情', '/robot/type/info', '1', '141/162/166', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('167', '141', '标签列表', '/robot/lable/showlist', '1', '141/167', '1656053787');
INSERT INTO `swx_auth_menu` VALUES ('168', '167', '新增', '/robot/lable/insert', '1', '141/167/168', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('169', '167', '删除', '/robot/lable/delete', '1', '141/167/169', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('170', '167', '编辑', '/robot/lable/update', '1', '141/167/170', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('171', '167', '详情', '/robot/lable/info', '1', '141/167/171', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('172', '141', '词库列表', '/robot/index/showlist', '1', '141/172', '1656053787');
INSERT INTO `swx_auth_menu` VALUES ('173', '172', '新增', '/robot/index/insert', '1', '141/172/173', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('174', '172', '删除', '/robot/index/delete', '1', '141/172/174', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('175', '172', '编辑', '/robot/index/update', '1', '141/172/175', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('176', '172', '详情', '/robot/index/info', '1', '141/172/176', '1656053813');
INSERT INTO `swx_auth_menu` VALUES ('177', '112', 'EI 智能-问题推荐', '/robot/tuijian', '1', '112/177', '1656064067');
INSERT INTO `swx_auth_menu` VALUES ('178', '112', 'EI 智能-问题回答', '/robot/logic', '1', '112/178', '1656064090');

-- ----------------------------
-- Table structure for swx_auth_role
-- ----------------------------
DROP TABLE IF EXISTS `swx_auth_role`;
CREATE TABLE `swx_auth_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_name` varchar(64) DEFAULT NULL,
  `menu_list` mediumtext,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_auth_role
-- ----------------------------
INSERT INTO `swx_auth_role` VALUES ('1', '测试专员', '1,3,11,24,28,29,33,122,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,120,75,76,77,138,78,79,80,139,81,82,83,84,85,86,87,88,89,90,91,92,93,94,119,131,132,133,134,135,136,137,112,113,114,115,116,117,177,178', '1643006341');
INSERT INTO `swx_auth_role` VALUES ('2', '测试组长', '1,3,4,5,6,7,8,9,10,11,12,13,14,118,121,123,129,130,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,122,34,35,36,37,38,39,40,41,42,43,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,120,75,76,77,138,78,79,80,139,81,82,83,84,85,86,87,88,89,90,91,92,93,94,119,131,132,133,134,135,136,137,112,113,114,115,116,117,177,178', '1650962928');
INSERT INTO `swx_auth_role` VALUES ('3', '代码片段', '112,177,178,140,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161', '1658907799');

-- ----------------------------
-- Table structure for swx_code_data
-- ----------------------------
DROP TABLE IF EXISTS `swx_code_data`;
CREATE TABLE `swx_code_data` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `ste_id` int(11) DEFAULT NULL,
  `lable_id` int(11) DEFAULT NULL,
  `content` longtext,
  `admin_id` int(11) DEFAULT NULL COMMENT '创建者',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_code_data
-- ----------------------------

-- ----------------------------
-- Table structure for swx_code_lable
-- ----------------------------
DROP TABLE IF EXISTS `swx_code_lable`;
CREATE TABLE `swx_code_lable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL COMMENT '标签名',
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_code_lable
-- ----------------------------

-- ----------------------------
-- Table structure for swx_code_ste
-- ----------------------------
DROP TABLE IF EXISTS `swx_code_ste`;
CREATE TABLE `swx_code_ste` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL COMMENT '结构名称',
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_code_ste
-- ----------------------------

-- ----------------------------
-- Table structure for swx_code_type
-- ----------------------------
DROP TABLE IF EXISTS `swx_code_type`;
CREATE TABLE `swx_code_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL COMMENT '分类名称',
  `sort` int(11) DEFAULT '0' COMMENT '排序，越大越靠前',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_code_type
-- ----------------------------

-- ----------------------------
-- Table structure for swx_config
-- ----------------------------
DROP TABLE IF EXISTS `swx_config`;
CREATE TABLE `swx_config` (
  `id` int(11) NOT NULL,
  `email_type` varchar(32) DEFAULT '' COMMENT '邮件协议类型',
  `email_encryption_type` varchar(32) DEFAULT '' COMMENT '邮件加密类型',
  `email_ip` varchar(64) DEFAULT NULL COMMENT '邮箱服务器IP',
  `email_port` varchar(32) DEFAULT NULL COMMENT '邮箱服务器端口',
  `email_name` varchar(64) DEFAULT NULL COMMENT '邮箱服务器账号',
  `email_pwd` varchar(64) DEFAULT NULL COMMENT '邮箱服务器密码',
  `domain` varchar(255) DEFAULT NULL COMMENT '站点域名',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_config
-- ----------------------------
INSERT INTO `swx_config` VALUES ('1', 'SMTP', 'ssl', 'smtp.qq.com', '465', '', '', '');

-- ----------------------------
-- Table structure for swx_domain
-- ----------------------------
DROP TABLE IF EXISTS `swx_domain`;
CREATE TABLE `swx_domain` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_domain
-- ----------------------------

-- ----------------------------
-- Table structure for swx_duty
-- ----------------------------
DROP TABLE IF EXISTS `swx_duty`;
CREATE TABLE `swx_duty` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `duty_name` varchar(32) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_duty
-- ----------------------------
INSERT INTO `swx_duty` VALUES ('2', 'EI-Test', '1622616402', '1622616402');

-- ----------------------------
-- Table structure for swx_email
-- ----------------------------
DROP TABLE IF EXISTS `swx_email`;
CREATE TABLE `swx_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(32) DEFAULT NULL COMMENT '人员名称',
  `email` varchar(64) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1' COMMENT '0.禁用 1.启用',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_email
-- ----------------------------

-- ----------------------------
-- Table structure for swx_item
-- ----------------------------
DROP TABLE IF EXISTS `swx_item`;
CREATE TABLE `swx_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL,
  `domain_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `pwd` varchar(64) DEFAULT NULL,
  `doc_id` varchar(32) DEFAULT NULL,
  `content` text,
  `version` varchar(16) DEFAULT NULL,
  `is_var` tinyint(1) DEFAULT '1',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  `domain_list` text COMMENT '环境支持，多个使用,符合分隔',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否在文档列表显示   1.显示  2.关闭',
  `cover_file` varchar(255) DEFAULT NULL COMMENT '文档列表，封面图',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_item
-- ----------------------------

-- ----------------------------
-- Table structure for swx_return
-- ----------------------------
DROP TABLE IF EXISTS `swx_return`;
CREATE TABLE `swx_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL,
  `return_type` tinyint(1) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_return
-- ----------------------------

-- ----------------------------
-- Table structure for swx_return_field
-- ----------------------------
DROP TABLE IF EXISTS `swx_return_field`;
CREATE TABLE `swx_return_field` (
  `pid` int(11) NOT NULL,
  `title` varchar(64) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `is_code` tinyint(1) DEFAULT '0',
  `is_data` tinyint(1) DEFAULT '0',
  KEY `pid` (`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_return_field
-- ----------------------------

-- ----------------------------
-- Table structure for swx_robot_data
-- ----------------------------
DROP TABLE IF EXISTS `swx_robot_data`;
CREATE TABLE `swx_robot_data` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `lable_id` int(11) DEFAULT NULL,
  `content` longtext,
  `num` bigint(13) DEFAULT '0',
  `admin_id` int(11) DEFAULT NULL COMMENT '创建者',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_robot_data
-- ----------------------------

-- ----------------------------
-- Table structure for swx_robot_lable
-- ----------------------------
DROP TABLE IF EXISTS `swx_robot_lable`;
CREATE TABLE `swx_robot_lable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL COMMENT '标签名',
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_robot_lable
-- ----------------------------

-- ----------------------------
-- Table structure for swx_robot_type
-- ----------------------------
DROP TABLE IF EXISTS `swx_robot_type`;
CREATE TABLE `swx_robot_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL COMMENT '分类名称',
  `sort` int(11) DEFAULT '0' COMMENT '排序，越大越靠前',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_robot_type
-- ----------------------------

-- ----------------------------
-- Table structure for swx_status
-- ----------------------------
DROP TABLE IF EXISTS `swx_status`;
CREATE TABLE `swx_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `color` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_status
-- ----------------------------
INSERT INTO `swx_status` VALUES ('1', '已发布', '#4ab793');
INSERT INTO `swx_status` VALUES ('2', '设计中', '#8fc016');
INSERT INTO `swx_status` VALUES ('3', '待确定', '#dcc118');
INSERT INTO `swx_status` VALUES ('4', '开发中', '#1c82e0');
INSERT INTO `swx_status` VALUES ('5', '联调中', '#cf2f87');
INSERT INTO `swx_status` VALUES ('6', '测试中', '#d17c35');
INSERT INTO `swx_status` VALUES ('7', '已测完', '#8469d1');
INSERT INTO `swx_status` VALUES ('8', '已废弃', '#aaaaaa');
INSERT INTO `swx_status` VALUES ('9', '有异常', '#de6783');

-- ----------------------------
-- Table structure for swx_task
-- ----------------------------
DROP TABLE IF EXISTS `swx_task`;
CREATE TABLE `swx_task` (
  `id` int(13) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) DEFAULT NULL,
  `is_timing` tinyint(1) DEFAULT '0',
  `status` tinyint(1) DEFAULT '0',
  `start_time` int(11) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `task_start_time` int(11) DEFAULT NULL,
  `task_end_time` int(11) DEFAULT NULL,
  `success_num` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_task
-- ----------------------------

-- ----------------------------
-- Table structure for swx_task_log
-- ----------------------------
DROP TABLE IF EXISTS `swx_task_log`;
CREATE TABLE `swx_task_log` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `template_id` int(11) DEFAULT NULL,
  `tree_id` bigint(13) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `api_id` bigint(13) DEFAULT NULL,
  `usecase_id` bigint(13) DEFAULT NULL,
  `api_title` varchar(128) DEFAULT NULL,
  `api_url` varchar(255) DEFAULT NULL,
  `request_type` tinyint(1) DEFAULT NULL,
  `param_type` tinyint(1) DEFAULT NULL,
  `request_json` mediumtext,
  `body_json` mediumtext,
  `return_json` mediumtext,
  `status_code` varchar(16) DEFAULT NULL,
  `err_code` varchar(16) DEFAULT NULL,
  `yes` tinyint(1) DEFAULT '0',
  `yes_des` varchar(1024) DEFAULT NULL,
  `run_time` int(11) DEFAULT '0',
  `ut_id` int(13) DEFAULT '0',
  `return_head` mediumtext,
  `create_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`),
  KEY `tree_id` (`tree_id`),
  KEY `item_id` (`item_id`),
  KEY `task_id` (`task_id`),
  KEY `template_id` (`template_id`),
  KEY `usecase_id` (`usecase_id`),
  KEY `ut_id` (`ut_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1672 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_task_log
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_ab
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_ab`;
CREATE TABLE `swx_test_ab` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `time_id` bigint(13) DEFAULT NULL,
  `usecase_id` bigint(13) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `thread_num` int(11) DEFAULT '1',
  `ramp_up` int(11) DEFAULT '0',
  `for_num` int(11) DEFAULT '0',
  `duration` int(11) DEFAULT '0',
  `go_time` int(11) DEFAULT '0',
  `start_time` int(11) DEFAULT NULL,
  `end_time` int(11) DEFAULT NULL,
  `actual_for_num` int(11) DEFAULT '0',
  `min_ms` int(11) DEFAULT '0',
  `max_ms` int(11) DEFAULT '0',
  `avg_ms` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT NULL,
  `admin_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`),
  KEY `item_id` (`item_id`),
  KEY `usecase_id` (`usecase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_ab
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_ab_log
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_ab_log`;
CREATE TABLE `swx_test_ab_log` (
  `ab_id` bigint(13) NOT NULL COMMENT '任务ID',
  `ms` int(11) DEFAULT '0',
  `yes` tinyint(1) DEFAULT '0',
  `status_code` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  KEY `ab_id` (`ab_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_ab_log
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_function
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_function`;
CREATE TABLE `swx_test_function` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `content` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_function
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_template
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_template`;
CREATE TABLE `swx_test_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL,
  `depth` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_template
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_template_tree
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_template_tree`;
CREATE TABLE `swx_test_template_tree` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `pid` bigint(13) DEFAULT NULL,
  `template_id` bigint(13) DEFAULT NULL,
  `item_id` bigint(13) DEFAULT NULL,
  `api_id` bigint(13) DEFAULT NULL,
  `usecase_id` bigint(13) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `sleep_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`),
  KEY `item_id` (`item_id`),
  KEY `template_id` (`template_id`),
  KEY `usecase_id` (`usecase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_template_tree
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_template_tree_param
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_template_tree_param`;
CREATE TABLE `swx_test_template_tree_param` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `pid` bigint(13) DEFAULT '0',
  `field_pid` varchar(255) DEFAULT NULL,
  `field` varchar(255) DEFAULT NULL,
  `tree_id` bigint(13) NOT NULL,
  `api_return_id` bigint(13) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tree_id` (`tree_id`),
  KEY `api_return_id` (`api_return_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_template_tree_param
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_usecase
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase`;
CREATE TABLE `swx_test_usecase` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `domain_id3` int(11) DEFAULT NULL COMMENT '用例跟域名',
  `group_id` int(11) DEFAULT NULL COMMENT '用例分组ID',
  `item_id` int(11) DEFAULT NULL,
  `api_id` bigint(13) DEFAULT NULL,
  `title` varchar(128) DEFAULT NULL,
  `http_code` int(11) DEFAULT '200',
  `des` text,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=453 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_usecase
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_usecase_code
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase_code`;
CREATE TABLE `swx_test_usecase_code` (
  `usecase_id` bigint(13) DEFAULT NULL,
  `code` varchar(64) DEFAULT NULL,
  `yes` tinyint(1) DEFAULT '2',
  `status` tinyint(1) DEFAULT NULL,
  KEY `usecase_id` (`usecase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_usecase_code
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_usecase_env_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase_env_request`;
CREATE TABLE `swx_test_usecase_env_request` (
  `item_id` bigint(13) NOT NULL,
  `domain_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `value` text,
  `at_value` text,
  KEY `item_id` (`item_id`) USING BTREE,
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_usecase_env_request
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_usecase_group
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase_group`;
CREATE TABLE `swx_test_usecase_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api_id` int(11) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `sort` int(1) DEFAULT '0',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=296 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_usecase_group
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_usecase_param
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase_param`;
CREATE TABLE `swx_test_usecase_param` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `usecase_id` bigint(13) NOT NULL,
  `pid` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `value` text,
  `at_value` text,
  PRIMARY KEY (`id`),
  KEY `usecase_id` (`usecase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30349 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_usecase_param
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_usecase_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase_request`;
CREATE TABLE `swx_test_usecase_request` (
  `usecase_id` bigint(13) NOT NULL,
  `field` varchar(64) DEFAULT NULL,
  `value` text,
  `at_value` text,
  KEY `usecase_id` (`usecase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_usecase_request
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_ut
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_ut`;
CREATE TABLE `swx_test_ut` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `api_id` int(11) DEFAULT NULL,
  `title` varchar(32) DEFAULT NULL,
  `start_time` int(11) DEFAULT NULL,
  `end_time` int(11) DEFAULT NULL,
  `min_ms` int(11) DEFAULT NULL,
  `max_ms` int(11) DEFAULT NULL,
  `avg_ms` int(11) DEFAULT NULL,
  `success_num` int(11) DEFAULT '0',
  `error_num` int(11) DEFAULT '0',
  `num` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_ut
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_variable
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_variable`;
CREATE TABLE `swx_test_variable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `val` text,
  `remarks` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_test_variable
-- ----------------------------

-- ----------------------------
-- Table structure for swx_trash
-- ----------------------------
DROP TABLE IF EXISTS `swx_trash`;
CREATE TABLE `swx_trash` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) DEFAULT '1' COMMENT '类型 1.接口',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `create_time` int(11) DEFAULT NULL COMMENT '删除日期',
  `json` longtext COMMENT '备份删除内容',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_trash
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api`;
CREATE TABLE `swx_version_api` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `version_id` bigint(13) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `title` varchar(128) DEFAULT NULL,
  `des` text,
  `host_url` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `domain_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `status` tinyint(3) DEFAULT NULL,
  `display` tinyint(1) DEFAULT '1',
  `request_type` tinyint(1) DEFAULT NULL,
  `param_type` tinyint(1) DEFAULT NULL,
  `duty_name` varchar(64) DEFAULT NULL,
  `content2` text,
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  `is_imitate_api` tinyint(1) DEFAULT '2',
  `imitate_route` varchar(255) DEFAULT NULL,
  `imitate_code` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=704 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api_body
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api_body`;
CREATE TABLE `swx_version_api_body` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `version_id` bigint(13) DEFAULT NULL,
  `pid` bigint(13) DEFAULT '0',
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `size` varchar(32) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `default` varchar(64) DEFAULT NULL,
  `level` tinyint(3) DEFAULT '0' COMMENT '递归层次',
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13699 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api_body
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api_error
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api_error`;
CREATE TABLE `swx_version_api_error` (
  `version_id` bigint(13) NOT NULL,
  `api_id` bigint(13) NOT NULL,
  `scene` varchar(255) DEFAULT NULL,
  `des` varchar(1024) DEFAULT NULL,
  `json` mediumtext,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api_error
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api_group
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api_group`;
CREATE TABLE `swx_version_api_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version_id` bigint(13) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL,
  `sort` int(1) DEFAULT '0',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api_group
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api_request`;
CREATE TABLE `swx_version_api_request` (
  `version_id` bigint(13) NOT NULL,
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api_request
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api_return
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api_return`;
CREATE TABLE `swx_version_api_return` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `version_id` bigint(13) DEFAULT NULL,
  `pid` bigint(13) DEFAULT '0',
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `size` varchar(32) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `default` varchar(64) DEFAULT NULL COMMENT '默认值',
  `level` tinyint(3) DEFAULT '0' COMMENT '递归层次',
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17560 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api_return
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api_return_code
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api_return_code`;
CREATE TABLE `swx_version_api_return_code` (
  `version_id` bigint(13) NOT NULL,
  `api_id` bigint(13) DEFAULT NULL,
  `code` varchar(64) DEFAULT NULL,
  `msg` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `is_success` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api_return_code
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api_return_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api_return_request`;
CREATE TABLE `swx_version_api_return_request` (
  `version_id` bigint(13) NOT NULL,
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api_return_request
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_api_success
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_api_success`;
CREATE TABLE `swx_version_api_success` (
  `version_id` bigint(13) NOT NULL,
  `api_id` bigint(13) NOT NULL,
  `scene` varchar(255) DEFAULT NULL,
  `des` varchar(1024) DEFAULT NULL,
  `json` mediumtext,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_api_success
-- ----------------------------

-- ----------------------------
-- Table structure for swx_version_log
-- ----------------------------
DROP TABLE IF EXISTS `swx_version_log`;
CREATE TABLE `swx_version_log` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `item_id` bigint(13) DEFAULT NULL COMMENT '项目ID',
  `code` varchar(32) DEFAULT NULL COMMENT '版本号',
  `admin_name` varchar(64) DEFAULT NULL COMMENT '发布人',
  `create_time` int(11) DEFAULT NULL COMMENT '发布时间',
  `content` longtext COMMENT '版本内容',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_version_log
-- ----------------------------

-- ----------------------------
-- Table structure for swx_word
-- ----------------------------
DROP TABLE IF EXISTS `swx_word`;
CREATE TABLE `swx_word` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL,
  `route` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `sort` int(11) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `is_login` tinyint(1) DEFAULT '1',
  `user_id` text,
  PRIMARY KEY (`id`),
  KEY `route` (`route`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of swx_word
-- ----------------------------

-- ----------------------------
-- Table structure for swx_word_tree
-- ----------------------------
DROP TABLE IF EXISTS `swx_word_tree`;
CREATE TABLE `swx_word_tree` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT '0',
  `word_id` int(11) DEFAULT NULL,
  `route` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `status` tinyint(11) DEFAULT '1',
  `content` mediumtext,
  `admin_id` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '1',
  `top` tinyint(1) DEFAULT '0',
  `editor_type` tinyint(1) DEFAULT '1',
  `path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `route` (`route`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=329 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of swx_word_tree
-- ----------------------------

-- ----------------------------
-- Table structure for swx_word_user
-- ----------------------------
DROP TABLE IF EXISTS `swx_word_user`;
CREATE TABLE `swx_word_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `phone` varchar(16) DEFAULT NULL,
  `fullname` varchar(32) DEFAULT NULL,
  `remark` text,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of swx_word_user
-- ----------------------------
