/*
Navicat MySQL Data Transfer

Source Server         : 跑腿云
Source Server Version : 50729
Source Host           : localhost:3306
Source Database       : api_test

Target Server Type    : MYSQL
Target Server Version : 50729
File Encoding         : 65001

Date: 2021-06-27 11:21:31
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for swx_admin
-- ----------------------------
DROP TABLE IF EXISTS `swx_admin`;
CREATE TABLE `swx_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) DEFAULT NULL,
  `pwd` varchar(32) DEFAULT NULL,
  `nick` varchar(64) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='账号表';

-- ----------------------------
-- Records of swx_admin
-- ----------------------------
INSERT INTO `swx_admin` VALUES ('1', 'admin', '129c2ae688917957c363c5f2fbee4232', '超级管理员', '1602576652');

-- ----------------------------
-- Table structure for swx_api
-- ----------------------------
DROP TABLE IF EXISTS `swx_api`;
CREATE TABLE `swx_api` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL COMMENT '项目ID',
  `group_id` int(11) DEFAULT NULL COMMENT '分组ID',
  `title` varchar(128) DEFAULT NULL COMMENT '接口名称',
  `host_url` varchar(255) DEFAULT NULL COMMENT '接口地址',
  `domain_id` int(11) DEFAULT NULL COMMENT '根域名ID，可选',
  `return_id` int(11) DEFAULT NULL COMMENT '返回值结构ID，可选',
  `status` tinyint(3) DEFAULT NULL COMMENT '接口状态',
  `display` tinyint(1) DEFAULT '1' COMMENT '前端状态 1.显示  2.隐藏',
  `request_type` tinyint(1) DEFAULT NULL COMMENT '请求类型',
  `param_type` tinyint(1) DEFAULT NULL COMMENT '请求体类型',
  `duty_name` varchar(64) DEFAULT NULL COMMENT '负责人名称',
  `content2` text COMMENT '附加文档说明',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8 COMMENT='API接口主表';

-- ----------------------------
-- Table structure for swx_api_body
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_body`;
CREATE TABLE `swx_api_body` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `pid` bigint(13) DEFAULT '0' COMMENT '父ID',
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `size` varchar(32) DEFAULT NULL COMMENT '数据长度',
  `no_null` tinyint(1) DEFAULT NULL,
  `default` varchar(64) DEFAULT NULL COMMENT '默认值',
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1745 DEFAULT CHARSET=utf8 COMMENT='API请求体body表';

-- ----------------------------
-- Table structure for swx_api_examples
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_examples`;
CREATE TABLE `swx_api_examples` (
  `api_id` bigint(13) NOT NULL COMMENT '接口ID',
  `success_json` mediumtext COMMENT '成功示例',
  `error_json` mediumtext COMMENT '失败示例',
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='API返回值示例JSON表';

-- ----------------------------
-- Table structure for swx_api_group
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_group`;
CREATE TABLE `swx_api_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL COMMENT '项目ID',
  `title` varchar(64) DEFAULT NULL COMMENT '分组名称',
  `des` varchar(255) DEFAULT NULL COMMENT '描述',
  `sort` int(1) DEFAULT '0',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COMMENT='API分组表';

-- ----------------------------
-- Table structure for swx_api_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_request`;
CREATE TABLE `swx_api_request` (
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='API请求头表';

-- ----------------------------
-- Table structure for swx_api_return
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_return`;
CREATE TABLE `swx_api_return` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `pid` bigint(13) DEFAULT '0' COMMENT '父ID',
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `size` varchar(32) DEFAULT NULL COMMENT '数据长度',
  `no_null` tinyint(1) DEFAULT NULL,
  `default` varchar(64) DEFAULT NULL COMMENT '默认值',
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2593 DEFAULT CHARSET=utf8 COMMENT='API返回值data内容表';

-- ----------------------------
-- Table structure for swx_api_return_code
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_return_code`;
CREATE TABLE `swx_api_return_code` (
  `api_id` bigint(13) DEFAULT NULL,
  `code` varchar(64) DEFAULT NULL,
  `msg` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `is_success` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='API返回值状态码表';

-- ----------------------------
-- Table structure for swx_api_return_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_api_return_request`;
CREATE TABLE `swx_api_return_request` (
  `api_id` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `param_type` tinyint(2) DEFAULT NULL,
  `no_null` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='API响应返回头部表';

-- ----------------------------
-- Records of swx_api_return_request
-- ----------------------------

-- ----------------------------
-- Table structure for swx_config
-- ----------------------------
DROP TABLE IF EXISTS `swx_config`;
CREATE TABLE `swx_config` (
  `id` int(11) NOT NULL,
  `email_type` varchar(32) DEFAULT '' COMMENT '邮件协议类型',
  `email_encryption_type` varchar(32) DEFAULT '' COMMENT '邮件加密类型',
  `email_ip` varchar(64) DEFAULT NULL COMMENT '邮箱服务器IP',
  `email_port` varchar(32) DEFAULT NULL COMMENT '邮箱服务器端口',
  `email_name` varchar(64) DEFAULT NULL COMMENT '邮箱服务器账号',
  `email_pwd` varchar(64) DEFAULT NULL COMMENT '邮箱服务器密码',
  `domain` varchar(255) DEFAULT NULL COMMENT '站点域名',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='配置表';

-- ----------------------------
-- Records of swx_config
-- ----------------------------
INSERT INTO `swx_config` VALUES ('1', 'SMTP', 'ssl', 'smtp.qq.com', '465', '', '', 'https://www.sw-x.cn');

-- ----------------------------
-- Table structure for swx_domain
-- ----------------------------
DROP TABLE IF EXISTS `swx_domain`;
CREATE TABLE `swx_domain` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='根域名管理';

-- ----------------------------
-- Table structure for swx_duty
-- ----------------------------
DROP TABLE IF EXISTS `swx_duty`;
CREATE TABLE `swx_duty` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `duty_name` varchar(32) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='负责人表';

-- ----------------------------
-- Records of swx_duty
-- ----------------------------
INSERT INTO `swx_duty` VALUES ('1', '官方人员', null, '1622616402');

-- ----------------------------
-- Table structure for swx_email
-- ----------------------------
DROP TABLE IF EXISTS `swx_email`;
CREATE TABLE `swx_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(32) DEFAULT NULL COMMENT '人员名称',
  `email` varchar(64) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1' COMMENT '0.禁用 1.启用',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='测试通知邮箱管理';

-- ----------------------------
-- Records of swx_email
-- ----------------------------

-- ----------------------------
-- Table structure for swx_item
-- ----------------------------
DROP TABLE IF EXISTS `swx_item`;
CREATE TABLE `swx_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL COMMENT '简介',
  `domain_id` int(11) DEFAULT NULL COMMENT '默认根域名',
  `return_id` int(11) DEFAULT NULL COMMENT '默认返回值结构',
  `pwd` varchar(64) DEFAULT NULL COMMENT '是否需要密码才能查看文档',
  `doc_id` varchar(32) DEFAULT NULL COMMENT '文档查询关键ID',
  `content` text COMMENT '接口文档说明',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='项目管理';

-- ----------------------------
-- Table structure for swx_return
-- ----------------------------
DROP TABLE IF EXISTS `swx_return`;
CREATE TABLE `swx_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL,
  `return_type` tinyint(1) DEFAULT NULL COMMENT '返回值类型',
  `status` tinyint(1) DEFAULT '1' COMMENT '0.禁用 1.启用',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='返回值结构-主表';

-- ----------------------------
-- Table structure for swx_return_field
-- ----------------------------
DROP TABLE IF EXISTS `swx_return_field`;
CREATE TABLE `swx_return_field` (
  `pid` int(11) NOT NULL,
  `title` varchar(64) DEFAULT NULL COMMENT '描述',
  `field` varchar(64) DEFAULT NULL COMMENT '字段名',
  `sort` int(11) DEFAULT NULL,
  `is_code` tinyint(1) DEFAULT '0' COMMENT '是否为状态码条件 0.否 1.是',
  `is_data` tinyint(1) DEFAULT '0' COMMENT '是否为返回值字段 0.否 1.是',
  KEY `pid` (`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='返回值结构-副表';

-- ----------------------------
-- Table structure for swx_task
-- ----------------------------
DROP TABLE IF EXISTS `swx_task`;
CREATE TABLE `swx_task` (
  `id` int(13) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) DEFAULT NULL COMMENT '测试模板ID',
  `is_timing` tinyint(1) DEFAULT '0' COMMENT '是否定时测试 0.否 1.是',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态 0.未开始 1.测试中 2.已完成',
  `start_time` int(11) DEFAULT NULL COMMENT '任务开始时间',
  `create_time` int(11) DEFAULT NULL COMMENT '添加时间',
  `task_start_time` int(11) DEFAULT NULL COMMENT '任务开始时间',
  `task_end_time` int(11) DEFAULT NULL COMMENT '任务结束时间',
  `success_num` int(11) DEFAULT '0' COMMENT '成功执行任务数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='任务 - 队列表';

-- ----------------------------
-- Records of swx_task
-- ----------------------------

-- ----------------------------
-- Table structure for swx_task_log
-- ----------------------------
DROP TABLE IF EXISTS `swx_task_log`;
CREATE TABLE `swx_task_log` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL COMMENT '任务ID',
  `template_id` int(11) DEFAULT NULL COMMENT '模板ID',
  `tree_id` bigint(13) DEFAULT NULL COMMENT '任务树ID',
  `item_id` int(11) DEFAULT NULL COMMENT '项目ID',
  `api_id` bigint(13) DEFAULT NULL COMMENT '接口ID',
  `usecase_id` bigint(13) DEFAULT NULL COMMENT '用例ID',
  `api_title` varchar(128) DEFAULT NULL COMMENT '接口名称',
  `api_url` varchar(255) DEFAULT NULL COMMENT '接口地址',
  `request_type` tinyint(1) DEFAULT NULL COMMENT '请求类型',
  `param_type` tinyint(1) DEFAULT NULL COMMENT '请求参数类型',
  `request_json` mediumtext COMMENT '请求头',
  `body_json` mediumtext COMMENT '请求参数',
  `return_json` mediumtext COMMENT '返回值',
  `status_code` varchar(16) DEFAULT NULL COMMENT 'HTTP状态码',
  `err_code` varchar(16) DEFAULT NULL COMMENT 'Swoole的状态码',
  `create_time` int(11) DEFAULT NULL COMMENT '测试时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=321 DEFAULT CHARSET=utf8 COMMENT='任务 - 报告表';

-- ----------------------------
-- Table structure for swx_test_template
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_template`;
CREATE TABLE `swx_test_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) DEFAULT NULL COMMENT '模板名称',
  `des` varchar(255) DEFAULT NULL,
  `depth` int(11) DEFAULT '0' COMMENT '任务树的深度，树深长度',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='测试 - 任务模板';

-- ----------------------------
-- Records of swx_test_template
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_template_tree
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_template_tree`;
CREATE TABLE `swx_test_template_tree` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `pid` bigint(13) DEFAULT NULL,
  `template_id` bigint(13) DEFAULT NULL COMMENT '模板ID',
  `item_id` bigint(13) DEFAULT NULL,
  `api_id` bigint(13) DEFAULT NULL,
  `usecase_id` bigint(13) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL COMMENT '状态码触发值',
  `sleep_time` int(11) DEFAULT '0' COMMENT '休眠多少秒才继续下一个任务',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COMMENT='测试 - 任务模板用例树';

-- ----------------------------
-- Table structure for swx_test_template_tree_param
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_template_tree_param`;
CREATE TABLE `swx_test_template_tree_param` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `pid` bigint(13) DEFAULT '0',
  `field_pid` varchar(255) DEFAULT NULL,
  `field` varchar(255) DEFAULT NULL,
  `tree_id` bigint(13) NOT NULL,
  `api_return_id` bigint(13) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tree_id` (`tree_id`),
  KEY `api_return_id` (`api_return_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='测试 - 用例任务树的扩展请求参数衔接';

-- ----------------------------
-- Records of swx_test_template_tree_param
-- ----------------------------

-- ----------------------------
-- Table structure for swx_test_usecase
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase`;
CREATE TABLE `swx_test_usecase` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL COMMENT '项目ID',
  `api_id` bigint(13) DEFAULT NULL COMMENT '接口ID',
  `title` varchar(128) DEFAULT NULL COMMENT '用例名称',
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8 COMMENT='测试 - 用例表';

-- ----------------------------
-- Table structure for swx_test_usecase_code
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase_code`;
CREATE TABLE `swx_test_usecase_code` (
  `usecase_id` bigint(13) DEFAULT NULL,
  `code` varchar(64) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL COMMENT '2.中断测试 1.往下测试',
  KEY `usecase_id` (`usecase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='测试 - 用例状态码控制表';

-- ----------------------------
-- Table structure for swx_test_usecase_param
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase_param`;
CREATE TABLE `swx_test_usecase_param` (
  `id` bigint(13) NOT NULL AUTO_INCREMENT,
  `usecase_id` bigint(13) NOT NULL,
  `pid` bigint(13) DEFAULT NULL,
  `field` varchar(64) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usecase_id` (`usecase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=765 DEFAULT CHARSET=utf8 COMMENT='测试 - 用例请求Body配置表';

-- ----------------------------
-- Table structure for swx_test_usecase_request
-- ----------------------------
DROP TABLE IF EXISTS `swx_test_usecase_request`;
CREATE TABLE `swx_test_usecase_request` (
  `usecase_id` bigint(13) NOT NULL,
  `field` varchar(64) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  KEY `usecase_id` (`usecase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='测试 - 用例请求头配置表';
