<?php
// +----------------------------------------------------------------------
// | 添加API
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Api;
use app\controller\SuperClass\Admin;

class create extends Admin
{
    /**
     * @RequestMapping(route="/api/create", method="GET", title="添加API")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $this->assign('param', $param);

        $group = $this->Db->name('api_group')->where('item_id', $param['item_id'])->order('sort DESC, id DESC')->select();
        $this->assign('group', $group);

        $duty = $this->Db->name('duty')->order('id DESC')->select();
        $this->assign('duty', $duty);

        $domain = $this->Db->name('domain')->order('id ASC')->select();
        $this->assign('domain', $domain);

        $return = $this->Db->name('return')->where('status', 1)->order('id ASC')->select();
        $this->assign('return', $return);

        $this->assign('status_list', status_list());
        $this->assign('request_list', request_list());
        $this->assign('param_list', param_list());
        $this->assign('type_list', type_list());

        // 预选项读取 - 请求头 - 返回头 - 状态码
        // 请求头：先抓一个同类API，有参数的
        $request = [];
        $api = $this->Db->name('api')->alias('A')->join('api_request B', 'A.id = B.api_id', 'inner')->field('A.id')->order('A.id ASC')->where('A.item_id', $param['item_id'])->find();
        if ($api) {
            $request = $this->Db->name('api_request')->where('api_id', $api['id'])->order('sort ASC')->select();
        }
        $this->assign('request', $request);

        // 返回头：先抓一个同类API，有参数的
        $return_request = [];
        $api = $this->Db->name('api')->alias('A')->join('api_return_request B', 'A.id = B.api_id', 'inner')->field('A.id')->order('A.id ASC')->where('A.item_id', $param['item_id'])->find();
        if ($api) {
            $return_request = $this->Db->name('api_return_request')->where('api_id', $api['id'])->order('sort ASC')->select();
        }
        $this->assign('return_request', $return_request);

        // 状态码：先抓一个同类API，有参数的
        $return_code = [];
        $api = $this->Db->name('api')->alias('A')->join('api_return_code B', 'A.id = B.api_id', 'inner')->field('A.id')->order('A.id ASC')->where('A.item_id', $param['item_id'])->find();
        if ($api) {
            $return_code = $this->Db->name('api_return_code')->where('api_id', $api['id'])->order('sort ASC')->select();
        }
        $this->assign('return_code', $return_code);

        $this->Db->return();
        return $this->display('api/create');
    }

    /**
     * @RequestMapping(route="/api/create_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入接口描述")
     * @Param(name="group_id", empty="true", tips="请选择API所属分组")
     * @Param(name="host_url", empty="true", tips="请输入接口地址")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        if (!empty($param['request'])) {
            foreach ($param['request'] as $v) {
                if (empty($v['field'])) {
                    $this->Db->return();
                    return $this->returnJson('01', '请求头字段名不能为空');
                }
            }
        }
        if (!empty($param['code'])) {
            foreach ($param['code'] as $v) {
                if (str_replace(' ', '', $v['code']) === '') {
                    $this->Db->return();
                    return $this->returnJson('01', '返回值Code字段不能为空');
                }
            }
        }
        if (!empty($param['return_request'])) {
            foreach ($param['return_request'] as $v) {
                if (empty($v['field'])) {
                    $this->Db->return();
                    return $this->returnJson('01', '返回头部字段名不能为空');
                }
            }
        }
        if (!empty($param['return'])) {
            foreach ($param['return'] as $v) {
                if (empty($v['field'])) {
                    $this->Db->return();
                    return $this->returnJson('01', '返回值字段名不能为空');
                }
                foreach ($v as $val) {
                    if (is_array($val) && empty($val['field'])) {
                        $this->Db->return();
                        return $this->returnJson('01', '返回值二级字段名不能为空');
                    }
                }
            }
        }
        if (!empty($param['param'])) {
            foreach ($param['param'] as $v) {
                if (empty($v['field'])) {
                    $this->Db->return();
                    return $this->returnJson('01', '请求体字段名不能为空');
                }
                foreach ($v as $val) {
                    if (is_array($val) && empty($val['field'])) {
                        $this->Db->return();
                        return $this->returnJson('01', '请求体二级字段名不能为空');
                    }
                }
            }
        }
        
        $data = [];
        $data['create_time'] = time();
        $data['status'] = $param['status'];
        $data['display'] = $param['display'];
        $data['title'] = $param['title'];
        $data['item_id'] = $param['item_id'];
        $data['group_id'] = $param['group_id'];
        $data['duty_name'] = $param['duty_name'];
        $data['domain_id'] = $param['domain_id'];
        $data['return_id'] = $param['return_id'];
        $data['request_type'] = $param['request_type'];
        $data['host_url'] = $param['host_url'];
        $data['param_type'] = $param['param_type'];
        $data['content2'] = $param['content2'];
        $pid = $this->Db->name('api')->insertGetId($data);
        if ($pid) {
            // 添加示例JSON
            $this->Db->name('api_examples')->insert([
                'api_id' => $pid,
                'success_json' => $param['success_json'],
                'error_json' => $param['error_json'],
            ]);
            // 添加请求头部
            if (!empty($param['request'])) {
                foreach ($param['request'] as $k=>$v) {
                    $v['api_id'] = $pid;
                    $v['sort'] = $k;
                    $v['param_type'] = $v['type'];
                    unset($v['type']);
                    $this->Db->name('api_request')->insert($v);
                }
            }
            // 添加返回值状态码
            if (!empty($param['code'])) {
                foreach ($param['code'] as $k=>$v) {
                    $v['api_id'] = $pid;
                    $v['sort'] = $k;
                    $v['param_type'] = $v['type'];
                    $v['code'] = (string)$v['code'];
                    unset($v['type']);
                    $this->Db->name('api_return_code')->insert($v);
                }
            }
            // 添加返回头部
            if (!empty($param['return_request'])) {
                foreach ($param['return_request'] as $k=>$v) {
                    $v['api_id'] = $pid;
                    $v['sort'] = $k;
                    $v['param_type'] = $v['type'];
                    unset($v['type']);
                    $this->Db->name('api_return_request')->insert($v);
                }
            }
            // 添加返回体结构
            if (!empty($param['return'])) {
                foreach ($param['return'] as $v) {
                    $data = [
                        'pid' => 0,
                        'api_id' => $pid,
                        'field' => $v['field'],
                        'title' => $v['title'],
                        'param_type' => $v['type'],
                        'no_null' => $v['no_null'],
                        'default' => $v['default'],
                        'size' => $v['size']??'',
                    ];
                    $cid = $this->Db->name('api_return')->insertGetId($data);
                    if ($cid) {
                        foreach ($v as $val) {
                            if (is_array($val)) {
                                $data = [
                                    'pid' => $cid,
                                    'api_id' => $pid,
                                    'field' => $val['field'],
                                    'title' => $val['title'],
                                    'param_type' => $val['type'],
                                    'no_null' => $val['no_null'],
                                    'default' => $val['default'],
                                    'size' => $val['size']??'',
                                ];
                                $this->Db->name('api_return')->insert($data);
                            }
                        }
                    }
                }
            }
            // 添加请求体
            if (!empty($param['param'])) {
                foreach ($param['param'] as $v) {
                    $data = [
                        'pid' => 0,
                        'api_id' => $pid,
                        'field' => $v['field'],
                        'title' => $v['title'],
                        'param_type' => $v['type'],
                        'no_null' => $v['no_null'],
                        'default' => $v['default'],
                        'size' => $v['size']??'',
                    ];
                    $cid = $this->Db->name('api_body')->insertGetId($data);
                    if ($cid) {
                        foreach ($v as $val) {
                            if (is_array($val)) {
                                $data = [
                                    'pid' => $cid,
                                    'api_id' => $pid,
                                    'field' => $val['field'],
                                    'title' => $val['title'],
                                    'param_type' => $val['type'],
                                    'no_null' => $val['no_null'],
                                    'default' => $val['default'],
                                    'size' => $val['size']??'',
                                ];
                                $this->Db->name('api_body')->insert($data);
                            }
                        }
                    }
                }
            }

            $this->Db->return();
            return $this->returnJson('00', '添加成功');
        }
        $this->Db->return();
        return $this->returnJson('01', '添加失败');
    }
}



