<?php
// +----------------------------------------------------------------------
// | API列表
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Api;
use app\controller\SuperClass\Admin;

class index extends Admin
{
    /**
     * @RequestMapping(route="/api/index", method="GET", title="API列表")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $this->assign('param', $param);

        $group = $this->Db->name('api_group')->where('item_id', $param['id'])->order('id DESC')->select();
        $this->assign('group', $group);

        $this->Db->return();
        return $this->display('api/index');
    }

    /**
     * @RequestMapping(route="/api/index_ajax", method="GET", title="拉取数据")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::get();
        $where = [];
        $where[] = ['A.item_id', '=', $param['item_id']];
        if ($param['group_id']) $where[] = ['A.group_id', '=', $param['group_id']];

        $total = $this->Db->name('api')->alias('A')
                 ->join('api_group B', 'A.group_id=B.id')
                 ->join('item C', 'A.item_id=C.id')
                 ->where($where)
                 ->count();
        $list = $this->Db->name('api')->alias('A')
                ->join('api_group B', 'A.group_id=B.id')
                ->join('item C', 'A.item_id=C.id')
                ->order('A.id ASC')
                ->where($where)
                ->field('A.*, B.title as group_title, C.domain_id as domain_id2, C.return_id as return_id2')
                ->select();

        foreach ($list as $k=>$v) {
            $list[$k]['create_time'] = date('Y-m-d H:i:s', $v['create_time']);
            $list[$k]['update_time'] = $v['update_time'] ? date('Y-m-d H:i:s', $v['update_time']) : '无';
            $list[$k]['status_name'] = status_list($v['status']);
            $list[$k]['request_type'] = request_list($v['request_type']);
            $list[$k]['param_type'] = param_list($v['param_type']);
            
            // 根域名
            if ($v['domain_id']) {
                $res = $this->Db->name('domain')->where('id', $v['domain_id'])->find();
            } else {
                $res = $this->Db->name('domain')->where('id', $v['domain_id2'])->find();
            }
            $list[$k]['domain_name'] = $res['title'];
            $list[$k]['domain'] = $res['domain'];
            // 返回值结构
            if ($v['return_id']) {
                $res = $this->Db->name('return')->where('id', $v['return_id'])->find();
            } else {
                $res = $this->Db->name('return')->where('id', $v['return_id2'])->find();
            }
            $list[$k]['return_title'] = $res['title'];
            $list[$k]['return_type'] = param_list($res['return_type']);
            // 参数检测
            $num = $this->Db->name('api_request')->where('api_id', $v['id'])->count();
            if ($num > 0) {
                $list[$k]['num1'] = '已补充';
            } else {
                $list[$k]['num1'] = 'no~';
            }
            $num = $this->Db->name('api_return')->where('api_id', $v['id'])->count();
            if ($num > 0) {
                $list[$k]['num2'] = '已补充';
            } else {
                $list[$k]['num2'] = 'no~';
            }
            $num = $this->Db->name('api_return_code')->where('api_id', $v['id'])->count();
            if ($num > 0) {
                $list[$k]['num3'] = '已补充';
            } else {
                $list[$k]['num3'] = 'no~';
            }
            if ($v['display'] ==1) {
                $list[$k]['display'] = '显示';
            } else {
                $list[$k]['display'] = '隐藏';
            }
        }
        
        $this->Db->return();
        return $this->returnTable($list, $total);
    }
}