<?php
// +----------------------------------------------------------------------
// | 修改API
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Api;
use app\controller\SuperClass\Admin;

class update extends Admin
{
    /**
     * @RequestMapping(route="/api/update", method="GET", title="修改API")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $this->assign('param', $param);

        $duty = $this->Db->name('duty')->order('id DESC')->select();
        $this->assign('duty', $duty);

        $domain = $this->Db->name('domain')->order('id ASC')->select();
        $this->assign('domain', $domain);

        $return = $this->Db->name('return')->where('status', 1)->order('id ASC')->select();
        $this->assign('return2', $return);

        $this->assign('status_list', status_list());
        $this->assign('request_list', request_list());
        $this->assign('param_list', param_list());
        $this->assign('type_list', type_list());

        // 参数查询
        $info = $this->Db->name('api')->where('id', $param['id'])->find();
        $this->assign('info', $info);
        $examples = $this->Db->name('api_examples')->where('api_id', $param['id'])->find();
        $this->assign('examples', $examples);
        $group = $this->Db->name('api_group')->where('item_id', $info['item_id'])->order('sort DESC, id DESC')->select();
        $this->assign('group', $group);

        $request = $this->Db->name('api_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        $this->assign('request', $request);
        $return_request = $this->Db->name('api_return_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        $this->assign('return_request', $return_request);
        $return_code = $this->Db->name('api_return_code')->where('api_id', $param['id'])->order('sort ASC')->select();
        $this->assign('return_code', $return_code);

        // 带二级参数的
        $body = [];
        $list = $this->Db->name('api_body')->where('api_id', $param['id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $body[$k] = $v;
            $lt = $this->Db->name('api_body')->where('pid', $v['id'])->order('id ASC')->select();
            $body[$k]['list'] = $lt ?? [];
        }
        $this->assign('body', $body);
        $return = [];
        $list = $this->Db->name('api_return')->where('api_id', $param['id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $return[$k] = $v;
            $lt = $this->Db->name('api_return')->where('pid', $v['id'])->order('id ASC')->select();
            $return[$k]['list'] = $lt ?? [];
        }
        $this->assign('return', $return);

        $this->Db->return();
        return $this->display('api/update');
    }

    /**
     * @RequestMapping(route="/api/update_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入接口描述")
     * @Param(name="group_id", empty="true", tips="请选择API所属分组")
     * @Param(name="host_url", empty="true", tips="请输入接口地址")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        if (!empty($param['request'])) {
            foreach ($param['request'] as $v) {
                if (empty($v['field'])) {
                    $this->Db->return();
                    return $this->returnJson('01', '请求头字段名不能为空');
                }
            }
        }
        if (!empty($param['code'])) {
            foreach ($param['code'] as $v) {
                if (str_replace(' ', '', $v['code']) === '') {
                    $this->Db->return();
                    return $this->returnJson('01', '返回值Code字段不能为空');
                }
            }
        }
        if (!empty($param['return_request'])) {
            foreach ($param['return_request'] as $v) {
                if (empty($v['field'])) {
                    $this->Db->return();
                    return $this->returnJson('01', '返回头部字段名不能为空');
                }
            }
        }
        if (!empty($param['return'])) {
            foreach ($param['return'] as $v) {
                if (empty($v['field'])) {
                    $this->Db->return();
                    return $this->returnJson('01', '返回值字段名不能为空');
                }
                foreach ($v as $val) {
                    if (is_array($val) && empty($val['field'])) {
                        $this->Db->return();
                        return $this->returnJson('01', '返回值二级字段名不能为空');
                    }
                }
            }
        }
        if (!empty($param['param'])) {
            foreach ($param['param'] as $v) {
                if (empty($v['field'])) {
                    $this->Db->return();
                    return $this->returnJson('01', '请求体字段名不能为空');
                }
                foreach ($v as $val) {
                    if (is_array($val) && empty($val['field'])) {
                        $this->Db->return();
                        return $this->returnJson('01', '请求体二级字段名不能为空');
                    }
                }
            }
        }
        
        $data = [];
        $data['update_time'] = time();
        $data['status'] = $param['status'];
        $data['display'] = $param['display'];
        $data['title'] = $param['title'];
        $data['group_id'] = $param['group_id'];
        $data['duty_name'] = $param['duty_name'];
        $data['domain_id'] = $param['domain_id'];
        $data['return_id'] = $param['return_id'];
        $data['request_type'] = $param['request_type'];
        $data['host_url'] = $param['host_url'];
        $data['param_type'] = $param['param_type'];
        $data['content2'] = $param['content2'];
        $res = $this->Db->name('api')->where('id', $param['id'])->update($data);
        if ($res) {
            $pid = $param['id'];
            // 修改示例JSON
            $this->Db->name('api_examples')->where('api_id', $pid)->update([
                'success_json' => $param['success_json'],
                'error_json' => $param['error_json'],
            ]);
            // 删除所有附表
            $this->Db->name('api_request')->where('api_id', $pid)->delete();
            $this->Db->name('api_return_code')->where('api_id', $pid)->delete();
            $this->Db->name('api_return_request')->where('api_id', $pid)->delete();
            $this->Db->name('api_return')->where('api_id', $pid)->delete();
            $this->Db->name('api_body')->where('api_id', $pid)->delete();

            // 添加请求头部
            if (!empty($param['request'])) {
                foreach ($param['request'] as $k=>$v) {
                    $v['api_id'] = $pid;
                    $v['sort'] = $k;
                    $v['param_type'] = $v['type'];
                    unset($v['type']);
                    $this->Db->name('api_request')->insert($v);
                }
            }
            // 添加返回值状态码
            if (!empty($param['code'])) {
                foreach ($param['code'] as $k=>$v) {
                    $v['api_id'] = $pid;
                    $v['sort'] = $k;
                    $v['param_type'] = $v['type'];
                    $v['code'] = (string)$v['code'];
                    unset($v['type']);
                    $this->Db->name('api_return_code')->insert($v);
                }
            }
            // 添加返回头部
            if (!empty($param['return_request'])) {
                foreach ($param['return_request'] as $k=>$v) {
                    $v['api_id'] = $pid;
                    $v['sort'] = $k;
                    $v['param_type'] = $v['type'];
                    unset($v['type']);
                    $this->Db->name('api_return_request')->insert($v);
                }
            }
            // 添加返回体结构
            if (!empty($param['return'])) {
                foreach ($param['return'] as $v) {
                    $data = [
                        'pid' => 0,
                        'api_id' => $pid,
                        'field' => $v['field'],
                        'title' => $v['title'],
                        'param_type' => $v['type'],
                        'no_null' => $v['no_null'],
                        'default' => $v['default'],
                        'size' => $v['size']??'',
                    ];
                    $cid = $this->Db->name('api_return')->insertGetId($data);
                    if ($cid) {
                        foreach ($v as $val) {
                            if (is_array($val)) {
                                $data = [
                                    'pid' => $cid,
                                    'api_id' => $pid,
                                    'field' => $val['field'],
                                    'title' => $val['title'],
                                    'param_type' => $val['type'],
                                    'no_null' => $val['no_null'],
                                    'default' => $val['default'],
                                    'size' => $val['size']??'',
                                ];
                                $this->Db->name('api_return')->insert($data);
                            }
                        }
                    }
                }
            }
            // 添加请求体
            if (!empty($param['param'])) {
                foreach ($param['param'] as $v) {
                    $data = [
                        'pid' => 0,
                        'api_id' => $pid,
                        'field' => $v['field'],
                        'title' => $v['title'],
                        'param_type' => $v['type'],
                        'no_null' => $v['no_null'],
                        'default' => $v['default'],
                        'size' => $v['size']??'',
                    ];
                    $cid = $this->Db->name('api_body')->insertGetId($data);
                    if ($cid) {
                        foreach ($v as $val) {
                            if (is_array($val)) {
                                $data = [
                                    'pid' => $cid,
                                    'api_id' => $pid,
                                    'field' => $val['field'],
                                    'title' => $val['title'],
                                    'param_type' => $val['type'],
                                    'no_null' => $val['no_null'],
                                    'default' => $val['default'],
                                    'size' => $val['size']??'',
                                ];
                                $this->Db->name('api_body')->insert($data);
                            }
                        }
                    }
                }
            }

            $this->Db->return();
            return $this->returnJson('00', '修改成功');
        }
        $this->Db->return();
        return $this->returnJson('01', '修改失败');
    }
}



