<?php
// +----------------------------------------------------------------------
// | 公共接口
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller;
use app\controller\SuperClass\Admin;

/**
 * @Controller(prefix="common")
*/
class Common extends Admin
{
    /**
     * @RequestMapping(route="/get_item", method="GET", title="获取项目列表")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function get_item() {
        $list = $this->Db->name('item')->order('id ASC')->select();
        $this->Db->return();
        return $this->returnJson('00', '获取成功', $list);
    }

    /**
     * @RequestMapping(route="/get_api", method="GET", title="获取API列表")
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function get_api() {
        $param = \x\Request::get();
        $list = $this->Db->name('api')->where('item_id', $param['id'])->order('id ASC')->select();
        $this->Db->return();
        return $this->returnJson('00', '获取成功', $list);
    }

    /**
     * @RequestMapping(route="/get_usecase", method="GET", title="获取测试用例列表")
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function get_usecase() {
        $param = \x\Request::get();
        $list = $this->Db->name('test_usecase')->where('api_id', $param['id'])->order('id ASC')->field('id, title')->select();
        $this->Db->return();
        return $this->returnJson('00', '获取成功', $list);
    }

    
    /**
     * @RequestMapping(route="/update_img", method="POST", title="编辑器的图片上传")
    */
    public function update_img() {
        $file = $this->file('file');
        $info = $file->validate(['size'=>1024*1024*10,'ext'=>'jpg,jpeg,png,gif'])->move(ROOT_PATH.'/public/uploads');
        if ($info) {
            // 成功上传后 获取上传信息
            return $this->fetch(json_encode([
                'location' => $info->getSaveName()
            ], JSON_UNESCAPED_UNICODE));
        }
        // 上传失败获取错误信息
        return $this->fetch($file->getError());
    }

}



