<?php
// +----------------------------------------------------------------------
// | STMP邮箱配置设定
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller;
use app\controller\SuperClass\Admin;

class Config extends Admin
{
    /**
     * @RequestMapping(route="/config/index", method="GET", title="STMP邮箱配置设定")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function edit() {
        $config = $this->Db->name('config')->where('id', 1)->find();
        $this->assign('info', $config);

        $this->Db->return();
        return $this->display('config/index');
    }

    /**
     * @RequestMapping(route="/config/update_ajax", method="POST", title="编辑资料-处理")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function update_ajax() {
        $param = \x\Request::post();
        
        $res = $this->Db->name('config')->where('id', 1)->update($param);
        $this->Db->return();
        if ($res !== false) {
            return $this->returnJson('00', '修改成功');
        }	
        return $this->returnJson('01', '修改失败');
    }
}



