<?php
// +----------------------------------------------------------------------
// | 添加根域名
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Domain;
use app\controller\SuperClass\Admin;

class create extends Admin
{
    /**
     * @RequestMapping(route="/domain/create", method="GET", title="添加根域名")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        return $this->display('domain/create');
    }

    /**
     * @RequestMapping(route="/domain/create_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入名称")
     * @Param(name="domain", empty="true", tips="请输入域名")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $param['create_time'] = time();
        $param['title'] = $param['title'];
        $param['domain'] = $param['domain'];

        $res = $this->Db->name('domain')->insert($param);
        $this->Db->return();
        if ($res) {
            return $this->returnJson('00', '添加成功');
        }	
        return $this->returnJson('01', '添加失败');
    }
}



