<?php
// +----------------------------------------------------------------------
// | 编辑根域名
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Domain;
use app\controller\SuperClass\Admin;

class update extends Admin
{
    /**
     * @RequestMapping(route="/domain/update", method="GET", title="编辑根域名")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $info = $this->Db->name('domain')->where('id', $param['id'])->find();
        $this->Db->return();

        $this->assign('info', $info);	
        return $this->display('domain/update');
    }

    /**
     * @RequestMapping(route="/domain/update_ajax", method="post", title="提交数据")
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入名称")
     * @Param(name="domain", empty="true", tips="请输入域名")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $param['update_time'] = time();
        $param['title'] = $param['title'];
        $param['domain'] = $param['domain'];

        $res = $this->Db->name('domain')->where('id', $param['id'])->update($param);
        $this->Db->return();
        if ($res) {
            return $this->returnJson('00', '修改成功');
        }	
        return $this->returnJson('01', '修改失败');
    }
}



