<?php
// +----------------------------------------------------------------------
// | 添加项目
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Item;
use app\controller\SuperClass\Admin;

class create extends Admin
{
    /**
     * @RequestMapping(route="/item/create", method="GET", title="添加项目")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $domain = $this->Db->name('domain')->order('id ASC')->select();
        $this->assign('domain', $domain);
        $return = $this->Db->name('return')->where('status', 1)->order('id ASC')->select();
        $this->assign('return', $return);

        $this->Db->return();
        return $this->display('item/create');
    }

    /**
     * @RequestMapping(route="/item/create_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入项目名称")
     * @Param(name="domain_id", empty="true", tips="请选择默认根域名")
     * @Param(name="return_id", empty="true", tips="请选择默认返回值结构")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $param['create_time'] = time();
        $param['title'] = $param['title'];
        $param['des'] = $param['des'];
        $param['domain_id'] = $param['domain_id'];
        $param['return_id'] = $param['return_id'];
        $param['pwd'] = $param['pwd'];
        $param['content'] = $param['content'];
        $param['doc_id'] = md5($param['create_time'].$param['title']);

        $item_id = $this->Db->name('item')->insertGetId($param);
        if ($item_id) {
            // 自动创建一个默认分组
            $this->Db->name('api_group')->insert([
                'item_id' => $item_id,
                'title' => '默认分组',
                'des' => '由系统自动创建',
                'create_time' => time(),
            ]);
            $this->Db->return();
            return $this->returnJson('00', '添加成功');
        }	
        $this->Db->return();
        return $this->returnJson('01', '添加失败');
    }
}



