<?php
// +----------------------------------------------------------------------
// | 添加API分组
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Item;
use app\controller\SuperClass\Admin;

class group_create extends Admin
{
    /**
     * @RequestMapping(route="/item/group_create", method="GET", title="添加API分组")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        $param = \x\Request::get();
        $this->assign('param', $param);
        return $this->display('item/group_create');
    }

    /**
     * @RequestMapping(route="/item/group_create_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入API分组名称")
     * @Param(name="item_id", empty="true", tips="缺少项目ID")
     * @Param(name="sort", value="0")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $param['create_time'] = time();
        $param['title'] = $param['title'];
        $param['des'] = $param['des'];
        $param['item_id'] = $param['item_id'];
        $param['sort'] = $param['sort'];

        $res = $this->Db->name('api_group')->insert($param);
        $this->Db->return();
        if ($res) {
            return $this->returnJson('00', '添加成功');
        }	
        return $this->returnJson('01', '添加失败');
    }
}



