<?php
// +----------------------------------------------------------------------
// | 编辑API分组
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Item;
use app\controller\SuperClass\Admin;

class group_update extends Admin
{
    /**
     * @RequestMapping(route="/item/group_update", method="GET", title="编辑API分组")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $info = $this->Db->name('api_group')->where('id', $param['id'])->find();
        $this->assign('info', $info);	

        $this->Db->return();
        return $this->display('item/group_update');
    }

    /**
     * @RequestMapping(route="/item/group_update_ajax", method="post", title="提交数据")
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入API分组名称")
     * @Param(name="sort", value="0")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $param['update_time'] = time();
        $param['title'] = $param['title'];
        $param['des'] = $param['des'];
        $param['sort'] = $param['sort'];

        $res = $this->Db->name('api_group')->where('id', $param['id'])->update($param);
        $this->Db->return();
        if ($res) {
            return $this->returnJson('00', '修改成功');
        }	
        return $this->returnJson('01', '修改失败');
    }
}



