<?php
// +----------------------------------------------------------------------
// | 项目列表
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Item;
use app\controller\SuperClass\Admin;

class index extends Admin
{
    /**
     * @RequestMapping(route="/item/index", method="GET", title="项目列表")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        return $this->display('item/index');
    }

    /**
     * @RequestMapping(route="/item/index_ajax", method="GET", title="拉取数据")
     * @Param(name="page", value="1", tips="分页")
     * @Param(name="limit", value="10", tips="条数")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::get();

        $total = $this->Db->name('item')->count();
        $list = $this->Db->name('item')->alias('A')
                ->join('domain B', 'A.domain_id=B.id')
                ->join('return C', 'A.return_id=C.id')
                ->order('A.id DESC')
                ->page($param['page'], $param['limit'])
                ->field('A.id, A.title, A.domain_id, A.return_id, A.pwd, A.create_time, A.update_time, A.doc_id, B.title as domain_name, B.domain, C.title as ret')
                ->select();

        foreach ($list as $k=>$v) {
            $list[$k]['create_time'] = date('Y-m-d H:i:s', $v['create_time']);
            $list[$k]['update_time'] = $v['update_time'] ? date('Y-m-d H:i:s', $v['update_time']) : '无';
            $list[$k]['api_num'] = $this->Db->name('api')->where('item_id', $v['id'])->count();
        }
        
        $this->Db->return();
        return $this->returnTable($list, $total);
    }
}



