<?php
// +----------------------------------------------------------------------
// | 编辑项目
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Item;
use app\controller\SuperClass\Admin;

class update extends Admin
{
    /**
     * @RequestMapping(route="/item/update", method="GET", title="编辑项目")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $domain = $this->Db->name('domain')->order('id ASC')->select();
        $this->assign('domain', $domain);
        $return = $this->Db->name('return')->where('status', 1)->order('id ASC')->select();
        $this->assign('return', $return);
        
        $info = $this->Db->name('item')->where('id', $param['id'])->find();
        $this->assign('info', $info);	

        $this->Db->return();
        return $this->display('item/update');
    }

    /**
     * @RequestMapping(route="/item/update_ajax", method="post", title="提交数据")
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入项目名称")
     * @Param(name="domain_id", empty="true", tips="请选择默认根域名")
     * @Param(name="return_id", empty="true", tips="请选择默认返回值结构")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $param['update_time'] = time();
        $param['title'] = $param['title'];
        $param['des'] = $param['des'];
        $param['domain_id'] = $param['domain_id'];
        $param['return_id'] = $param['return_id'];
        $param['pwd'] = $param['pwd'];
        $param['content'] = $param['content'];

        $res = $this->Db->name('item')->where('id', $param['id'])->update($param);
        $this->Db->return();
        if ($res) {
            return $this->returnJson('00', '修改成功');
        }	
        return $this->returnJson('01', '修改失败');
    }
}



