<?php
// +----------------------------------------------------------------------
// | 登录
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller;
use app\controller\SuperClass\Admin;

class Login extends Admin
{
    public static $all;

    /**
     * @RequestMapping(route="/", method="GET", title="登录入口")
    */
    public function run() {
        if (\x\Session::has('admin')) {
            return $this->redirect('/main');
        }
        return $this->display('login/index');
    }
     /**
     * @RequestMapping(route="/login/out", method="GET", title="退出")
    */
    public function out() {
        \x\Session::clear();
        return $this->redirect('/');
    }
    /**
     * @RequestMapping(route="/login/handle", method="POST", title="登录验证码")
     * @Param(name="name", type="string", empty="true", tips="请输入用户名")
     * @Param(name="pwd", type="string", empty="true", tips="请输入密码")
    */
    public function handle() {
        $param = \x\Request::post();

        $httpClient = new \x\Client();
        $res = $httpClient->http()
                ->domain('https://blog.junphp.com/api/geetest_captcha/php/v1/ajax_vif.php')
                ->body([
                    'appid' => 'blog.junphp.com',
                    'junphp_session_id' => $param['junphp_session_id'],
                    'junphp_appkey' => $param['junphp_appkey'],
                    'junphp_sign' => $param['junphp_sign'],
                    'junphp_time' => $param['junphp_time'],
                    'junphp_geetest' => $param['junphp_geetest'],
                    'junphp_yes' => $param['junphp_yes'],
                ])
                ->post();
        $arr = json_decode($res, true);
        if ($arr['code'] != '00') {
            return $this->fetch($res);
        }
        $this->Db = new \x\Db();

        $admin = $this->Db->name('admin')->where('name', $param['name'])->find();
        if (!$admin) {
            $this->Db->return();
            return $this->returnJson('01', '账号 或 密码错误');
        }

        if ($admin['pwd'] != md5($param['pwd'].$admin['create_time'])) {
            $this->Db->return();
            return $this->returnJson('01', '账号 或 密码错误');
        }

        \x\Session::set('admin', $admin);
        $this->Db->return();
        return $this->returnJson('00', '登录成功');
    }
}



