<?php
// +----------------------------------------------------------------------
// | 主页
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller;
use app\controller\SuperClass\Admin;

/**
 * @Test()
*/
class Main extends Admin
{

    /**
     * @Test(class="Index")
     * @Test(class="Index2", name="run")
     * @RequestMapping(route="/main", method="GET", title="后台fr框架")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        return $this->display('main/index');
    }

    /**
     * @RequestMapping(route="/main/edit", method="GET", title="编辑资料")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function edit() {
        return $this->display('main/edit');
    }

    /**
     * @RequestMapping(route="/main/edit_ajax", method="POST", title="编辑资料-处理")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function edit_ajax() {
        $param = \x\Request::post();
        $data = [
            'nick' => $param['nick'],
            'name' => $param['name'],
        ];
        if ($param['pwd']) {
            $create_time = $this->Db->name('admin')->where('id', 1)->value('create_time');
            $data['pwd'] = md5($param['pwd'].$create_time);
        }
        $res = $this->Db->name('admin')->where('id', 1)->update($data);
        $this->Db->return();
        if ($res !== false) {
            return $this->returnJson('00', '修改成功');
        }	
        return $this->returnJson('01', '修改失败');
    }

    /**
     * @RequestMapping(route="/index/index", method="GET", title="主页面")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function inedx() {
        $this->Db->return();
        return $this->display('index/index');
    }
}



