<?php
// +----------------------------------------------------------------------
// | 添加返回值结构
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Ret;
use app\controller\SuperClass\Admin;

class create extends Admin
{
    /**
     * @RequestMapping(route="/ret/create", method="GET", title="添加返回值结构")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        $this->assign('param_list', param_list());
        return $this->display('ret/create');
    }

    /**
     * @RequestMapping(route="/ret/create_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入名称")
     * @Param(name="list", empty="true", tips="请创建参数结构")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $is_code = false;
        $is_data = false;
        foreach ($param['list'] as $v) {
            if (empty($v['field'])) {
                $this->Db->return();
                return $this->returnJson('01', '字段名不能为空');
            }
            if ($v['is_code'] == 1) {
                if ($is_code == true) {
                    $this->Db->return();
                    return $this->returnJson('01', '为Code条件的字段只能存在一个');
                }
                $is_code = true;
            }
            if ($v['is_data'] == 1) {
                if ($is_data == true) {
                    $this->Db->return();
                    return $this->returnJson('01', '为Data返回值的字段只能存在一个');
                }
                $is_data = true;
            }
        }
        if ($is_code == false) {
            $this->Db->return();
            return $this->returnJson('01', '请先选择为Code条件的字段');
        }
        if ($is_data == false) {
            $this->Db->return();
            return $this->returnJson('01', '请先选择为Data返回值的字段');
        }
        $data = [];
        $data['create_time'] = time();
        $data['title'] = $param['title'];
        $data['return_type'] = $param['return_type'];

        $pid = $this->Db->name('return')->insertGetId($data);
        if ($pid) {
            foreach ($param['list'] as $k=>$v) {
                $v['pid'] = $pid;
                $v['sort'] = $k;
                $this->Db->name('return_field')->insert($v);
            }
            $this->Db->return();
            return $this->returnJson('00', '添加成功');
        }	
        $this->Db->return();
        return $this->returnJson('01', '添加失败');
    }
}



