<?php
// +----------------------------------------------------------------------
// | 返回值结构列表
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Ret;
use app\controller\SuperClass\Admin;

class index extends Admin
{
    /**
     * @RequestMapping(route="/ret/index", method="GET", title="返回值结构列表")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        return $this->display('ret/index');
    }

    /**
     * @RequestMapping(route="/ret/index_ajax", method="GET", title="拉取数据")
     * @Param(name="page", value="1", tips="分页")
     * @Param(name="limit", value="10", tips="条数")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::get();

        $total = $this->Db->name('return')->count();
        $list = $this->Db->name('return')->order('id DESC')->page($param['page'], $param['limit'])->select();

        foreach ($list as $k=>$v) {
            $list[$k]['create_time'] = date('Y-m-d H:i:s', $v['create_time']);
            $list[$k]['update_time'] = $v['update_time'] ? date('Y-m-d H:i:s', $v['update_time']) : '无';

            $code = $this->Db->name('return_field')->where('pid', $v['id'])->where('is_code', 1)->find();
            $list[$k]['code_field'] = $code['field'];
            $list[$k]['code_title'] = $code['title'];

            $data = $this->Db->name('return_field')->where('pid', $v['id'])->where('is_data', 1)->find();
            $list[$k]['data_field'] = $data['field'];
            $list[$k]['data_title'] = $data['title'];

            $list[$k]['return_type'] = param_list($v['return_type']);
        }
        
        $this->Db->return();
        return $this->returnTable($list, $total);
    }
}



