<?php
// +----------------------------------------------------------------------
// | 编辑返回值结构
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Ret;
use app\controller\SuperClass\Admin;

class update extends Admin
{
    /**
     * @RequestMapping(route="/ret/update", method="GET", title="编辑返回值结构")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $info = $this->Db->name('return')->where('id', $param['id'])->find();
        $list = $this->Db->name('return_field')->where('pid', $param['id'])->order('sort ASC')->select();
        $this->assign('info', $info);
        $this->assign('list', $list);	
        $this->assign('param_list', param_list());

        $this->Db->return();
        return $this->display('ret/update');
    }

    /**
     * @RequestMapping(route="/ret/update_ajax", method="post", title="提交数据")
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入名称")
     * @Param(name="list", empty="true", tips="请创建参数结构")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $is_code = false;
        $is_data = false;
        foreach ($param['list'] as $v) {
            if (empty($v['field'])) {
                $this->Db->return();
                return $this->returnJson('01', '字段名不能为空');
            }
            if ($v['is_code'] == 1) {
                if ($is_code == true) {
                    $this->Db->return();
                    return $this->returnJson('01', '为Code条件的字段只能存在一个');
                }
                $is_code = true;
            }
            if ($v['is_data'] == 1) {
                if ($is_data == true) {
                    $this->Db->return();
                    return $this->returnJson('01', '为Data返回值的字段只能存在一个');
                }
                $is_data = true;
            }
        }
        if ($is_code == false) {
            $this->Db->return();
            return $this->returnJson('01', '请先选择为Code条件的字段');
        }
        if ($is_data == false) {
            $this->Db->return();
            return $this->returnJson('01', '请先选择为Data返回值的字段');
        }
        $data = [];
        $data['update_time'] = time();
        $data['title'] = $param['title'];
        $data['return_type'] = $param['return_type'];

        $res = $this->Db->name('return')->where('id', $param['id'])->update($data);
        if ($res) {
            $this->Db->name('return_field')->where('pid', $param['id'])->delete();
            foreach ($param['list'] as $k=>$v) {
                $v['pid'] = $param['id'];
                $v['sort'] = $k;
                $this->Db->name('return_field')->insert($v);
            }
            $this->Db->return();
            return $this->returnJson('00', '修改成功');
        }	
        $this->Db->return();
        return $this->returnJson('01', '修改失败');
    }
}



