<?php
// +----------------------------------------------------------------------
// | 测试任务列表
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Task;
use app\controller\SuperClass\Admin;

class task_index extends Admin
{
    /**
     * @RequestMapping(route="/task/task_index", method="GET", title="测试任务列表")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        return $this->display('task/task_index');
    }

    /**
     * @RequestMapping(route="/task/task_index_ajax", method="GET", title="拉取数据")
     * @Param(name="page", value="1", tips="分页")
     * @Param(name="limit", value="10", tips="条数")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::get();
        $where = $this->_where($param);

        $total = $this->Db->name('task')->alias('A')->join('test_template B', 'A.template_id=B.id')->where($where)->count();
        $list = $this->Db->name('task')->alias('A')
                ->join('test_template B', 'A.template_id=B.id')
                ->order('A.id DESC')
                ->field('A.*, B.title')
                ->where($where)
                ->page($param['page'], $param['limit'])
                ->select();

        foreach ($list as $k=>$v) {
            $list[$k]['start_time'] = date('Y-m-d H:i:s', $v['start_time']);
            $list[$k]['create_time'] = date('Y-m-d H:i:s', $v['create_time']);
            $list[$k]['task_start_time'] = $v['task_start_time'] ? date('Y-m-d H:i:s', $v['task_start_time']) : '无';
            $list[$k]['task_end_time'] = $v['task_end_time'] ? date('Y-m-d H:i:s', $v['task_end_time']) : '无';
            switch ($v['status']) {
                case 1: $list[$k]['status'] = '测试中'; break;
                case 2: $list[$k]['status'] = '已完成'; break;
                default: $list[$k]['status'] = '未开始'; break;
            }
        }
        $this->Db->return();
        return $this->returnTable($list, $total);
    }

    private function _where($param) {
        $where  = [];
        
        if (!empty($param['title'])) $where[] = ['B.title', 'like', '%'.$param['title'].'%'];
        if (isset($param['status']) && $param['status'] !== '') $where[] = ['A.status', '=', $param['status']];

        return $where;
    }
}



