<?php
// +----------------------------------------------------------------------
// | 添加定时测试任务
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Task;
use app\controller\SuperClass\Admin;

class timing_create extends Admin
{
    /**
     * @RequestMapping(route="/task/timing_create", method="get", title="界面")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $template = $this->Db->name('test_template')->order('id DESC')->select();
        $this->assign('template', $template);
        $this->Db->return();
        return $this->display('task/timing_create');
    }

    /**
     * @RequestMapping(route="/task/timing_create_ajax", method="post", title="提交数据")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Param(name="template_id", empty="true", tips="请选择测试模板")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $param['create_time'] = time();
        $param['template_id'] = $param['template_id'];
        $param['start_time'] = strtotime($param['start_time']);
        $param['is_timing'] = 1;

        // 测试时间是之前得
        if ($param['start_time'] <= time()) {
            $this->Db->return();
            return $this->returnJson('01', '启动时间，不能小于当前时间');
        }

        $res = $this->Db->name('task')->insert($param);
        $this->Db->return();
        if ($res) {
            return $this->returnJson('00', '添加成功');
        }	
        return $this->returnJson('01', '添加失败');
    }
}



