<?php
// +----------------------------------------------------------------------
// | 立即执行测试用例
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Task;
use app\controller\SuperClass\Admin;

class usercase_check extends Admin
{

    /**
     * @RequestMapping(route="/task/usercase_check", method="post", title="立即执行测试用例")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        
        // 1、根据任务模板，找出任务树
		$field = 'A.*, B.title as api_title, B.host_url, B.domain_id as domain_id, B.return_id as return_id, B.request_type, B.param_type, C.domain_id as domain_id2, C.return_id as return_id2';
		$tree_list = $this->Db->name('test_usecase')->alias('A')
					 ->join('api B', 'A.api_id=B.id')
					 ->join('item C', 'A.item_id=C.id')
					 ->where('A.id', $param['id'])
                     ->field($field)
					 ->select();
		// 2、根据任务模板，找齐所需参数
		foreach ($tree_list as $k=>$v) {
			// A、完善接口请求地址
            if ($v['domain_id']) {
                $domain = $this->Db->name('domain')->where('id', $v['domain_id'])->value('domain');
            } else {
                $domain = $this->Db->name('domain')->where('id', $v['domain_id2'])->value('domain');
            }
			$tree_list[$k]['host_url'] = $domain.$v['host_url'];
			// B、返回值类型
			if ($v['return_id']) {
				$return_type = $this->Db->name('return')->where('id', $v['return_id'])->value('return_type');
				$return_list = $this->Db->name('return_field')->where('pid', $v['return_id'])->field('field, is_code, is_data')->select();
            } else {
                $return_type = $this->Db->name('return')->where('id', $v['return_id2'])->value('return_type');
				$return_list = $this->Db->name('return_field')->where('pid', $v['return_id2'])->field('field, is_code, is_data')->select();
			}
			$tree_list[$k]['return_type'] = $return_type;
			// C、返回值条件字段取值
			$tree_list[$k]['return_code_field'] = '';
			$tree_list[$k]['return_data_field'] = '';
			foreach ($return_list as $val) {
				if ($val['is_code'] == 1) {
					$tree_list[$k]['return_code_field'] = $val['field'];
				} else if ($val['is_data'] == 1) {
					$tree_list[$k]['return_data_field'] = $val['field'];
				}
			}
			// D、获取API请求参数
			$tree_list[$k]['body_param'] = $this->Db->name('api_body')->where('api_id', $v['api_id'])->field('id, pid, field')->order('id ASC')->select();
			// E、获取API请求头
			$tree_list[$k]['request_param'] = $this->Db->name('api_request')->where('api_id', $v['api_id'])->field('field')->select();
			// F、先删除一些多余的字段好看些
			unset($tree_list[$k]['domain_id']);
			unset($tree_list[$k]['domain_id2']);
			unset($tree_list[$k]['return_id']);
			unset($tree_list[$k]['return_id2']);
			$tree_list[$k]['usecase_id'] = $v['id'];

			// 先拿测试用例的请求头参数 - 存在就直接换掉完事
			$request = $this->Db->name('test_usecase_request')->where('usecase_id', $v['id'])->select();
			if ($request) $tree_list[$k]['request_param'] = $request;
			// 拿测试用例的请求体参数 - 存在就直接换掉完事
			$body = $this->Db->name('test_usecase_param')->where('usecase_id', $v['id'])->field('id, pid, field, value')->select();
			foreach ($body as $key => $val) {
				$body[$key]['param_type'] = $this->Db->name('api_body')->where('api_id', $v['api_id'])->where('field', $val['field'])->value('param_type');
			}
			if ($body) $tree_list[$k]['body_param'] = $body;
        }
		$this->Db->return();
		
        // 递交给执行任务
		$obj = new \Task\Curl();
        $res = $obj->run($tree_list[0]);
        
        return $this->returnJson('00', '发送成功', $res);
    }
}



