<?php
// +----------------------------------------------------------------------
// | 添加测试模板
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Test;
use app\controller\SuperClass\Admin;

class Template_create extends Admin
{
    /**
     * @RequestMapping(route="/test/template_create", method="GET", title="添加测试模板")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        return $this->display('test/template_create');
    }

    /**
     * @RequestMapping(route="/test/template_create_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入测试模板名称")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $param['create_time'] = time();
        $param['title'] = $param['title'];
        $param['des'] = $param['des'];

        $res = $this->Db->name('test_template')->insert($param);
        $this->Db->return();
        if ($res) {
            return $this->returnJson('00', '添加成功');
        }	
        return $this->returnJson('01', '添加失败');
    }
}



