<?php
// +----------------------------------------------------------------------
// | 测试模板列表
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Test;
use app\controller\SuperClass\Admin;

class Template_index extends Admin
{
    /**
     * @RequestMapping(route="/test/template_index", method="GET", title="测试模板列表")
     * @AopBefore(class="app\aop\Auth", function="before")
    */
    public function run() {
        return $this->display('test/template_index');
    }

    /**
     * @RequestMapping(route="/test/template_index_ajax", method="GET", title="拉取数据")
     * @Param(name="page", value="1", tips="分页")
     * @Param(name="limit", value="10", tips="条数")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::get();

        $total = $this->Db->name('test_template')->count();
        $list = $this->Db->name('test_template')->order('id DESC')->page($param['page'], $param['limit'])->select();

        foreach ($list as $k=>$v) {
            $list[$k]['create_time'] = date('Y-m-d H:i:s', $v['create_time']);
            $list[$k]['update_time'] = $v['update_time'] ? date('Y-m-d H:i:s', $v['update_time']) : '无';
        }
        
        $this->Db->return();
        return $this->returnTable($list, $total);
    }
}



