<?php
// +----------------------------------------------------------------------
// | 测试模板任务树界面
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Test;
use app\controller\SuperClass\Admin;

class Template_tree extends Admin
{
   public $html = '';
    /**
     * @RequestMapping(route="/test/Template_tree", method="GET", title="测试模板任务树界面")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $this->assign('param', $param);	

        $item = $this->Db->name('item')->order('id ASC')->field('id, title')->select();
        $this->assign('item', $item);
        
        $list = $this->Db->name('test_template_tree')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->join('test_usecase D', 'A.usecase_id=D.id')
                ->field('A.*, B.title as item, C.title as api, D.title as usecase')
                ->where('A.template_id', $param['template_id'])
                ->select();
        $this->assign('list', $list);

        $list = $this->tree($list);
        $this->treeHtml($list);
        $this->assign('html', '<ul id="org" style="display:none">'.$this->html.'</ul>');
        
        $this->Db->return();
        return $this->display('test/template_tree');
    }
    // 递归树生成
    private function tree($list, $name = 'list', $pid = 0) {
        $arr = [];
        foreach ($list as $v) {
            if ($v['pid'] == $pid) {
                $v[$name] = $this->tree($list, $name, $v['id']);
                $arr[] = $v;
            }
        }
        return $arr;
    }
    // 递归树
    private function treeHtml($list, $code='') {
        foreach ($list as $kk=>$v) {
            if ($v['code'] != $code) continue;
            if ($code == '') {
                $button = '<button type="button" class="add_tree" onclick="delete_tree(\''.$v['id'].'\')"><div class="tree_left"></div>删除</button>';
                $this->html .= '<li><div>'.$v['item'].'-'.$v['api'].'-'.$v['usecase'].$button.'</div><ul>';
            } else {
                $button = '<button type="button" class="add_tree" onclick="param_tree(\''.$v['id'].'\')"><div class="tree_left"></div>请求参数设置</button>';
                $this->html .= '<li><div>'.$v['item'].'-'.$v['api'].'-'.$v['usecase'].$button.'</div><ul>';
            }

            // 查出接口下的所有code
            $lss = $this->Db->name('test_usecase_code')->where('usecase_id', $v['usecase_id'])->select();
            foreach ($lss as $val) {
                if ($val['status'] == 1) {
                    $button = '<button type="button" class="add_tree" onclick="add_tree(\''.$v['id'].'\', \''.$val['code'].'\')"><div class="tree_left"></div>继续添加测试</button>';
                    $hide = '';
                    if (!empty($v['list'])) {
                        foreach ($v['list'] as $vv) {
                            if ($vv['code'] == $val['code']) {
                                $button = '<button type="button" class="add_tree add_tree2" onclick="delete_tree(\''.$vv['id'].'\')"><div class="tree_left"></div>删除</button>';
                                $button .= '<button type="button" class="add_tree add_tree3" onclick="update_tree(\''.$vv['id'].'\', \''.$vv['sleep_time'].'\')"><div class="tree_left"></div>编辑</button>';
                                $code = $vv['code'];
                                break;
                            }
                        }
                    }
                } else {
                    $button = '';
                    $hide = 'no_click';
                    $code = '';
                }
                $this->html .= '<li><div class="'.$hide.'">状态码：'.$val['code'].$button.'</div>';
                if ($button) {
                    $this->html .= '<ul>';
                    if (!empty($v['list'])) {
                        $this->treeHtml($v['list'], $code);
                    }
                    $this->html .= '</ul>';
                }
                $this->html .= '</il>';
            }
            $this->html .= '</ul></li>';
        }
    }

}



