<?php
// +----------------------------------------------------------------------
// | 编辑测试模板树结构对应的请求参数
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Test;
use app\controller\SuperClass\Admin;

class Template_tree_param extends Admin
{
    /**
     * @RequestMapping(route="/test/template_tree_param", method="GET", title="编辑测试模板树结构对应的请求参数")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $info = $this->Db->name('test_template_tree')->where('id', $param['id'])->find();
        $this->assign('info', $info);	

        $body_list = $this->Db->name('test_template_tree_param')->where('tree_id', $info['id'])->order('id ASC')->select();
        $this->assign('body_list', $body_list);

        // 上级接口
        $top = $this->Db->name('test_template_tree')->where('id', $info['pid'])->find();// 带二级参数的
        $api_return = [];
        $list = $this->Db->name('api_return')->where('api_id', $top['api_id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $api_return[$k] = $v;
            $lt = $this->Db->name('api_return')->where('pid', $v['id'])->order('id ASC')->select();
            $api_return[$k]['list'] = $lt ?? [];
        }
        $this->assign('api_return', $api_return);

        // 带二级参数的
        $usecase_body = [];
        $list = $this->Db->name('test_usecase_param')->where('usecase_id', $info['usecase_id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $usecase_body[$k] = $v;
            $lt = $this->Db->name('test_usecase_param')->where('pid', $v['id'])->order('id ASC')->select();
            $usecase_body[$k]['list'] = $lt ?? [];
        }
        $this->assign('usecase_body', $usecase_body);
        // 带二级参数的
        $body = [];
        $list = $this->Db->name('api_body')->where('api_id', $info['api_id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $body[$k] = $v;
            $lt = $this->Db->name('api_body')->where('pid', $v['id'])->order('id ASC')->select();
            $body[$k]['list'] = $lt ?? [];
        }
        $this->assign('body', $body);

        $this->Db->return();
        return $this->display('test/template_tree_param');
    }

    /**
     * @RequestMapping(route="/test/template_tree_param_ajax", method="post", title="提交数据")
     * @Param(name="id", empty="true", tips="请输入ID")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $this->Db->name('test_template_tree_param')->where('tree_id', $param['id'])->delete();

        if (!empty($param['body'])) {
            foreach ($param['body'] as $v) {
                foreach ($v as $key=>$val) {
                    if (!is_array($val)) {
                        $cid = $this->Db->name('test_template_tree_param')->insertGetId([
                            'tree_id' => $param['id'],
                            'pid' => 0,
                            'field' => $key,
                            'api_return_id' => $val,
                        ]);
                    } else {
                        foreach ($val as $kk=>$vv) {
                            $this->Db->name('test_template_tree_param')->insertGetId([
                                'tree_id' => $param['id'],
                                'pid' => $cid,
                                'field_pid' => $key,
                                'field' => $kk,
                                'api_return_id' => $vv,
                            ]);
                        }
                    }
                }
            }
        }
        
        $this->Db->return();
        return $this->returnJson('00', '修改成功');
    }
}



