<?php
// +----------------------------------------------------------------------
// | 添加测试用例
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Test;
use app\controller\SuperClass\Admin;

class Usecase_create extends Admin
{
    /**
     * @RequestMapping(route="/test/usecase_create", method="GET", title="添加测试用例")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $item = $this->Db->name('item')->order('id ASC')->select();
        $this->assign('item', $item);

        $this->Db->return();
        return $this->display('test/usecase_create');
    }

    /**
     * @RequestMapping(route="/test/usecase_create_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入用例名称")
     * @Param(name="item_id", empty="true", tips="请选择用例所属项目组")
     * @Param(name="api_id", empty="true", tips="请选择用例所属接口")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $data = [];
        $data['create_time'] = time();
        $data['title'] = $param['title'];
        $data['item_id'] = $param['item_id'];
        $data['api_id'] = $param['api_id'];
        $pid = $this->Db->name('test_usecase')->insertGetId($data);
        if ($pid) {
            // 添加请求头部数据
            if (!empty($param['request'])) {
                foreach ($param['request'] as $k=>$v) {
                    foreach ($v as $key=>$val) {
                        $this->Db->name('test_usecase_request')->insert([
                            'usecase_id' => $pid,
                            'field' => $key,
                            'value' => $val,
                        ]);
                    }
                }
            }
            // 添加返回值状态码数据
            if (!empty($param['code'])) {
                foreach ($param['code'] as $k=>$v) {
                    foreach ($v as $key=>$val) {
                        $this->Db->name('test_usecase_code')->insert([
                            'usecase_id' => $pid,
                            'code' => $key,
                            'status' => $val,
                        ]);
                    }
                }
            }
            // 添加请求体
            if (!empty($param['body'])) {
                foreach ($param['body'] as $v) {
                    foreach ($v as $key=>$val) {
                        if (!is_array($val)) {
                            $cid = $this->Db->name('test_usecase_param')->insertGetId([
                                'usecase_id' => $pid,
                                'pid' => 0,
                                'field' => $key,
                                'value' => $val,
                            ]);
                        } else {
                            foreach ($val as $kk=>$vv) {
                                $this->Db->name('test_usecase_param')->insertGetId([
                                    'usecase_id' => $pid,
                                    'pid' => $cid,
                                    'field' => $kk,
                                    'value' => $vv,
                                ]);
                            }
                        }
                    }
                }
            }

            $this->Db->return();
            return $this->returnJson('00', '添加成功');
        }
        $this->Db->return();
        return $this->returnJson('01', '添加失败');
    }
}



