<?php
// +----------------------------------------------------------------------
// | 获取API所属参数
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Test;
use app\controller\SuperClass\Admin;

class Usecase_get extends Admin
{
    
    /**
     * @RequestMapping(route="/test/Usecase_get", method="post", title="获取API所属参数")
     * @Param(name="id", empty="true", tips="请选择用例所属接口")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        // 参数查询
        $return = [];
        $return['type_list'] = type_list();

        $request = $this->Db->name('api_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        $return['request'] = $request;

        $return_request = $this->Db->name('api_return_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        $return['return_request'] = $return_request;

        $return_code = $this->Db->name('api_return_code')->where('api_id', $param['id'])->order('sort ASC')->select();
        $return['return_code'] = $return_code;

        // 带二级参数的
        $body = [];
        $list = $this->Db->name('api_body')->where('api_id', $param['id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $body[$k] = $v;
            $lt = $this->Db->name('api_body')->where('pid', $v['id'])->order('id ASC')->select();
            $body[$k]['list'] = $lt ?? [];
        }
        $return['body'] = $body;
        
        $this->Db->return();
        return $this->returnJson('00', '获取成功', $return);
    }
}



