<?php
// +----------------------------------------------------------------------
// | 测试用例列表
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Test;
use app\controller\SuperClass\Admin;

class Usecase_index extends Admin
{
    /**
     * @RequestMapping(route="/test/usecase_index", method="GET", title="测试用例列表")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        $item = $this->Db->name('item')->order('id ASC')->select();
        $this->assign('item', $item);
        $this->Db->return();
        return $this->display('test/usecase_index');
    }

    /**
     * @RequestMapping(route="/test/usecase_index_ajax", method="GET", title="拉取数据")
     * @Param(name="page", value="1", tips="分页")
     * @Param(name="limit", value="10", tips="条数")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::get();
        $where = $this->_where($param);

        $total = $this->Db->name('test_usecase')->alias('A')
                 ->join('item B', 'A.item_id=B.id')
                 ->join('api C', 'A.api_id=C.id')
                 ->where($where)
                 ->count();
        $list = $this->Db->name('test_usecase')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->order('A.api_id ASC, A.id DESC')
                ->where($where)
                ->field('A.*, B.title as item_title, B.domain_id as domain_id2, B.return_id as return_id2, C.title as api_title, C.status, C.request_type, C.param_type, C.domain_id, C.return_id, C.host_url')
                ->select();

        foreach ($list as $k=>$v) {
            $list[$k]['create_time'] = date('Y-m-d H:i:s', $v['create_time']);
            $list[$k]['update_time'] = $v['update_time'] ? date('Y-m-d H:i:s', $v['update_time']) : '无';
            $list[$k]['status_name'] = status_list($v['status']);
            $list[$k]['request_type'] = request_list($v['request_type']);
            $list[$k]['param_type'] = param_list($v['param_type']);
            
            // 根域名
            if ($v['domain_id']) {
                $res = $this->Db->name('domain')->where('id', $v['domain_id'])->find();
            } else {
                $res = $this->Db->name('domain')->where('id', $v['domain_id2'])->find();
            }
            $list[$k]['domain_name'] = $res['title'];
            $list[$k]['domain'] = $res['domain'];
            // 返回值结构
            if ($v['return_id']) {
                $res = $this->Db->name('return')->where('id', $v['return_id'])->find();
            } else {
                $res = $this->Db->name('return')->where('id', $v['return_id2'])->find();
            }
            $list[$k]['return_type'] = param_list($res['return_type']);
        }

        $this->Db->return();
        return $this->returnTable($list, $total);
    }

    private function _where($param) {
        $where = [];

        if (!empty($param['title'])) $where[] = ['A.title', 'like', '%'.$param['title'].'%'];
        if (!empty($param['item_id'])) $where[] = ['A.item_id', '=', $param['item_id']];
        if (!empty($param['api_id'])) $where[] = ['A.api_id', '=', $param['api_id']];
        
        return $where;
    }
}



