<?php
// +----------------------------------------------------------------------
// | 修改测试用例
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller\Test;
use app\controller\SuperClass\Admin;

class Usecase_update extends Admin
{
    /**
     * @RequestMapping(route="/test/usecase_update", method="GET", title="修改测试用例")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();

        $info = $this->Db->name('test_usecase')->where('id', $param['id'])->find();
        $this->assign('info', $info);

        $item = $this->Db->name('item')->order('id ASC')->select();
        $this->assign('item', $item);

        $api = $this->Db->name('api')->where('item_id', $info['item_id'])->order('id ASC')->select();
        $this->assign('api', $api);

        // 获取预设参数
        $usecase_request = $this->Db->name('test_usecase_request')->where('usecase_id', $info['id'])->select();
        $this->assign('usecase_request', $usecase_request);
        $usecase_code = $this->Db->name('test_usecase_code')->where('usecase_id', $info['id'])->select();
        $this->assign('usecase_code', $usecase_code);
        // 带二级参数的
        $usecase_body = [];
        $list = $this->Db->name('test_usecase_param')->where('usecase_id', $info['id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $usecase_body[$k] = $v;
            $lt = $this->Db->name('test_usecase_param')->where('pid', $v['id'])->order('id ASC')->select();
            $usecase_body[$k]['list'] = $lt ?? [];
        }
        $this->assign('usecase_body', $usecase_body);

        // 参数查询
        $this->assign('type_list', type_list());
        $this->assign('request', $this->Db->name('api_request')->where('api_id', $info['api_id'])->order('sort ASC')->select());
        $this->assign('return_request', $this->Db->name('api_return_request')->where('api_id', $info['api_id'])->order('sort ASC')->select());
        $this->assign('return_code', $this->Db->name('api_return_code')->where('api_id', $info['api_id'])->order('sort ASC')->select());
        // 带二级参数的
        $body = [];
        $list = $this->Db->name('api_body')->where('api_id', $info['api_id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $body[$k] = $v;
            $lt = $this->Db->name('api_body')->where('pid', $v['id'])->order('id ASC')->select();
            $body[$k]['list'] = $lt ?? [];
        }
        $this->assign('body', $body);

        $this->Db->return();
        return $this->display('test/usecase_update');
    }

    /**
     * @RequestMapping(route="/test/usecase_update_ajax", method="post", title="提交数据")
     * @Param(name="title", empty="true", tips="请输入用例名称")
     * @Param(name="item_id", empty="true", tips="请选择用例所属项目组")
     * @Param(name="api_id", empty="true", tips="请选择用例所属接口")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function ajax() {
        $param = \x\Request::post();
        $data = [];
        $data['update_time'] = time();
        $data['title'] = $param['title'];
        $data['item_id'] = $param['item_id'];
        $data['api_id'] = $param['api_id'];
        $res = $this->Db->name('test_usecase')->where('id', $param['id'])->update($data);
        if ($res) {
            $pid = $param['id'];
            // 删除原先的数据
            $this->Db->name('test_usecase_request')->where('usecase_id', $pid)->delete();
            $this->Db->name('test_usecase_code')->where('usecase_id', $pid)->delete();
            $this->Db->name('test_usecase_param')->where('usecase_id', $pid)->delete();
            // 添加请求头部数据
            if (!empty($param['request'])) {
                foreach ($param['request'] as $k=>$v) {
                    foreach ($v as $key=>$val) {
                        $this->Db->name('test_usecase_request')->insert([
                            'usecase_id' => $pid,
                            'field' => $key,
                            'value' => $val,
                        ]);
                    }
                }
            }
            // 添加返回值状态码数据
            if (!empty($param['code'])) {
                foreach ($param['code'] as $k=>$v) {
                    foreach ($v as $key=>$val) {
                        $this->Db->name('test_usecase_code')->insert([
                            'usecase_id' => $pid,
                            'code' => $key,
                            'status' => $val,
                        ]);
                    }
                }
            }
            // 添加请求体
            if (!empty($param['body'])) {
                foreach ($param['body'] as $v) {
                    foreach ($v as $key=>$val) {
                        if (!is_array($val)) {
                            $cid = $this->Db->name('test_usecase_param')->insertGetId([
                                'usecase_id' => $pid,
                                'pid' => 0,
                                'field' => $key,
                                'value' => $val,
                            ]);
                        } else {
                            foreach ($val as $kk=>$vv) {
                                $this->Db->name('test_usecase_param')->insertGetId([
                                    'usecase_id' => $pid,
                                    'pid' => $cid,
                                    'field' => $kk,
                                    'value' => $vv,
                                ]);
                            }
                        }
                    }
                }
            }

            $this->Db->return();
            return $this->returnJson('00', '修改成功');
        }
        $this->Db->return();
        return $this->returnJson('01', '修改失败');
    }
}



