<?php
// +----------------------------------------------------------------------
// | 前端页面控制器
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace app\controller;
use app\controller\SuperClass\Reception;

class Token extends Reception
{

    /**
     * @RequestMapping(route="/doc", method="GET", title="API文档查看主页")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        if (empty($param['token'])) {
            $this->Db->return();
            return $this->fetch('NO~');
        }
        $info = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$info) {
            $this->Db->return();
            return $this->fetch('NO~');
        }
        $this->assign('param', $param);
        $this->assign('item', $info);
        $this->assign('login', \x\Cookie::get($param['token']));

        // 获取状态码大全
        $code = $this->Db->name('api')->alias('A')
                ->join('api_return_code B', 'A.id = B.api_id')
                ->where('A.item_id', $info['id'])
                ->where('A.display', 1)
                ->where('B.code', '<>', "")
                ->order('B.code ASC')
                ->group('B.code')
                ->field('B.*')
                ->select();
        if (count($code) == 1) {
            if ($code[0]['api_id'] === null) {
                $code = []; 
            }
        }
        $this->assign('code', $code);

        // API列表大全
        $api = $this->Db->name('api')->alias('A')
                ->join('api_group B', 'A.group_id=B.id')
                ->where('A.display', 1)
                ->where('A.item_id', $info['id'])
                ->order('A.id ASC')
                ->field('A.*, B.title as group_title')
                ->select();
        $this->assign('api', $api);
        $time = 0;
        foreach ($api as $v) {
            if ($v['update_time'] > $time) $time = $v['update_time'];
        }
        if ($time <= 0) {
            $time = time();
        }
        $this->assign('time', $time);

        $group = $this->Db->name('api_group')->where('item_id', $info['id'])->order('sort DESC, id DESC')->select();
        $this->assign('group', $group);

        $this->Db->return();
        return $this->display('token/api_doc');
    }
    
    /**
     * @RequestMapping(route="/token/api_detail_ajax", method="POST", title="API文档获取接口详情")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function api_detail_ajax() {
        $param = \x\Request::post();
        $return = [];
        $return['type_list'] = type_list();
        if (empty($param['token'])) {
            $this->Db->return();
            return $this->returnJson('01', '非法请求');
        }
        $item = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$item) {
            $this->Db->return();
            return $this->returnJson('01', '非法请求');
        }
        if (!empty($item['pwd']) && $item['pwd'] != \x\Cookie::get($param['token'])) {
            $this->Db->return();
            return $this->returnJson('01', '您已掉线，请刷新页面重新登陆');
        }
        
        // 参数查询
        $info = $this->Db->name('api')->where('display', 1)->where('id', $param['id'])->find();
        $info['status'] = status_list($info['status']);
        $info['type'] = request_list($info['request_type']);
        $info['param'] = param_list($info['param_type']);
        
        $info['update_time'] = date('Y-m-d H:i:s', ($info['update_time'] ?: time()));
        // 根域名
        if ($info['domain_id']) {
            $res = $this->Db->name('domain')->where('id', $info['domain_id'])->find();
        } else {
            $res = $this->Db->name('domain')->where('id', $item['domain_id'])->find();
        }
        $info['host_url'] = $res['domain'].$info['host_url'];
        if (stripos($res['domain'], 'https') !== false) {
            $info['http'] = 'HTTPS';
        } else {
            $info['http'] = 'HTTP';
        }
        // 返回值结构
        if ($info['return_id']) {
            $res = $this->Db->name('return')->where('id', $info['return_id'])->find();
        } else {
            $res = $this->Db->name('return')->where('id', $item['return_id'])->find();
        }
        $info['return_type'] = param_list($res['return_type']);
        $return['info'] = $info;

        // 返回值字段结构
        $return['return_field'] = $this->Db->name('return_field')->where('pid', $res['id'])->order('sort ASC')->select();

        $examples = $this->Db->name('api_examples')->where('api_id', $param['id'])->find();
        $return['examples'] = $examples;

        $request = $this->Db->name('api_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        $return['request'] = $request;

        $return_request = $this->Db->name('api_return_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        $return['return_request'] = $return_request;

        $return_code = $this->Db->name('api_return_code')->where('api_id', $param['id'])->order('sort ASC')->select();
        $return['return_code'] = $return_code;

        // 带二级参数的
        $body = [];
        $list = $this->Db->name('api_body')->where('api_id', $param['id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $body[$k] = $v;
            $lt = $this->Db->name('api_body')->where('pid', $v['id'])->order('id ASC')->select();
            $body[$k]['list'] = $lt ?? [];
        }
        $return['body'] = $body;

        $return_list = [];
        $list = $this->Db->name('api_return')->where('api_id', $param['id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $return_list[$k] = $v;
            $lt = $this->Db->name('api_return')->where('pid', $v['id'])->order('id ASC')->select();
            $return_list[$k]['list'] = $lt ?? [];
        }
        $return['return'] = $return_list;

        $this->Db->return();
        return $this->returnJson('00', '获取成功', $return);
    }

    /**
     * @RequestMapping(route="/token/api_doc_login_handle", method="POST", title="API文档密码校验")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function api_doc_login_ajax() {
        $param = \x\Request::post();
        $httpClient = new \x\Client();
        $res = $httpClient->http()
                ->domain('https://blog.junphp.com/api/geetest_captcha/php/v1/ajax_vif.php')
                ->body([
                    'appid' => 'blog.junphp.com',
                    'junphp_session_id' => $param['junphp_session_id'],
                    'junphp_appkey' => $param['junphp_appkey'],
                    'junphp_sign' => $param['junphp_sign'],
                    'junphp_time' => $param['junphp_time'],
                    'junphp_geetest' => $param['junphp_geetest'],
                    'junphp_yes' => $param['junphp_yes'],
                ])
                ->post();
        $arr = json_decode($res, true);
        if ($arr['code'] != '00') {
            $this->Db->return();
            return $this->fetch($res);
        }

        if (empty($param['token']) || empty($param['pwd'])) {
            $this->Db->return();
            return $this->returnJson('01', '校验失败');
        }
        $info = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$info) {
            $this->Db->return();
            return $this->returnJson('01', '校验失败');
        }
        if ($param['pwd'] != $info['pwd']){
            $this->Db->return();
            return $this->returnJson('01', '校验失败');
        }

        \x\Cookie::set($param['token'], $info['pwd']);

        $this->Db->return();
        return $this->returnJson('00', '校验通过');
    }

    /**
     * @RequestMapping(route="/task_details", method="GET", title="测试报告详情")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function task_details() {
        $param = \x\Request::get();
        $this->assign('type_list', type_list());
        $info = $this->Db->name('task_log')->where('id', $param['id'])->find();
        $info['body_json'] = str_replace(["\\r", "\\n"], "", $info['body_json']);
        $info['request_json'] = str_replace(["\\r", "\\n"], "", $info['request_json']);
        $info['return_json'] = str_replace(["\\r", "\\n"], "", $info['return_json']);
        $this->assign('info', $info);	
        
        $request = $this->Db->name('api_request')->where('api_id', $info['api_id'])->order('sort ASC')->select();
        $this->assign('request', $request);

        // 带二级参数的
        $body = [];
        $list = $this->Db->name('api_body')->where('api_id', $info['api_id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $body[$k] = $v;
            $lt = $this->Db->name('api_body')->where('pid', $v['id'])->order('id ASC')->select();
            $body[$k]['list'] = $lt ?? [];
        }
        $this->assign('body', $body);

        $this->Db->return();
        return $this->display('token/task_details');
    }

    public $html = '';
    /**
     * @RequestMapping(route="/task_log", method="GET", title="测试报告")
     * @AopBefore(class="app\aop\Auth", function="before")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function task_log() {
        $param = \x\Request::get();

        $info = $this->Db->name('task')->where('id', $param['id'])->find();
        $param['template_id'] = $info['template_id'];
        $this->assign('param', $param);	

        $item = $this->Db->name('item')->order('id ASC')->field('id, title')->select();
        $this->assign('item', $item);
        
        $list = $this->Db->name('test_template_tree')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->join('test_usecase D', 'A.usecase_id=D.id')
                ->join('item E', 'C.item_id=E.id')
                ->field('A.*, B.title as item, C.title as api, C.host_url, C.domain_id, C.return_id, D.title as usecase, E.domain_id as domain_id2, E.return_id as return_id2')
                ->where('A.template_id', $info['template_id'])
                ->select();
        foreach ($list as $k=>$v) {
            // 根域名
            if ($v['domain_id']) {
                $res = $this->Db->name('domain')->where('id', $v['domain_id'])->field('domain')->find();
            } else {
                $res = $this->Db->name('domain')->where('id', $v['domain_id2'])->field('domain')->find();
            }
            $list[$k]['host_url'] = $res['domain'].$v['host_url'];
        }
        $this->assign('list', $list);

        $list = $this->tree($list);
        $this->treeHtml($list, '', $param['id']);
        $this->assign('html', '<ul id="org" style="display:none">'.$this->html.'</ul>');
        
        $this->Db->return();
        return $this->display('token/task_log');
    }
    
    // 递归树生成
    private function tree($list, $name = 'list', $pid = 0) {
        $arr = [];
        foreach ($list as $v) {
            if ($v['pid'] == $pid) {
                $v[$name] = $this->tree($list, $name, $v['id']);
                $arr[] = $v;
            }
        }
        return $arr;
    }
    // 递归树
    private function treeHtml($list, $code='', $task_id) {
        $css2 = 'style="background-color: #333;color: #fff;padding: 5px 10px;border-radius: 5px;"';
        foreach ($list as $kk=>$v) {
            if ($v['code'] != $code) continue;
            // 查询有没有报告
            $button = '';
            $res = $this->Db->name('task_log')->where('task_id', $task_id)->where('tree_id', $v['id'])->field('id')->find();
            if ($code == '') {
                if ($res) {
                    $css = 'style="background-color: #008456;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                    $button = '<button type="button" class="add_tree" onclick="get_test_doc(\''.$res['id'].'\')"><div class="tree_left"></div>查看报告</button>';
                } else {
                    $css = 'style="background-color: red;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                }
                $this->html .= '<li><div title="接口地址：'.$v['host_url'].'" '.$css.'>【'.$v['item'].'】'.$v['api'].'-'.$v['usecase'].$button.'</div><ul>';
            } else {
                if ($res) {
                    $css = 'style="background-color: #008456;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                    $button = '<button type="button" class="add_tree" onclick="get_test_doc(\''.$res['id'].'\')"><div class="tree_left"></div>查看报告</button>';
                } else {
                    $css = 'style="background-color: red;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                }
                $this->html .= '<li><div title="接口地址：'.$v['host_url'].'" '.$css.'>【'.$v['item'].'】'.$v['api'].'-'.$v['usecase'].$button.'</div><ul>';
            }

            // 查出接口下的所有code
            $lss = $this->Db->name('test_usecase_code')->where('usecase_id', $v['usecase_id'])->select();
            foreach ($lss as $val) {
                if ($val['status'] == 1) {
                    $hide = '';
                    if (!empty($v['list'])) {
                        foreach ($v['list'] as $vv) {
                            if ($vv['code'] == $val['code']) {
                                $code = $vv['code'];
                                break;
                            }
                        }
                    }
                } else {
                    $hide = 'no_click';
                    $code = '';
                }
                $this->html .= '<li><div '.$css2.' class="'.$hide.'">状态码：'.$val['code'].'</div>';
                    $this->html .= '<ul>';
                    if (!empty($v['list'])) {
                        $this->treeHtml($v['list'], $code, $task_id);
                    }
                    $this->html .= '</ul>';
                $this->html .= '</il>';
            }
            $this->html .= '</ul></li>';
        }
    }
}



