<?php
// +----------------------------------------------------------------------
// | 3、执行任务
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------
namespace Task;

class Curl {
	/**
	 * 启动入口
	 * @todo 无
	 * @author 小黄牛
	 * @version v1.2.11 + 2020.08.06
	 * @deprecated 暂不启用
	 * @global 无
	 * @param list[1] $info 需要发送的请求信息
	 * @param list[2] $tree_list 完整的任务树
	 * @param int $task_id 报告ID
	 * @return void
	*/
	public function run($info, $tree_list=[], $task_id=0) {
		// 判断是否需要休眠等待
		if (!empty($info['sleep_time'])) {
			if ($info['sleep_time'] > 0) {
				// 秒
				\Swoole\Coroutine\System::sleep($info['sleep_time']);
			}
		}
		// 组装请求的必备参数
		$api_url = $info['host_url']; // 接口地址
		$param_type = $info['param_type']; // 请求类型 1.数组 2.JSON 3.XML
		$request_param = []; // 请求头
		if (!empty($info['request_param'])) {
			foreach ($info['request_param'] as $v) {
				if (isset($v['value'])) $request_param[$v['field']] = $v['value'];
			}
		}
		// 常规用例请求体
		$body_param = [];// 请求体
		if (!empty($info['body_param'])) {
			$list = $info['body_param'];
			foreach ($list as $k=>$v) {
				foreach ($list as $key=>$val) {
					if ($val['pid'] == $v['id']) {
						$list[$k]['list'][] = $val;
					}
				}
			}
			foreach ($list as $v) {
				if (!empty($v['list'])) {
					$body_param[$v['field']] = [];
					foreach ($v['list'] as $val) {
						if (isset($val['value'])) $body_param[$v['field']][$val['field']] = $val['value'];
					}
					// 特殊处理，需要转JSON
					if ($v['param_type'] == 5) {
						$body_param[$v['field']] = json_encode($body_param[$v['field']], JSON_UNESCAPED_UNICODE);
					}
					// 如果有自定义的参数，就用自定义的，多维数组没办法兼容啊
					if (!empty($v['value'])) {
						$body_param[$v['field']] = $v['value'];
					}
				} else {
					if (isset($v['value'])) $body_param[$v['field']] = $v['value'];
				}
			}
		}
		// 从上一个接口的返回值中获取
		if (!empty($info['return_data']) && !empty($info['tree_param'])) {
			$return_data = $info['return_data'];
			$Db = new \x\Db();
			foreach ($info['tree_param'] as $v) {
				// 查询出API
				$arr = $Db->name('api_return')->alias('A')
					   ->join('api_return B', 'A.pid = B.id', 'LEFT')
					   ->field('A.field, B.field as field_pid')
					   ->where('A.id', $v['api_return_id'])
					   ->find();
				if (!empty($arr['field_pid'])) {
					if (!empty($return_data[$arr['field_pid']][$arr['field']])) {
						if (!empty($v['field_pid'])) {
							$body_param[$v['field_pid']][$v['field']] = $return_data[$arr['field_pid']][$arr['field']];
						} else {
							$body_param[$v['field']] = $return_data[$arr['field_pid']][$arr['field']];
						}
					}
				} else if (!empty($return_data[$arr['field']])) {
					if (!empty($v['field_pid'])) {
						$body_param[$v['field_pid']][$v['field']] = $return_data[$arr['field']];
					} else {
						$body_param[$v['field']] = $return_data[$arr['field']];
					}
				}
			}
			$Db->return();
		}
		// 组装记录日志
		$DbData = [
			'task_id' => $task_id,
			'template_id' => $info['template_id']??false,
			'tree_id' => $info['id'],
			'item_id' => $info['item_id'],
			'api_id' => $info['api_id'],
			'usecase_id' => $info['usecase_id'],
			'api_title' => $info['api_title'],
			'api_url' => $api_url,
			'request_type' => $info['request_type'],
			'param_type' => $param_type,
			'create_time' => time(),
		];

		// 根据请求类型设置请求类型
		if ($param_type == 1) { // 表单
			$DbData['request_json'] = json_encode($request_param);
			$DbData['body_json'] = json_encode($body_param);
		} else if ($param_type == 2) { // JSON
			$body_param = json_encode($body_param);
			$request_param['Content-Type'] = 'application/json; charset=utf-8';
			$request_param['Content-Length'] = strlen($body_param);

			$DbData['request_json'] = json_encode($request_param);
			$DbData['body_json'] = $body_param;
		} else if ($param_type == 3) { // XML
			$request_param['Content-Type'] = 'text/xml; charset=utf-8';
			
			$DbData['request_json'] = json_encode($request_param);
			$DbData['body_json'] = json_encode($body_param);

			$body_param = $this->array2xml($body_param);
		}
		// 发送请求
		$httpClient = new \x\Client();
        $http = $httpClient->http()
                ->domain($api_url)
                ->set([
                    'timeout' => 60 // 请求最长耗时
                ])
                ->setHeaders($request_param)
				->body($body_param?:array());
		// 设置cookies
        if (!empty($info['cookie'])) {
			$http->setCookies($info['cookie']);
		}
		// 设置Post参数
		// 执行请求
		if ($info['request_type'] == 2) {
			$http->setMethod('POST');   
			$body = $http->post();
		} else {
			$body = $http->get();
		}

		// 获取cookie
		$cookie = $http->cookies();
        // 获取请求状态码
		$statusCode = $http->statusCode();
		$err_code = $http->errCode();
		// 解析返回值
		if ($info['return_type'] == 2) {
			$body = json_decode($body, true);
		} if ($info['return_type'] == 3) {
			$body = $this->xml2array($body);
		}
		$DbData['return_json'] = json_encode($body);
		$DbData['status_code'] = $statusCode;
		$DbData['err_code'] = $err_code;

		// 执行失败
        if ($err_code || $statusCode != 200) {
			// 终止执行 - 更新本条记录
			if ($task_id) {
				$Db = new \x\Db();
				// 更新任务状态
				$Db->name('task')->where('id', $task_id)->update([
					'status' => 2,
					'task_end_time' => time(),
				]);
				// 添加任务记录
				$Db->name('task_log')->insert($DbData);
				$Db->return();
			}
        } else {
            if ($task_id) {
				$Db = new \x\Db();
				// 获取返回状态码
				$code = $body[$info['return_code_field']] ?? '';
				// 获取返回值
				$return_data = $body[$info['return_data_field']] ?? [];

				// 添加任务记录
				$Db->name('task_log')->insert($DbData);

				$tree_info = [];
				foreach ($tree_list as $val) {
					$pid_code = str_replace(' ', '', $val['code']);
					// var_dump($val['pid'] .'=='. $info['id'].' | '.$pid_code .'=='. $code);
					if ($val['pid'] == $info['id'] && $pid_code == $code) {
						$tree_info = $val;
						break;
					}
				}

				// 判断是否有下一步
				if ($tree_info) {
					// 更新任务成功深度
					$Db->name('task')->where('id', $task_id)->setInc('success_num', 1);
					$Db->return();
					// 3、继续递归循环请求发送
					$obj = new \Task\LoopSend();
					$obj->run($task_id, $tree_info, $tree_list, $return_data, $cookie);
				} else {
					// 更新任务状态
					$Db->name('task')->where('id', $task_id)->update([
						'status' => 2,
						'task_end_time' => time(),
					]);
					$Db->return();
					$this->send_email($task_id, '/task_log.html?id=');
				}
			}
		}
		
		// 直接调用则返回结果
		if ($DbData['template_id'] === false) {
			$DbData['template_id'] = 0;
			// 添加任务记录
			$Db = new \x\Db();
			$id = $Db->name('task_log')->insertGetId($DbData);
			$Db->return();
			$DbData['id'] = $id;
			$this->send_email($id, '/task_details.html?id=');
			return $DbData;
		}
		// var_dump($info);
		// var_dump($DbData);
	}

	/**
	 * 发送邮件
	 * @todo 无
	 * @author 小黄牛
	 * @version v1.2.11 + 2020.08.06
	 * @deprecated 暂不启用
	 * @global 无
	 * @return void
	*/
	private function send_email($id, $url) {
		$Db = new \x\Db();
		$admin = $Db->name('email')->where('status', 1)->select();
		$domain =  ltrim($Db->name('config')->where('id', 1)->value('domain'), '/');
		$Db->return();

		$email = '';
		foreach ($admin as $v) {
			$email .= ','.$v['email'];
		}
		$html = '<h2>测试已完成！</h2>';
		$html .= '<div><a href="'.$domain.$url.$id.'">点击查看报告</a></div>';

		$obj = new \email\Email();
		$res = $obj->run(ltrim($email, ','), 'SwooleX自动化测试平台提醒！', $html);
		unset($obj);
		return $res;
	}

	/**
     * XML转数组
     * @todo 无
     * @author 小黄牛
     * @version v1.0.1 + 2020.07.24
     * @deprecated 暂不启用
     * @global 无
     * @param xml $xml
     * @return void
    */
	public function xml2array($xml){ 
        $obj = simplexml_load_string($xml,"SimpleXMLElement", LIBXML_NOCDATA);
        return json_decode(json_encode($obj),true);
	}

	/**
	 * 数组转XML
	 * @todo 无
	 * @author 小黄牛
	 * @version v1.2.11 + 2020.08.06
	 * @deprecated 暂不启用
	 * @global 无
	 * @param array $data 要转换的数组
	 * @param bool $root 是否要根节点
	 * @return void
	*/
	public function array2xml($data, $root=true) {
		$str = '';
		if ($root) $str .= '<xml>';

		foreach ($dat as $key=>$val) {
			if (is_array($val)) {
				$child = $this->arr2xml($val, false);
				$str .= "<$key>$child</$key>";
			} else {
				$str .= "<$key><![CDATA[$val]]></$key>";
			}
		}

		if ($root) $str .= '</xml>';
		return $str;
	}
}  
