<?php
// +----------------------------------------------------------------------
// | 2、循环发送请求
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------
namespace Task;

class LoopSend {
	/**
	 * 启动入口
	 * @todo 无
	 * @author 小黄牛
	 * @version v1.2.11 + 2020.08.06
	 * @deprecated 暂不启用
	 * @global 无
	 * @param int $task_id 报告ID
	 * @param list[1] $info 需要发送的请求信息
	 * @param list[2] $tree_list 完整的任务树
	 * @param list[mixed] $return_data 上个接口的返回值
	 * @param string $cookie 上个接口的cookie
	 * @return void
	*/
	public function run($task_id, $info, $tree_list, $return_data=[], $cookie='') {
		$Db = new \x\Db();

		// 先拿测试用例的请求头参数 - 存在就直接换掉完事
		$request = $Db->name('test_usecase_request')->where('usecase_id', $info['usecase_id'])->select();
		if ($request) $info['request_param'] = $request;
		// 拿测试用例的请求体参数 - 存在就直接换掉完事
		$body = $Db->name('test_usecase_param')->where('usecase_id', $info['usecase_id'])->field('id, pid, field, value')->select();
		$api_id = $Db->name('test_usecase')->where('id', $info['usecase_id'])->value('api_id');
		foreach ($body as $k => $v) {
			$body[$k]['param_type'] = $Db->name('api_body')->where('api_id', $api_id)->where('field', $v['field'])->value('param_type');
		}
		if ($body) $info['body_param'] = $body;

		// 第一个任务
		if ($info['pid'] == 0) {
			// 修改任务信息
			$Db->name('task')->where('id', $task_id)->update(['task_start_time' => time()]);
		} else {
			// 检测是否使用上一个接口的返回值填充参数
			$info['tree_param'] = $Db->name('test_template_tree_param')->where('tree_id', $info['id'])->select();
		}
		$Db->return();
		$info['return_data'] = $return_data;
		$info['cookie'] = $cookie;

		// 递交给执行任务
		$obj = new \Task\Curl();
		$obj->run($info, $tree_list, $task_id);
	}
}  
