<?php
// +----------------------------------------------------------------------
// | 启动测试任务脚本入口
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------
namespace Task;

class Start {
	/**
	 * 启动入口
	 * @todo 无
	 * @author 小黄牛
	 * @version v1.2.11 + 2020.08.06
	 * @deprecated 暂不启用
	 * @global 无
	 * @param list[1] $info
	 * @return void
	*/
	public function run($info) {
		$Db = new \x\Db();
		// 需要流程
		// 1、根据任务模板，找出任务树
		$field = 'A.*, B.title as api_title, B.host_url, B.domain_id as domain_id, B.return_id as return_id, B.request_type, B.param_type, C.domain_id as domain_id2, C.return_id as return_id2';
		$tree_list = $Db->name('test_template_tree')->alias('A')
					 ->join('api B', 'A.api_id=B.id')
					 ->join('item C', 'A.item_id=C.id')
					 ->where('A.template_id', $info['template_id'])
					 ->field($field)
					 ->order('A.pid ASC')
					 ->select();
		// 2、根据任务模板，找齐所需参数
		foreach ($tree_list as $k=>$v) {
			// A、完善接口请求地址
            if ($v['domain_id']) {
                $domain = $Db->name('domain')->where('id', $v['domain_id'])->value('domain');
            } else {
                $domain = $Db->name('domain')->where('id', $v['domain_id2'])->value('domain');
            }
			$tree_list[$k]['host_url'] = $domain.$v['host_url'];
			// B、返回值类型
			if ($v['return_id']) {
				$return_type = $Db->name('return')->where('id', $v['return_id'])->value('return_type');
				$return_list = $Db->name('return_field')->where('pid', $v['return_id'])->field('field, is_code, is_data')->select();
            } else {
                $return_type = $Db->name('return')->where('id', $v['return_id2'])->value('return_type');
				$return_list = $Db->name('return_field')->where('pid', $v['return_id2'])->field('field, is_code, is_data')->select();
			}
			$tree_list[$k]['return_type'] = $return_type;
			// C、返回值条件字段取值
			$tree_list[$k]['return_code_field'] = '';
			$tree_list[$k]['return_data_field'] = '';
			foreach ($return_list as $val) {
				if ($val['is_code'] == 1) {
					$tree_list[$k]['return_code_field'] = $val['field'];
				} else if ($val['is_data'] == 1) {
					$tree_list[$k]['return_data_field'] = $val['field'];
				}
			}
			// D、获取API请求参数
			$tree_list[$k]['body_param'] = $Db->name('api_body')->where('api_id', $v['api_id'])->field('id, pid, field')->order('id ASC')->select();
			// E、获取API请求头
			$tree_list[$k]['request_param'] = $Db->name('api_request')->where('api_id', $v['api_id'])->field('field')->select();
			// F、先删除一些多余的字段好看些
			unset($tree_list[$k]['domain_id']);
			unset($tree_list[$k]['domain_id2']);
			unset($tree_list[$k]['return_id']);
			unset($tree_list[$k]['return_id2']);
		}

		$Db->return();
		// 3、进入递归循环请求发送
		$obj = new \Task\LoopSend();
		$obj->run($info['id'], $tree_list[0], $tree_list);
	}
}  
