<?php
// +----------------------------------------------------------------------
// | 邮件发送
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://xiuxian.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author：小黄牛
// +----------------------------------------------------------------------
namespace email;
use email\mail\Phpmailer;

class Email {
    
    /**
     * 发送邮件
     * @todo 无
     * @author 小黄牛
     * @version v1.0.0.1 + 2018.10.09
     * @deprecated 暂不弃用
     * @global 无
     * @param string $email 邮件人郵件，多个使用,逗号隔开
     * @param string $title 邮件標題
     * @param string $html 邮件内容
     * @return string|bool
    */
    public static function run($email, $title, $html) {
        $Db = new \x\Db();
        $config = $Db->name('config')->where('id', 1)->find();
        $Db->return();
        # 发送者郵件账号(推荐163)
        $send_email = $config['email_name'];
        # 实例化邮件类
        $mail = new Phpmailer();
        # 使用SMTP发送方式
        $mail->IsSMTP();
        # 运用的郵件服务商域名
        $mail->Host     = $config['email_ip'];
        # 字符串编码
        $mail->CharSet  = "utf-8";
        # 启用SMTP验证功能
        $mail->SMTPAuth = true;
        # SMTP主機需要使用TLS連線  
        if ($config['email_type']) {
            $mail->Mailer = $config['email_type'];
        }
        if ($config['email_encryption_type']) {
            // $mail->Mailer = 'SMTP';
            $mail->SMTPSecure = $config['email_encryption_type'];
        }
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false, 
                'allow_self_signed' => true
            )
        );
        # 发送者用户名
        $mail->Username = $send_email; 
        # 发送者密碼
        $mail->Password = $config['email_pwd'];
        # 郵件端口号，现在都是用的465
        $mail->Port     = $config['email_port'];
        # 发送者email地址
        $mail->From     = $send_email;
        $mail->FromName = '';
        # 你要发给谁，可以替换成任何想要接收邮件的email信箱,格式是AddAddress("收件人email","收件人姓名")
        $mail->AddAddress("$email", '系統通知信');
        # 使用HTML格式
        $mail->IsHTML(true);
        # 邮件標題
        $mail->Subject = $title;
        # 邮件内容
        $mail->Body = $html;
        # 附加資訊，可以省略
        $mail->AltBody = '';
        # 信件處理的編碼方式
	    $mail->Encoding = "base64";
        # 注意，如果你在本来运行的话，会出现SMTP Error: Could not connect to SMTP host.的报错，需要放到自己的服务器上去运行
        if (!$mail->Send()) {
            // var_dump($mail->ErrorInfo);
            return $mail->ErrorInfo;
        } else {
            return true;
        }
    }
}
