;jQuery( function() {
    // 工具提示
	if($('[data-toggle="tooltip"]')[0]) {
		$('[data-toggle="tooltip"]').tooltip({
			"container" : 'body',
		});
	}
    
    // POP弹出框
    if($('[data-toggle="popover"]')[0]) {
        $('[data-toggle="popover"]').popover();
    }
  
    // 关闭卡片
    $(document).on('click', '.card-btn-close', function() {
        $(this).closest('.card').fadeOut(150, function() {
            if ($(this).parent().children().length == 1) {
                $(this).parent().remove();
            } else {
                $(this).remove();
            }
        });
    });
  
    // 卡片收缩与打开
    $(document).on('click', '.card-btn-slide', function(){
        $(this).toggleClass('rotate-180').closest('.card').find('.card-body').slideToggle();
    });
  
    /**
     * 如果页面中需要用到滚动条，请先导入perfect-scrollbar.min.js
     */ 
    if($('.lyear-scroll')[0]) {
        $('.lyear-scroll').each(function(){
            new PerfectScrollbar(this, {
	        	swipeEasing: false,
	        	suppressScrollX: true
	        });
        });
    }
    
    // 颜色选取
	jQuery('.js-colorpicker').each(function() {
		var $colorpicker = jQuery(this);
		var $colorpickerMode = $colorpicker.data('colorpicker-mode') ? $colorpicker.data('colorpicker-mode') : 'auto';
		$colorpicker.colorpicker({
			'format': $colorpickerMode,
		});
	});
    
    // 日期选择器
    jQuery("[data-provide = 'datepicker']").each(function() {
        var options = {
            language: 'zh-CN',  // 默认简体中文
            multidateSeparator: ', ' // 默认多个日期用,分隔
        }
  
        options = $.extend( options, getDataOptions( $(this) ));
  
        if ( $(this).prop("tagName") != 'INPUT' ) {
            options.inputs = [$(this).find('input:first'), $(this).find('input:last')];
        }
  
        $(this).datepicker(options);
    });
    
    // 时间选择器
    jQuery("[data-provide = 'clockpicker']").each(function() {
        $(this).clockpicker({
            donetext: 'Done'
        });
    });
    
    // 时间日期选择器
    jQuery("[data-provide = 'datetimepicker']").each(function() {
        var options = {
            locale: moment.locale(),
        }
  
        options = $.extend( options, getDataOptions( $(this) ));
  
        if ( $(this).prop("tagName") != 'INPUT' ) {
            options.inputs = [$(this).find('input:first'), $(this).find('input:last')];
        }
        console.log(options);
        $(this).datetimepicker(options);
    });
    
    // 标签
	$('.js-tags-input').each(function() {
        var $this = $(this);
        $this.tagsInput({
			height: $this.data('height') ? $this.data('height') : '36px',
			width: '100%',
			defaultText: $this.attr("placeholder"),
			removeWithBackspace: true,
			delimiter: [',']
		});
    });
  
    // 复选框全选
	$("#check-all").change(function () {
		$("input[type='checkbox']").prop('checked', $(this).prop("checked"));
	});
    
    // iframe打开tab
 	$(document).on('click', '.js-create-tab', function(){
 	    parent.$(parent.document).data('multitabs').create({
 	        iframe : true,
 	        title : $(this).data('title') ? $(this).data('title') : '标题',
 	        url : $(this).data('url') ? $(this).data('url') : 'lyear-main.html'
 	    }, true);
 	});
    
});


// 参考国外模板的写法，获取当前的配置，以data-*（*指插件原有的配置名）
getDataOptions = function(el, castList) {
    var options = {};
    
    $.each( $(el).data(), function(key, value){
    
        key = dataToOption(key);
        
        if ( key == 'provide' ) {
            return;
        }
        options[key] = value;
    });
    
    return options;
}

dataToOption = function(name) {
    return name.replace(/-([a-z])/g, function(x){return x[1].toUpperCase();});
}