<?php
// +----------------------------------------------------------------------
// | 监听外部调用请求
// +----------------------------------------------------------------------
// | Copyright (c) 2018 https://blog.junphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小黄牛 <1731223728@qq.com>
// +----------------------------------------------------------------------

namespace event;

class onRequest
{
    /**
	 * 启动实例
	*/
    public $server;
    /**
	 * 配置项
	*/
    public $config;

    /**
     * 接收服务实例
     * @todo 无
     * @author 小黄牛
     * @version v1.1.1 + 2020.07.08
     * @deprecated 暂不启用
     * @global 无
     * @param array $config 配置项
     * @param Swoole $server
     * @return void
    */
    public function __construct($server, $config) {
        $this->server = $server;
        $this->config = $config;
    }

    /**
     * 统一回调入口
     * @todo 无
     * @author 小黄牛
     * @version v1.1.5 + 2020.07.15
     * @deprecated 暂不启用
     * @global 无
     * @param Swoole\Http\Request $request HTTP请求对象
     * @param Swoole\Http\Response $response HTTP响应对象
     * @return void
    */
    public function run($request, $response) {
        // 跨域配置设置
        if ($this->config['origin']) $response->header('Access-Control-Allow-Origin', $this->config['origin']); 
        if ($this->config['type']) $response->header('Content-Type', $this->config['type']); 
        if ($this->config['methods']) $response->header('Access-Control-Allow-Methods', $this->config['methods']); 
        if ($this->config['credentials']) $response->header('Access-Control-Allow-Credentials', $this->config['credentials']); 
        if ($this->config['headers']) $response->header('Access-Control-Allow-Headers', $this->config['headers']); 
        
        # 防止Chrome的空包
        $uri = ltrim($request->server['request_uri'], '/');
        if ($uri == 'favicon.ico') {
            $response->status(404);
            return $response->end();
        }

        // 请求注入容器
        \x\Container::getInstance()->set('request', $request);
        \x\Container::getInstance()->set('response', $response);

        // 注入调试内容
        if (\x\Config::run()->get('app.de_bug')) {
            // 请求开始时间
            \x\Container::getInstance()->set('http_start_time', microtime(true));
            // 请求开始内容消耗
            \x\Container::getInstance()->set('http_start_cpu', memory_get_usage());
        }
        
        # 开始转发路由
        $obj = new \x\Route();
        $obj->start();

        // 调用二次转发，不做重载
        $on = new \app\event\onRequest($this->server, $this->config);
        $on->run();
        
        // 销毁整个请求级容器
        \x\Container::getInstance()->clear();
    }
}

